
package MyElements::ModifyTask;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://tempuri2.org/' }

__PACKAGE__->__set_name('ModifyTask');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %taskListName_of :ATTR(:get<taskListName>);
my %id_of :ATTR(:get<id>);
my %User_of :ATTR(:get<User>);
my %modifyData_of :ATTR(:get<modifyData>);

__PACKAGE__->_factory(
    [ qw(        taskListName
        id
        User
        modifyData

    ) ],
    {
        'taskListName' => \%taskListName_of,
        'id' => \%id_of,
        'User' => \%User_of,
        'modifyData' => \%modifyData_of,
    },
    {
        'taskListName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'id' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'User' => 'MyTypes::NUser',
        'modifyData' => 'MyTypes::TaskModifyData',
    },
    {

        'taskListName' => 'taskListName',
        'id' => 'id',
        'User' => 'User',
        'modifyData' => 'modifyData',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::ModifyTask

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
ModifyTask from the namespace http://tempuri2.org/.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * taskListName

 $element->set_taskListName($data);
 $element->get_taskListName();




=back
=item * id

 $element->set_id($data);
 $element->get_id();




=back
=item * User

 $element->set_User($data);
 $element->get_User();




=back
=item * modifyData

 $element->set_modifyData($data);
 $element->get_modifyData();




=back


=head1 METHODS

=head2 new

 my $element = MyElements::ModifyTask->new($data);

Constructor. The following data structure may be passed to new():

 {
   taskListName =>  $some_value, # string
   id =>  $some_value, # int
   User =>  { value => $some_value },
   modifyData =>  { # MyTypes::TaskModifyData
     Status =>  $some_value, # string
     Description =>  $some_value, # string
     DueDate =>  $some_value, # dateTime
     AssignedTo =>  { value => $some_value },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

