package MyTypes::GetFileResponse;
use strict;
use warnings;


our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %item_of :ATTR(:get<item>);
my %properties_of :ATTR(:get<properties>);
my %data_of :ATTR(:get<data>);

__PACKAGE__->_factory(
    [ qw(        item
        properties
        data

    ) ],
    {
        'item' => \%item_of,
        'properties' => \%properties_of,
        'data' => \%data_of,
    },
    {
        'item' => 'MyTypes::SerializedItem',
        'properties' => 'MyTypes::SerializedItem',
        'data' => 'SOAP::WSDL::XSD::Typelib::Builtin::base64Binary',
    },
    {

        'item' => 'item',
        'properties' => 'properties',
        'data' => 'data',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

MyTypes::GetFileResponse

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
GetFileResponse from the namespace http://tempuri2.org/.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * item


=item * properties


=item * data




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::GetFileResponse
   item =>  { # MyTypes::SerializedItem
     Attachments =>  { # MyTypes::ArrayOfString1
       Attachment =>  $some_value, # string
     },
     Fields =>  { # MyTypes::ArrayOfField
       Field => ,
     },
   },
   properties =>  { # MyTypes::SerializedItem
     Attachments =>  { # MyTypes::ArrayOfString1
       Attachment =>  $some_value, # string
     },
     Fields =>  { # MyTypes::ArrayOfField
       Field => ,
     },
   },
   data =>  $some_value, # base64Binary
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

