package Alien::xz;

use strict;
use warnings;
use base qw( Alien::Base );

# ABSTRACT: Find or build xz
our $VERSION = '0.06'; # VERSION




sub alien_helper
{
  return {
    xz => sub { 'xz' },
  };
}




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Alien::xz - Find or build xz

=head1 VERSION

version 0.06

=head1 SYNOPSIS

In your Build.PL:

 use Module::Build;
 use Alien::xz;
 my $builder = Module::Build->new(
   ...
   configure_requires => {
     'Alien::xz' => '0',
     ...
   },
   extra_compiler_flags => Alien::xz->cflags,
   extra_linker_flags   => Alien::xz->libs,
   ...
 );
 
 $build->create_build_script;

In your Makefile.PL:

 use ExtUtils::MakeMaker;
 use Config;
 use Alien::xz;
 
 WriteMakefile(
   ...
   CONFIGURE_REQUIRES => {
     'Alien::xz' => '0',
   },
   CCFLAGS => Alien::xz->cflags . " $Config{ccflags}",
   LIBS    => [ Alien::xz->libs ],
   ...
 );

In your script or module:

 use Alien::xz;
 use Env qw( @PATH );
 
 unshift @ENV, Alien::xz->bin_dir;

=head1 DESCRIPTION

This package can be used by other CPAN modules that require xz,
the compression utility, or liblzma, which comes with it.

=head1 HELPERS

=head2 xz

 %{xz}

Returns the name of the xz command.  Usually just C<xz>.

=head1 SEE ALSO

L<Alien>, L<Alien::Base>, L<Alien::Build::Manual::AlienUser>

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
