package Archive::Libarchive::Lib::DiskRead;

use strict;
use warnings;
use 5.020;

# ABSTRACT: Private class for Arcive::Libarchive
our $VERSION = '0.05'; # VERSION

# NOTE: This document is autogenerated from the template
# maint/tt/Code.pm.tt
# Please see maint/README.md for details on updating.


package
  Archive::Libarchive::DiskRead;

use Archive::Libarchive::Lib;

my $ffi = Archive::Libarchive::Lib->ffi;

$ffi->attach( disk_can_descend => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_current_filesystem => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_current_filesystem_is_remote => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_current_filesystem_is_synthetic => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_descend => ['archive_read_disk'] => 'int' );
#$ffi->attach( disk_entry_from_file => ['archive_read_disk', 'archive_entry', 'int', undef] => 'int' );
$ffi->attach( disk_gname => ['archive_read_disk', 'sint64'] => 'string' );
$ffi->attach( disk_open => ['archive_read_disk', 'string'] => 'int' );
$ffi->attach( disk_open_w => ['archive_read_disk', 'wstring'] => 'int' );
$ffi->attach( disk_set_atime_restored => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_set_behavior => ['archive_read_disk', 'int'] => 'int' );
#$ffi->attach( disk_set_gname_lookup => ['archive_read_disk', 'opaque', undef, undef] => 'int' );
#$ffi->attach( disk_set_matching => ['archive_read_disk', 'archive', undef, 'opaque'] => 'int' );
#$ffi->attach( disk_set_metadata_filter_callback => ['archive_read_disk', undef, 'opaque'] => 'int' );
$ffi->attach( disk_set_standard_lookup => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_set_symlink_hybrid => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_set_symlink_logical => ['archive_read_disk'] => 'int' );
$ffi->attach( disk_set_symlink_physical => ['archive_read_disk'] => 'int' );
#$ffi->attach( disk_set_uname_lookup => ['archive_read_disk', 'opaque', undef, undef] => 'int' );
$ffi->attach( disk_uname => ['archive_read_disk', 'sint64'] => 'string' );

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Archive::Libarchive::Lib::DiskRead - Private class for Arcive::Libarchive

=head1 VERSION

version 0.05

=head1 SYNOPSIS

 % perldoc Archive::Libarchive

=head1 DESCRIPTION

This is a private class for L<Archive::Libarchive> see the main documentation for the public interface.

=head1 SEE ALSO

=over 4

=item L<Archive::Libarchive::Peek>

Provides an interface for listing and retrieving entries from an archive without extracting them to the local filesystem.

=item L<Archive::Libarchive::Extract>

Provides an interface for extracting arbitrary archives of any format/filter supported by C<libarchive>.

=item L<Archive::Libarchive::Unwrap>

Decompresses / unwraps files that have been compressed or wrapped in any of the filter formats supported by C<libarchive>

=item L<Archive::Libarchive>

This is the main top-level module for using C<libarchive> from
Perl.  It is the best place to start reading the documentation.
It pulls in the other classes and C<libarchive> constants so
that you only need one C<use> statement to effectively use
C<libarchive>.

=item L<Archive::Libarchive::API>

This contains the full and complete API for all of the L<Archive::Libarchive>
classes.  Because C<libarchive> has hundreds of methods, the main documentation
pages elsewhere only contain enough to be useful, and not to overwhelm.

=item L<Archive::Libarchive::Archive>

The base class of all archive classes.  This includes some common error
reporting functionality among other things.

=item L<Archive::Libarchive::ArchiveRead>

This class is used for reading from archives.

=item L<Archive::Libarchive::ArchiveWrite>

This class is for creating new archives.

=item L<Archive::Libarchive::DiskRead>

This class is for reading L<Archive::Libarchive::Entry> objects from disk
so that they can be written to L<Archive::Libarchive::ArchiveWrite> objects.

=item L<Archive::Libarchive::DiskWrite>

This class is for writing L<Archive::Libarchive::Entry> objects to disk
that have been written from L<Archive::Libarchive::ArchiveRead> objects.

=item L<Archive::Libarchive::Entry>

This class represents a file in an archive, or on disk.

=item L<Archive::Libarchive::EntryLinkResolver>

This class exposes the C<libarchive> link resolver API.

=item L<Archive::Libarchive::Match>

This class exposes the C<libarchive> match API.

=item L<Alien::Libarchive3>

If a suitable system C<libarchive> can't be found, then this
L<Alien> will be installed to provide it.

=item L<libarchive.org|http://libarchive.org/>

The C<libarchive> project home page.

=item L<https://github.com/libarchive/libarchive/wiki>

The C<libarchive> project wiki.

=item L<https://github.com/libarchive/libarchive/wiki/ManualPages>

Some of the C<libarchive> man pages are listed here.

=back

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021,2022 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
