BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.33.
use strict;
use warnings;
use 5.006;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"       => "Perl Foreign Function Interface based on libffi",
  "AUTHOR"         => "Graham Ollis <plicease\@cpan.org>, Paul Moore <gustav\@morpheus.demon.co.uk>",
  "BUILD_REQUIRES" => {
    "FFI::Build" => "0.80"
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "7.24",
    "FFI::Build"          => "0.80"
  },
  "DISTNAME"         => "FFI",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME"             => "FFI",
  "PM"               => {
    "lib/FFI.pm"         => "\$(INST_LIB)/FFI.pm",
    "lib/FFI/Library.pm" => "\$(INST_LIB)/FFI/Library.pm"
  },
  "PREREQ_PM" => {
    "FFI::Platypus" => "0.80"
  },
  "TEST_REQUIRES" => {
    "FFI::Build"    => "0.80",
    "FFI::CheckLib" => "0.06",
    "Test::More"    => "0.98"
  },
  "VERSION" => "1.14",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Build"    => "0.80",
  "FFI::CheckLib" => "0.06",
  "FFI::Platypus" => "0.80",
  "Test::More"    => "0.98"
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build