BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Copy File::Glob File::Path File::Spec FindBin Text::ParseWords base strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.38.
use strict;
use warnings;
use 5.006;
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS  = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Build Perl extensions in C with FFI",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"     => 0,
    "File::ShareDir::Install" => "0.06"
  },
  "DISTNAME"         => "Module-Build-FFI",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME"             => "Module::Build::FFI",
  "PM"               => {
    "lib/Module/Build/FFI.pm"        => "\$(INST_LIB)/Module/Build/FFI.pm",
    "lib/Module/Build/FFI/Pascal.pm" => "\$(INST_LIB)/Module/Build/FFI/Pascal.pm",
    "lib/Module/Build/FFI/Rust.pm"   => "\$(INST_LIB)/Module/Build/FFI/Rust.pm"
  },
  "PREREQ_PM" => {
    "ExtUtils::CBuilder"   => 0,
    "File::ShareDir::Dist" => 0,
    "File::Which"          => 0,
    "File::chdir"          => 0,
    "Module::Build"        => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0" => "0.000060"
  },
  "VERSION" => "0.50",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "ExtUtils::CBuilder"   => 0,
  "File::ShareDir::Dist" => 0,
  "File::Which"          => 0,
  "File::chdir"          => 0,
  "Module::Build"        => 0,
  "Test2::V0"            => "0.000060"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
  package
    MY;
  use File::ShareDir::Install qw(postamble);
}