BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Data::Dumper Exporter File::Glob File::Temp Hash::Util Scalar::Util base constant lib overload strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.47.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Write Perl extensions using Wasm",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "FFI::CheckLib"       => "0.26"
  },
  "DISTNAME"         => "Wasm",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "Wasm",
  "PM"               => {
    "lib/Test2/Plugin/Wasm.pm"              => "\$(INST_LIB)/Test2/Plugin/Wasm.pm",
    "lib/Wasm.pm"                           => "\$(INST_LIB)/Wasm.pm",
    "lib/Wasm/Func.pm"                      => "\$(INST_LIB)/Wasm/Func.pm",
    "lib/Wasm/Global.pm"                    => "\$(INST_LIB)/Wasm/Global.pm",
    "lib/Wasm/Hook.pm"                      => "\$(INST_LIB)/Wasm/Hook.pm",
    "lib/Wasm/Memory.pm"                    => "\$(INST_LIB)/Wasm/Memory.pm",
    "lib/Wasm/Table.pm"                     => "\$(INST_LIB)/Wasm/Table.pm",
    "lib/Wasm/Wasmtime.pm"                  => "\$(INST_LIB)/Wasm/Wasmtime.pm",
    "lib/Wasm/Wasmtime/Caller.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Caller.pm",
    "lib/Wasm/Wasmtime/Config.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Config.pm",
    "lib/Wasm/Wasmtime/Engine.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Engine.pm",
    "lib/Wasm/Wasmtime/ExportType.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/ExportType.pm",
    "lib/Wasm/Wasmtime/Extern.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Extern.pm",
    "lib/Wasm/Wasmtime/ExternType.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/ExternType.pm",
    "lib/Wasm/Wasmtime/FFI.pm"              => "\$(INST_LIB)/Wasm/Wasmtime/FFI.pm",
    "lib/Wasm/Wasmtime/Func.pm"             => "\$(INST_LIB)/Wasm/Wasmtime/Func.pm",
    "lib/Wasm/Wasmtime/FuncType.pm"         => "\$(INST_LIB)/Wasm/Wasmtime/FuncType.pm",
    "lib/Wasm/Wasmtime/Global.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Global.pm",
    "lib/Wasm/Wasmtime/GlobalType.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/GlobalType.pm",
    "lib/Wasm/Wasmtime/ImportType.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/ImportType.pm",
    "lib/Wasm/Wasmtime/Instance.pm"         => "\$(INST_LIB)/Wasm/Wasmtime/Instance.pm",
    "lib/Wasm/Wasmtime/Instance/Exports.pm" => "\$(INST_LIB)/Wasm/Wasmtime/Instance/Exports.pm",
    "lib/Wasm/Wasmtime/Linker.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Linker.pm",
    "lib/Wasm/Wasmtime/Memory.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Memory.pm",
    "lib/Wasm/Wasmtime/MemoryType.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/MemoryType.pm",
    "lib/Wasm/Wasmtime/Module.pm"           => "\$(INST_LIB)/Wasm/Wasmtime/Module.pm",
    "lib/Wasm/Wasmtime/Module/Exports.pm"   => "\$(INST_LIB)/Wasm/Wasmtime/Module/Exports.pm",
    "lib/Wasm/Wasmtime/Module/Imports.pm"   => "\$(INST_LIB)/Wasm/Wasmtime/Module/Imports.pm",
    "lib/Wasm/Wasmtime/Store.pm"            => "\$(INST_LIB)/Wasm/Wasmtime/Store.pm",
    "lib/Wasm/Wasmtime/Table.pm"            => "\$(INST_LIB)/Wasm/Wasmtime/Table.pm",
    "lib/Wasm/Wasmtime/TableType.pm"        => "\$(INST_LIB)/Wasm/Wasmtime/TableType.pm",
    "lib/Wasm/Wasmtime/Trap.pm"             => "\$(INST_LIB)/Wasm/Wasmtime/Trap.pm",
    "lib/Wasm/Wasmtime/ValType.pm"          => "\$(INST_LIB)/Wasm/Wasmtime/ValType.pm",
    "lib/Wasm/Wasmtime/WasiConfig.pm"       => "\$(INST_LIB)/Wasm/Wasmtime/WasiConfig.pm",
    "lib/Wasm/Wasmtime/WasiInstance.pm"     => "\$(INST_LIB)/Wasm/Wasmtime/WasiInstance.pm",
    "lib/Wasm/Wasmtime/Wat2Wasm.pm"         => "\$(INST_LIB)/Wasm/Wasmtime/Wat2Wasm.pm"
  },
  "PREREQ_PM" => {
    "Devel::GlobalDestruction"       => 0,
    "FFI::C"                         => "0.05",
    "FFI::C::StructDef"              => 0,
    "FFI::C::Util"                   => 0,
    "FFI::CheckLib"                  => "0.26",
    "FFI::Platypus"                  => "1.26",
    "FFI::Platypus::Buffer"          => 0,
    "FFI::Platypus::Record"          => 0,
    "FFI::Platypus::Type::PtrObject" => "0.02",
    "Path::Tiny"                     => 0,
    "Ref::Util"                      => 0,
    "Sub::Install"                   => 0,
    "Test2::API"                     => "1.302015",
    "Test2::Mock"                    => "0.000060",
    "autodie"                        => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => 0,
    "Test2::V0"     => "0.000060",
    "YAML"          => 0
  },
  "VERSION" => "0.11",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"                  => 0,
  "Devel::GlobalDestruction"       => 0,
  "FFI::C"                         => "0.05",
  "FFI::C::StructDef"              => 0,
  "FFI::C::Util"                   => 0,
  "FFI::CheckLib"                  => "0.26",
  "FFI::Platypus"                  => "1.26",
  "FFI::Platypus::Buffer"          => 0,
  "FFI::Platypus::Record"          => 0,
  "FFI::Platypus::Type::PtrObject" => "0.02",
  "Path::Tiny"                     => 0,
  "Ref::Util"                      => 0,
  "Sub::Install"                   => 0,
  "Test2::API"                     => "1.302015",
  "Test2::Mock"                    => "0.000060",
  "Test2::V0"                      => "0.000060",
  "YAML"                           => 0,
  "autodie"                        => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.037
if ( do { use FFI::CheckLib 0.26; !find_lib lib => 'wasmtime' } ) {
  requires( 'Alien::wasmtime', '0.09' );
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.037
sub _add_prereq {
  my ( $mm_key, $module, $version_or_range ) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
    and $WriteMakefileArgs{$mm_key}{$module} ne '0'
    and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
    and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ( $module, $version_or_range ) = @_;
  _add_prereq( PREREQ_PM => $module, $version_or_range );
}