#! perl
# Copyright (C) 2008, The Perl Foundation.
# $Id: base64.t 28954 2008-07-02 14:45:33Z bernhard $

=head1 NAME

t/php/base64.t - Standard Library base64

=head1 SYNOPSIS

    % perl -I../lib pipp/t/php/base64.t

=head1 DESCRIPTION

Tests PHP Standard Library base64
(implemented in F<languages/pipp/src/common/php_base64.pir>).

See L<http://www.php.net/manual/en/ref.url.php>.

=cut

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../../lib";

use Test::More     tests => 8;
use Parrot::Test;


language_output_is( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(str)' );
<?php
  echo base64_encode('Plum Headed Parakeet'), "\n";
?>
CODE
UGx1bSBIZWFkZWQgUGFyYWtlZXQ=
OUTPUT

language_output_like( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(no arg)' );
<?php
  echo base64_encode(), "\n";
?>
CODE
/base64_encode\(\) expects exactly 1 parameter, 0 given/
OUTPUT

language_output_is( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(3.14)' );
<?php
  echo base64_encode(3.14), "\n";
?>
CODE
My4xNA==
OUTPUT

language_output_is( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(TRUE)' );
<?php
  echo base64_encode(TRUE), "\n";
?>
CODE
MQ==
OUTPUT

language_output_is( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(NULL)' );
<?php
  echo base64_encode(NULL), "\n";
?>
CODE

OUTPUT

language_output_like( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_encode(array)' );
<?php
  $hello['world'] = 'hi';
  echo base64_encode($hello), "\n";
?>
CODE
/base64_encode\(\) expects parameter 1 to be string, array given/
OUTPUT

language_output_is( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_decode(str)' );
<?php
  echo base64_decode('UGx1bSBIZWFkZWQgUGFyYWtlZXQ='), "\n";
?>
CODE
Plum Headed Parakeet
OUTPUT

language_output_like( 'Pipp', <<'CODE', <<'OUTPUT', 'base64_decode(no arg)' );
<?php
  echo base64_decode(), "\n";
?>
CODE
/base64_decode\(\) expects at least 1 parameter, 0 given/
OUTPUT

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
