#!/usr/local/bin/perl

BEGIN {  push(@INC, './t') }
use W;

$test = W->new('1..1');
$test->result("examples/tokenizer.pl");
$test->expected(\*DATA);
print $test->report(1, sub { 
		      my $expectation =  $test->expected;
		      my $result =  $test->result;
		      $expectation =~ s/\s+$//;
#		      print STDERR "Result: $result\n";
#		      print STDERR "Expectation: $expectation\n";
		      $result =~ s/\s+$//;
		      $expectation eq $result;
		    });

__END__
Tokenization of DATA:
Line 1	Type: main::INTEGER	Content:->1<-
Line 1	Type: main::ADDOP	Content:->+<-
Line 1	Type: main::INTEGER	Content:->2<-
Line 1	Type: main::ADDOP	Content:->-<-
Line 1	Type: main::INTEGER	Content:->5<-
Line 1	Type: main::NEWLINE	Content:->
<-
Line 3	Type: main::STRING	Content:->"This is a multiline
string with an embedded "" in it"<-
Line 3	Type: main::NEWLINE	Content:->
<-
Version 1.14
Trace ON in class Parse::Lex
Token read (main::INTEGER, "[1-9][0-9]*"): 1
Token read (main::ADDOP, "[-+]"): +
Token read (main::INTEGER, "[1-9][0-9]*"): 2
Token read (main::ADDOP, "[-+]"): -
Token read (main::INTEGER, "[1-9][0-9]*"): 5
Token read (main::NEWLINE, "
"): 

Token read (main::STRING, ""): "This is a multiline
string with an embedded "" in it"
Token read (main::NEWLINE, "
"): 

Token read (main::ERROR, ".*"): this is an invalid string with a "" in it"
can't analyze: "this is an invalid string with a "" in it"" at examples/tokenizer.pl line 22, <DATA> chunk 4.

