# ref_data.t version 0.01
# A script to run tests on the Lingua::Norms::Orthon module.
# Checks correct returns of known values data
use strict;
use warnings;

use Test::More tests => 5;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Orthon') };

my $orthon = Lingua::Orthon->new();

my %dat_ref = (
    test1 => 5, # from Yarkoni et al.
    test2 => 2, # from Yarkoni et al.
    test3 => 4, # from Yarkoni et al.
    test4 => 3, # from perlmonks on Hamming.
);

my ($val, @words) = ();

# Test Levenshtein output:
@words = (qw/CHANCE STRAND/);
$val = $orthon->ldist(@words);
ok( is_equal($val, $dat_ref{'test1'}), "LOD expected $dat_ref{'test1'} observed $val" );

@words = (qw/smile similes/);
$val = $orthon->ldist(@words);
ok( is_equal($val, $dat_ref{'test2'}), "LOD expected $dat_ref{'test2'} observed $val" );

@words = (qw/pistachio hibachi/);
$val = $orthon->ldist(@words);
ok( is_equal($val, $dat_ref{'test3'}), "LOD expected $dat_ref{'test3'} observed $val" );

# Test Hamming output:
@words = ('GGAAG', 'GAAGA'); 
$val = $orthon->hdist(@words); 
ok( is_equal($val, $dat_ref{'test4'}), "LOD expected $dat_ref{'test4'} observed $val" );


sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
