# Test purgining of cases:

use strict;
use warnings;
use Test::More tests => 2;
use constant EPS => 1e-9;

use Statistics::ANOVA;
my $aov = Statistics::ANOVA->new();

my @data = ();

@data = (1, '', 3);

eval {
    $aov->load_data({dat => \@data});
};
ok(!$@, $@);

my $num = $aov->{'_purge'}->{'dat'}->{1};
ok($num == 1, "Error in purge: got $num, expected 1");

#ok( about_equal($aov->{'_stat'}->{'h_value'}, $ref_vals{'h_value'}), "Kruskal-Wallis H-value $aov->{'_stat'}->{'h_value'} = $ref_vals{'h_value'}" );
 
sub about_equal {
    return 0 if ! defined $_[0] || ! defined $_[1];
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
1;