#!/usr/bin/perl

# A simple utility to view a picture from the command line
#
# The first option should be the file name to show
# The (optional) second option is 'mali' if a MALI GPU.

use strict;

use Graphics::Framebuffer;
use Time::HiRes qw(sleep time);
# use Data::Dumper::Simple;$Data::Dumper::Sortkeys=1;

my $f = Graphics::Framebuffer->new(
#    'FB_DEVICE'   => '/dev/fb1',
    'SPLASH'      => 0,
    'SHOW_ERRORS' => 1
);

system('clear');
$f->cls('OFF');

# This centers and shows the picture by proportionally scaling the height and width
my %p = (
    'width'  => $f->{'XRES'},
    'height' => $f->{'YRES'},
    'file'   => $ARGV[0]
);
# $p{'noscale'} = 1 if ($ARGV[0] =~ /\.gif$/i);
my $image = $f->load_image(\%p);
# warn ref($image),"\n\n",Dumper($image),"\n\n";exit;
if (ref($image) eq 'ARRAY') {
    foreach my $t (1 .. 2) {
        foreach my $frame (0 .. (scalar(@{$image}) - 1)) {
            $f->blit_write($image->[$frame]);
            sleep ($image->[$frame]->{'tags'}->{'gif_delay'} / 100);
        }
    }
} else {
    $f->blit_write($image);
}
sleep 1;
$f->cls('ON');

