#!/usr/bin/perl

use strict;

use Graphics::Framebuffer;
use Time::HiRes qw(sleep);

my $wait = .5;
$wait = $ARGV[0] if (scalar(@ARGV));

my $fb = Graphics::Framebuffer->new('SPLASH' => 1,'SHOW_ERRORS'=>1);

my $adj = $fb->{'XRES'} / 1920;

$fb->cls();
# $fb->or_mode();

foreach my $font (sort(keys %{$fb->{'FONTS'}})) {
    $fb->cls();
    my $tprint = {
        'bounding_box' => 1,
        'face'         => $fb->{'FONTS'}->{$font}->{'font'},
        'center'       => 3,
        'text'         => $font,
        'font_path'    => $fb->{'FONTS'}->{$font}->{'path'},
        'color'        => 'FFFFFFFF',
        'height'       => 150 * $adj,
        'antialias'    => 1
    };
    $fb->ttf_print(
        $fb->ttf_print($tprint)
    );
    sleep $wait;
}

=head1 NAME

Available Fonts Display

=head1 DESCRIPTION

This displays (in the actual font) all of the system fonts the Graphics::Framebuffer module could find.

=head1 SYNOPSIS

 perl fonts.pl [wait time]

=head2 Example

=over 4

 perl fonts 0.75

=back

=head1 OPTIONS

=over 2

=item C<wait time> (a decimal number)

Tells the script to wait "wait time" seconds before showing the next font.  This can be fractions of a second.  The default is "0.5" seconds.

=back

=cut
