#!perl -T

use strict;
use Test::More tests => 18;

use Graphics::Framebuffer;

# Not all of these tests check for accuracy.  They only see if something
# was drawn, not if it was drawn properly.


TODO: {
    local $TODO = "Tests may fail in emulation mode";
    my $fb = Graphics::Framebuffer->new('MALI' => 1,'SPLASH' => 0);
    isa_ok($fb, 'Graphics::Framebuffer');

    $fb->cls();

    my $oldscreen = $fb->{'SCREEN'}; # Make a copy of the screen
    rcolor($fb);
    $fb->plot({'x'=>rand($fb->{'XRES'}),'y'=>rand($fb->{'YRES'}),'pixel_size'=>1 + rand(4)});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Point was plotted\n");


    my $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->plot({'x'=>0,'y'=>0,'pixel_size'=>1});
    $fb->drawto({'x'=>639,'y'=>479,'pixel_size'=>1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Line was drawn\n");

    $fb->cls();

    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/2.1,'pixel_size'=>1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Circle was drawn\n");

    $fb->cls();
    rcolor($fb);
    $oldscreen = $fb->{'SCREEN'};
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/3,'pixel_size'=>10});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Bold Circle was drawn\n");

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/2.1,'filled'=>1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled circle was drawn\n");

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->circle({'x'=>$fb->{'XRES'}/2,'y'=>$fb->{'YRES'}/2,'radius'=>$fb->{'YRES'}/2.1,'filled'=>1,'gradient' => { 'start' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256)},'end' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256) } }});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled Gradient circle was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->box({'x'=>10,'y'=>10,'xx'=>600,'yy'=>300,'filled'=>0});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Box frame was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->box({'radius' => 15,'x'=>10,'y'=>10,'xx'=>600,'yy'=>300,'filled'=>0});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Rounded Box frame was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->rbox({'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled box was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->rbox({'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1,'gradient' => { 'start' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256)},'end' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256) } }});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled Gradient box was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->rbox({'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1,'radius' => 15});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled rounded box was drawn\n");

    $fb->cls();
    $oldscreen = "$fb->{'SCREEN'}";
    rcolor($fb);
    $fb->rbox({'radius'=> 15,'x'=>20,'y'=>20,'width'=>600,'height'=>300,'filled'=>1,'gradient' => { 'start' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256)},'end' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256) } }});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled Rounded Gradient box was drawn\n");

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->polygon({'coordinates'=>[320,10,220,100,440,200,320,10],'pixel_size'=>1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Polygon was drawn\n");

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->polygon({'coordinates'=>[300,10,210,110,420,210,330,20],'pixel_size'=>1, 'filled' => 1});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled Polygon was drawn\n");

    $fb->cls();
    $oldscreen = $fb->{'SCREEN'};
    rcolor($fb);
    $fb->polygon({'coordinates'=>[300,10,210,110,420,210,330,20],'pixel_size'=>1, 'filled' => 1,'gradient' => { 'start' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256)},'end' => { 'red' => rand(256),'green' => rand(256),'blue' => rand(256) } }});
    ok(($oldscreen ne $fb->{'SCREEN'}),"Filled Gradient Polygon was drawn\n");

    $fb->cls();
    my $pixel = $fb->pixel({'x'=>100,'y'=>200});
    ok(($pixel->{'red'} == 0 && $pixel->{'green'} == 0 && $pixel->{'blue'} == 0),"Starting color of pixel is black\n");

    $fb->set_color({'red' => 255,'green' => 255, 'blue' => 255});
    $fb->plot({'x'=>100,'y'=>200,'pixel_size'=>1});
    $pixel = $fb->pixel({'x'=>100,'y'=>200});
    ok(($pixel->{'red'} == 255 && $pixel->{'green'} == 255 && $pixel->{'blue'} == 255),"Pixel color is now white\n");

}

sub rcolor {
   my $f = shift;
   $f->set_color({'red' => rand(256),'green' => rand(256), 'blue' => rand(256)});
}
