use Unicode::Collate::CJK::Big5;
+{
   locale_version => 1.22,
   overrideCJK => \&Unicode::Collate::CJK::Big5::weightBig5,
   entry => <<'ENTRY', # for DUCET v9.0.0
0101      ; [.1C47.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0061 0304 ; [.1C47.001C.0002] # LATIN SMALL LETTER A WITH MACRON
0100      ; [.1C47.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
0041 0304 ; [.1C47.001C.0008] # LATIN CAPITAL LETTER A WITH MACRON
00E1      ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0301 ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
0061 0341 ; [.1C47.001D.0002] # LATIN SMALL LETTER A WITH ACUTE
00C1      ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0301 ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
0041 0341 ; [.1C47.001D.0008] # LATIN CAPITAL LETTER A WITH ACUTE
01CE      ; [.1C47.001E.0002] # LATIN SMALL LETTER A WITH CARON
0061 030C ; [.1C47.001E.0002] # LATIN SMALL LETTER A WITH CARON
01CD      ; [.1C47.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
0041 030C ; [.1C47.001E.0008] # LATIN CAPITAL LETTER A WITH CARON
00E0      ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0300 ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
0061 0340 ; [.1C47.001F.0002] # LATIN SMALL LETTER A WITH GRAVE
00C0      ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0300 ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0041 0340 ; [.1C47.001F.0008] # LATIN CAPITAL LETTER A WITH GRAVE
0113      ; [.1CAA.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0065 0304 ; [.1CAA.001C.0002] # LATIN SMALL LETTER E WITH MACRON
0112      ; [.1CAA.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
0045 0304 ; [.1CAA.001C.0008] # LATIN CAPITAL LETTER E WITH MACRON
00E9      ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0301 ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
0065 0341 ; [.1CAA.001D.0002] # LATIN SMALL LETTER E WITH ACUTE
00C9      ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0301 ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
0045 0341 ; [.1CAA.001D.0008] # LATIN CAPITAL LETTER E WITH ACUTE
011B      ; [.1CAA.001E.0002] # LATIN SMALL LETTER E WITH CARON
0065 030C ; [.1CAA.001E.0002] # LATIN SMALL LETTER E WITH CARON
011A      ; [.1CAA.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
0045 030C ; [.1CAA.001E.0008] # LATIN CAPITAL LETTER E WITH CARON
00E8      ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0300 ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
0065 0340 ; [.1CAA.001F.0002] # LATIN SMALL LETTER E WITH GRAVE
00C8      ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0300 ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
0045 0340 ; [.1CAA.001F.0008] # LATIN CAPITAL LETTER E WITH GRAVE
00EA 0304 ; [.1CAA.0021.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
00CA 0304 ; [.1CAA.0021.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING MACRON>
0065 0302 0304 ; [.1CAA.0021.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
0045 0302 0304 ; [.1CAA.0021.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING MACRON>
1EBF      ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0301 ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
0065 0302 0341 ; [.1CAA.0022.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
1EBE      ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0301 ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
0045 0302 0341 ; [.1CAA.0022.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
00EA 0301 ; [.1CAA.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00EA 0341 ; [.1CAA.0022.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00CA 0301 ; [.1CAA.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE ACCENT>
00CA 0341 ; [.1CAA.0022.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING ACUTE TONE MARK>
00EA 030C ; [.1CAA.0023.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
00CA 030C ; [.1CAA.0023.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING CARON>
0065 0302 030C ; [.1CAA.0023.0002] # <LATIN SMALL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
0045 0302 030C ; [.1CAA.0023.0008] # <LATIN CAPITAL LETTER E, COMBINING CIRCUMFLEX ACCENT, COMBINING CARON>
1EC1      ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0300 ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
0065 0302 0340 ; [.1CAA.0024.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
1EC0      ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0300 ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
0045 0302 0340 ; [.1CAA.0024.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
00EA 0300 ; [.1CAA.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00EA 0340 ; [.1CAA.0024.0002] # <LATIN SMALL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00CA 0300 ; [.1CAA.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE ACCENT>
00CA 0340 ; [.1CAA.0024.0008] # <LATIN CAPITAL LETTER E WITH CIRCUMFLEX, COMBINING GRAVE TONE MARK>
00EA      ; [.1CAA.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
0065 0302 ; [.1CAA.0025.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX
00CA      ; [.1CAA.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0045 0302 ; [.1CAA.0025.0008] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX
1EC5      ; [.1CAA.0025.0002][.0000.002D.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
1EC4      ; [.1CAA.0025.0008][.0000.002D.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
1EC3      ; [.1CAA.0025.0002][.0000.003B.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC2      ; [.1CAA.0025.0008][.0000.003B.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
1EC7      ; [.1CAA.0025.0002][.0000.0042.0002] # LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
1EC6      ; [.1CAA.0025.0008][.0000.0042.0002] # LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
012B      ; [.1D32.001C.0002] # LATIN SMALL LETTER I WITH MACRON
0069 0304 ; [.1D32.001C.0002] # LATIN SMALL LETTER I WITH MACRON
012A      ; [.1D32.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
0049 0304 ; [.1D32.001C.0008] # LATIN CAPITAL LETTER I WITH MACRON
00ED      ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0301 ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
0069 0341 ; [.1D32.001D.0002] # LATIN SMALL LETTER I WITH ACUTE
00CD      ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0301 ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
0049 0341 ; [.1D32.001D.0008] # LATIN CAPITAL LETTER I WITH ACUTE
01D0      ; [.1D32.001E.0002] # LATIN SMALL LETTER I WITH CARON
0069 030C ; [.1D32.001E.0002] # LATIN SMALL LETTER I WITH CARON
01CF      ; [.1D32.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
0049 030C ; [.1D32.001E.0008] # LATIN CAPITAL LETTER I WITH CARON
00EC      ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0300 ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
0069 0340 ; [.1D32.001F.0002] # LATIN SMALL LETTER I WITH GRAVE
00CC      ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0300 ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
0049 0340 ; [.1D32.001F.0008] # LATIN CAPITAL LETTER I WITH GRAVE
006D 0304 ; [.1DAA.001C.0002] # <LATIN SMALL LETTER M, COMBINING MACRON>
004D 0304 ; [.1DAA.001C.0008] # <LATIN CAPITAL LETTER M, COMBINING MACRON>
1E3F      ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0301 ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
006D 0341 ; [.1DAA.001D.0002] # LATIN SMALL LETTER M WITH ACUTE
1E3E      ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0301 ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
004D 0341 ; [.1DAA.001D.0008] # LATIN CAPITAL LETTER M WITH ACUTE
006D 030C ; [.1DAA.001E.0002] # <LATIN SMALL LETTER M, COMBINING CARON>
004D 030C ; [.1DAA.001E.0008] # <LATIN CAPITAL LETTER M, COMBINING CARON>
006D 0300 ; [.1DAA.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE ACCENT>
006D 0340 ; [.1DAA.001F.0002] # <LATIN SMALL LETTER M, COMBINING GRAVE TONE MARK>
004D 0300 ; [.1DAA.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE ACCENT>
004D 0340 ; [.1DAA.001F.0008] # <LATIN CAPITAL LETTER M, COMBINING GRAVE TONE MARK>
006E 0304 ; [.1DB9.001C.0002] # <LATIN SMALL LETTER N, COMBINING MACRON>
004E 0304 ; [.1DB9.001C.0008] # <LATIN CAPITAL LETTER N, COMBINING MACRON>
0144      ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0301 ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
006E 0341 ; [.1DB9.001D.0002] # LATIN SMALL LETTER N WITH ACUTE
0143      ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0301 ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
004E 0341 ; [.1DB9.001D.0008] # LATIN CAPITAL LETTER N WITH ACUTE
0148      ; [.1DB9.001E.0002] # LATIN SMALL LETTER N WITH CARON
006E 030C ; [.1DB9.001E.0002] # LATIN SMALL LETTER N WITH CARON
0147      ; [.1DB9.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
004E 030C ; [.1DB9.001E.0008] # LATIN CAPITAL LETTER N WITH CARON
01F9      ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0300 ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
006E 0340 ; [.1DB9.001F.0002] # LATIN SMALL LETTER N WITH GRAVE
01F8      ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0300 ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
004E 0340 ; [.1DB9.001F.0008] # LATIN CAPITAL LETTER N WITH GRAVE
014D      ; [.1DDD.001C.0002] # LATIN SMALL LETTER O WITH MACRON
006F 0304 ; [.1DDD.001C.0002] # LATIN SMALL LETTER O WITH MACRON
014C      ; [.1DDD.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
004F 0304 ; [.1DDD.001C.0008] # LATIN CAPITAL LETTER O WITH MACRON
00F3      ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0301 ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
006F 0341 ; [.1DDD.001D.0002] # LATIN SMALL LETTER O WITH ACUTE
00D3      ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0301 ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
004F 0341 ; [.1DDD.001D.0008] # LATIN CAPITAL LETTER O WITH ACUTE
01D2      ; [.1DDD.001E.0002] # LATIN SMALL LETTER O WITH CARON
006F 030C ; [.1DDD.001E.0002] # LATIN SMALL LETTER O WITH CARON
01D1      ; [.1DDD.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
004F 030C ; [.1DDD.001E.0008] # LATIN CAPITAL LETTER O WITH CARON
00F2      ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0300 ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
006F 0340 ; [.1DDD.001F.0002] # LATIN SMALL LETTER O WITH GRAVE
00D2      ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0300 ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
004F 0340 ; [.1DDD.001F.0008] # LATIN CAPITAL LETTER O WITH GRAVE
016B      ; [.1EB5.001C.0002] # LATIN SMALL LETTER U WITH MACRON
0075 0304 ; [.1EB5.001C.0002] # LATIN SMALL LETTER U WITH MACRON
016A      ; [.1EB5.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
0055 0304 ; [.1EB5.001C.0008] # LATIN CAPITAL LETTER U WITH MACRON
00FA      ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0301 ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
0075 0341 ; [.1EB5.001D.0002] # LATIN SMALL LETTER U WITH ACUTE
00DA      ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0301 ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
0055 0341 ; [.1EB5.001D.0008] # LATIN CAPITAL LETTER U WITH ACUTE
01D4      ; [.1EB5.001E.0002] # LATIN SMALL LETTER U WITH CARON
0075 030C ; [.1EB5.001E.0002] # LATIN SMALL LETTER U WITH CARON
01D3      ; [.1EB5.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
0055 030C ; [.1EB5.001E.0008] # LATIN CAPITAL LETTER U WITH CARON
00F9      ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0300 ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
0075 0340 ; [.1EB5.001F.0002] # LATIN SMALL LETTER U WITH GRAVE
00D9      ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0300 ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
0055 0340 ; [.1EB5.001F.0008] # LATIN CAPITAL LETTER U WITH GRAVE
01D6      ; [.1EB5.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0075 0308 0304 ; [.1EB5.0021.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
01D5      ; [.1EB5.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0055 0308 0304 ; [.1EB5.0021.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
00FC 0304 ; [.1EB5.0021.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING MACRON>
00DC 0304 ; [.1EB5.0021.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING MACRON>
01D8      ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0301 ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0075 0308 0341 ; [.1EB5.0022.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
01D7      ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0301 ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0055 0308 0341 ; [.1EB5.0022.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
00FC 0301 ; [.1EB5.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00FC 0341 ; [.1EB5.0022.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
00DC 0301 ; [.1EB5.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE ACCENT>
00DC 0341 ; [.1EB5.0022.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING ACUTE TONE MARK>
01DA      ; [.1EB5.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0075 0308 030C ; [.1EB5.0023.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND CARON
01D9      ; [.1EB5.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0055 0308 030C ; [.1EB5.0023.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
00FC 030C ; [.1EB5.0023.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING CARON>
00DC 030C ; [.1EB5.0023.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING CARON>
01DC      ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0300 ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0075 0308 0340 ; [.1EB5.0024.0002] # LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
01DB      ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0300 ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0055 0308 0340 ; [.1EB5.0024.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
00FC 0300 ; [.1EB5.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00FC 0340 ; [.1EB5.0024.0002] # <LATIN SMALL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00DC 0300 ; [.1EB5.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE ACCENT>
00DC 0340 ; [.1EB5.0024.0008] # <LATIN CAPITAL LETTER U WITH DIAERESIS, COMBINING GRAVE TONE MARK>
00FC      ; [.1EB5.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
0075 0308 ; [.1EB5.0025.0002] # LATIN SMALL LETTER U WITH DIAERESIS
00DC      ; [.1EB5.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
0055 0308 ; [.1EB5.0025.0008] # LATIN CAPITAL LETTER U WITH DIAERESIS
F967      ; [.804A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.82DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.81CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.8022.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.804D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.8B74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.800F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.845B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.8057.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.80B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
2F804     ; [.81E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F804
FA73      ; [.96AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA73
F92D      ; [.82EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.82ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.846A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.846A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.981A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.845F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
F9D4      ; [.8607.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F808     ; [.87B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F808
2F809     ; [.89A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.8D3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.8D39.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.8D34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.8D34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.802A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.80B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.81EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.81EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.82FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
2F814     ; [.8061.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.8142.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.82FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.8062.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.82FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.9045.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.8144.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8473.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.87C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.8065.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.860A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.80BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.81EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F955      ; [.860E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.8EC0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.A8BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81D     ; [.9524.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.802B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.8068.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.8068.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.8146.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.81F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.8306.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.8303.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F821     ; [.96CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F821
2F822     ; [.89A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.8B81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.8EC3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.8018.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.814B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.847D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.847D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.847E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.847E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.87CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.89AC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.8B85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.8B85.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.916E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.802C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.802C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.80C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.80C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.80C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.80C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.87D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.80C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.8310.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.8310.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.89AF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.81F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.81FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F831     ; [.8617.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.8617.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.8617.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.87D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.8075.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.861A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.80DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.80D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.80DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
2F83B     ; [.815E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83B
F9DE      ; [.8152.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.81FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.820C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.8206.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.8205.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.832A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.983D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.8490.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.861C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
FA79      ; [.87E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA79
2F844     ; [.87E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.8AD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.8AD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.89BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.89CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.89CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.89B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.89B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.89CA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
2F849     ; [.89BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F849
FA0D      ; [.A137.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0D
2F84A     ; [.A146.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84A
FA7B      ; [.A140.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.8D4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.8D4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.9052.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.8ED2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.96EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.8D57.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.849E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.84A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.9C30.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F854     ; [.9C49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F854
2F857     ; [.89D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
2F856     ; [.9A14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F856
FA10      ; [.8BA0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.8BA0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.8B9C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.903E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
2F858     ; [.A65C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F858
FA7D      ; [.8ED9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.9282.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.932E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.960C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.816B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.8D62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.833B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.833A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.84A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.833C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.87FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.8034.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F865     ; [.84AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F865
2F862     ; [.8641.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.863F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
FA80      ; [.8803.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.87FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.A15F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.8EE4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.A8D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.AE41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.AE41.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.8179.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86E     ; [.A16E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.8D6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.8D6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.8D6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.8EE5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F875     ; [.803A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.823D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.8811.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.8D78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.8EE9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.8EEA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.952C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.952C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
2F87A     ; [.961C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87A
F9D5      ; [.881D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
2F87C     ; [.9ECC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87C
F921      ; [.89E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
2F87F     ; [.9ECD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F87F
2F880     ; [.A424.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F880
2F9F4     ; [.A8E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F4
F9AB      ; [.9180.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.82D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.8821.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.89EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.9A3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.89EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
2F887     ; [.A67A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F887
F98E      ; [.8181.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.84C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88B     ; [.9885.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88B
2F88C     ; [.9C88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.8828.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.8BB7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.89F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.89F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA82      ; [.A432.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA82
FA0B      ; [.8D80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
FA83      ; [.A431.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA83
F982      ; [.9332.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.8044.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.8249.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.9729.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.9729.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.824C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.882F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.8830.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.84D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.89F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.A189.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.8252.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.8251.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.8378.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.84D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.9746.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.9A4D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.8675.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.8675.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.884C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.8846.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.89FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.8BC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.8BC8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.8BBF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.8BC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.8BC7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.8BC6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.8BC6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA3E      ; [.8A07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.A445.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.8F07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.8F07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.8F07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.8F05.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.8F0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.A68D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.9064.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.AB1C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.9333.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.9333.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.9333.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.9335.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.9335.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.94AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.8189.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.884E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.8F0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.918C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.83A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.838C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.98A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.8395.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.8396.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
2F8BA     ; [.84E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BA
F973      ; [.84F3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.8687.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.8686.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.886B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.8869.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.885D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.8850.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.885B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.9F18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
2F8C0     ; [.A19C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C0
2F8BD     ; [.9A60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BD
FA8E      ; [.8BDA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.A1AB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
FA8F      ; [.8A23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8F
2F8C3     ; [.8F0E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
2F8C6     ; [.A469.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C6
F991      ; [.8F1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.9F0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.9074.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.8873.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.8873.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.886E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.8BE1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.8F25.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.868F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.8691.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.84FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
F9E0      ; [.83AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.8693.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.8A2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.8A2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.8BE7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.8A32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.8A32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.8F28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.907D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.8271.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.869A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.89A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.869D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.869D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.869D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.8886.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.8886.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
2F8DA     ; [.A2D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DA
F9E1      ; [.8273.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.827D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8278.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.8279.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.976E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
2F8E0     ; [.9769.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.83C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.8519.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
2F8DF     ; [.98ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DF
F9DA      ; [.86A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
2F8E5     ; [.9A80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E5
F97A      ; [.8887.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.8896.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.8896.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.8899.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E6     ; [.9F53.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E6
2F8E8     ; [.A1D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8E9     ; [.8DB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E9
F914      ; [.8F35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.8F35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.8F35.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.8F32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
2F8EB     ; [.AB36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EB
F931      ; [.933E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.91A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.942D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.8199.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.A93D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.8C01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.9093.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
FA95      ; [.8096.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
2F8F4     ; [.A49C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F4
F9A5      ; [.91A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.889E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.889E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.889E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.81A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
2F8FE     ; [.9667.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FE
F972      ; [.8285.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.83EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.83DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
2F8FD     ; [.979E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FD
F9E3      ; [.83DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
2F8FF     ; [.9ACA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FF
F915      ; [.8534.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.852E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F907     ; [.98FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F907
2F900     ; [.8532.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.852A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.852A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.852A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.86CD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.86BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.86C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.86C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.86C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.86D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.88AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.88BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.88BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.88B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.88B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.8A5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.8A6A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.8C16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.8C12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
2F90C     ; [.8C0D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90C
FA99      ; [.8A75.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.8A75.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.8C14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.8DC3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.8DC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.8DC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.8DCC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.8F48.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.A6E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.91B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.929E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.933F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
2F913     ; [.AFA4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F913
2F917     ; [.B08F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F917
2F835     ; [.81A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.829E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.83FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.8543.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.86D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.86D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.8C20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.8A84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.8A84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
2F91E     ; [.A719.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91E
F9C0      ; [.90AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.90A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.93D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.9431.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.951C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.91C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.91C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.82A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.8A88.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
2F925     ; [.A4DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F925
FA9F      ; [.810B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.8401.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.86DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
F9A7      ; [.92A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.934B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.88D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.88D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.80A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
2F92B     ; [.840A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92B
F9AD      ; [.8551.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.86E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.88D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.86E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.8A90.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.8C3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.8F5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.A4E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.A4E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
2F931     ; [.A72F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F931
F994      ; [.A72A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.90B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.934D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
2F936     ; [.97C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F936
F9CD      ; [.86EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.88E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.88E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.88E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.8A9D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.A26E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA4      ; [.A739.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA4
FAA5      ; [.8F63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.91CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.9435.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.86F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.86F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.88EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.90BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.8412.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8412.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.8568.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F946     ; [.86FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.86FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAA9      ; [.9FEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA9
2F948     ; [.9FEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F948
2F94A     ; [.8F6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
FA9D      ; [.91D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9D
2F94E     ; [.88F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94E
F9CE      ; [.88F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.8C59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.8C59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.8C5C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.8F73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
FAAB      ; [.A74A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAB
2F950     ; [.A74A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F950
F964      ; [.AB7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.93DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.8415.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.8577.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.8576.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.870D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.8710.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.8710.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.8712.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.8711.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.88F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.8C60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.8DFC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.8DFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.8DFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.8DFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.92B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
2F957     ; [.9B31.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.8C64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.8F7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.8F7A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95A     ; [.A517.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95A
FA55      ; [.857F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
FAAC      ; [.A9B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAC
F9F7      ; [.8123.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
2F95F     ; [.A51F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95F
F9F8      ; [.88FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.8C6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.8C6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.8F84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.90CE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.9358.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.9486.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.8906.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.8E10.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.A9C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.90D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.92C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F968     ; [.ABA1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F968
2F96A     ; [.8585.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.8729.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.8727.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.8913.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.8C79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.A019.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.8E16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.8E15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.8E22.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.8F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.8F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.8F8B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.90DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.91EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.91F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.91F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.A028.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.8C7D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.90DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
2F976     ; [.A9DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F976
F90F      ; [.9363.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
2F978     ; [.9DAA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F978
F9AF      ; [.8919.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.81B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
F934      ; [.81B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.8421.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.8421.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.8421.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.891F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.9202.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.9201.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.9488.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.81B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.97E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.82B9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.8ADE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.9368.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.920D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.874A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.9B73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.9B73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
2F98C     ; [.A042.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98C
F97C      ; [.82BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.82BC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F98F     ; [.9698.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98F
2F991     ; [.8430.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.8436.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.842F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8433.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.85A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.85A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.85A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
F9FE      ; [.875F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.8754.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F9A0     ; [.9B92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A0
2F99D     ; [.8932.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.A062.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.8AF6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.8AF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.8AFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
2F99E     ; [.A04E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99E
FAB4      ; [.8AEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.8AED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.8C93.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.8C98.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.8AEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.8AEF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.8FA8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.A2E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
2F9A9     ; [.A7A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A9
F9C2      ; [.A7AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AA     ; [.A7AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AA
2F9AC     ; [.A9FC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.92D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.93F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.93F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.943C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.94BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.85B6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.8CA3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.8CA3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.921B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B6     ; [.AD63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B6
2F9B7     ; [.876A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BA     ; [.A07B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BA
2F9B9     ; [.A327.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B9
2F9BC     ; [.A587.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
2F9BD     ; [.A588.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BD
FAB5      ; [.AA1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB5
2F9BB     ; [.AA1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BB
F911      ; [.9223.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
2F9C0     ; [.A7C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C0
2F9C1     ; [.AD77.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C1
F927      ; [.9441.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.81C7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.81C8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.8B09.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
2F9C6     ; [.A08D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C6
2F9C7     ; [.A331.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C7
F9E8      ; [.8CB7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.8E56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
2F9C9     ; [.A5A9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C9
FA60      ; [.8FC1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.AC06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.93F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.92DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.82BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.8B0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.8B0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.8CC6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.8E63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.8E63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.8FD1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.8FCC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.8FC8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.8FD3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.910F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.910F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.8FCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.8FCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.910B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.910B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.910C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.910C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.92E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.92E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.937B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.948E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.94C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.94C0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.877F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.82C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.8961.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.8B21.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.8CDA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.8CD6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.8E6D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.9382.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.9382.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.94E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.8784.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DB     ; [.9E2B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DB
2F9DA     ; [.8B2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.8CDF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
2F9DC     ; [.A362.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DC
F902      ; [.82C9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
2F9DE     ; [.8787.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DE
F998      ; [.8FF7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.8FF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.911F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.911F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.911D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.B17B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.82CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.896F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.8B3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.8B3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.9126.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.9127.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.94C2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
2F9E2     ; [.95D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E2
F92C      ; [.85D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
2F9E3     ; [.99C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E3
FA26      ; [.897D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
2F9E4     ; [.A380.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E4
2F9E6     ; [.A5E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E6
F919      ; [.8CFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
FAC4      ; [.AC37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC4
F9B7      ; [.9406.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.82D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.8B44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.844C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.8D0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.8D03.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
FAC5      ; [.A5E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC5
2F9EA     ; [.8E92.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.A850.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
2F9E9     ; [.A84E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E9
F93F      ; [.9133.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.9255.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EB     ; [.AF08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EB
2F9EC     ; [.B00B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EC
2F9EE     ; [.8B50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.9016.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
2F9F0     ; [.AC62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F0
F9C6      ; [.82DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.85DA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.85DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.8988.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.898A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.9E5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.8B5A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9B8      ; [.9265.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
2F9F3     ; [.A10C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F3
F9EA      ; [.9304.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.93A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.93A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.8D1D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.8D1A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.ADDE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.9459.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.94E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.8D1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.8D1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FA69      ; [.945A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.945A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.8EA4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
2FA00     ; [.A87A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA00
FA6A      ; [.914C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.914C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.93A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.87AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8B6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.8D27.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.9152.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
2FA04     ; [.AAB6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA04
2FA05     ; [.AF33.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA05
2FA06     ; [.A624.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA06
F91A      ; [.9159.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
2FA07     ; [.AC8F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA07
F987      ; [.951D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.B044.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.B044.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.9037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
2FA0B     ; [.B04C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0B
F9F2      ; [.94D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
2FA0C     ; [.A8A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0C
2FA0F     ; [.ACA6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0F
FA2D      ; [.9468.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.94F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.9520.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.899A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.93BB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.94D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.899C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.903D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.A116.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA1A     ; [.A8B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1A
2FA1B     ; [.AE29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1B
2FA1C     ; [.8EB5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
FAD8      ; [.B230.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD8
F9C4      ; [.9168.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
F907      ; [.9169.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.9169.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.9169.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
