package Mojolicious::Command::perldoc;
use Mojo::Base 'Mojolicious::Command';

# This command is a copy of Mojolicious::Command::daemon

use Getopt::Long qw(GetOptionsFromArray :config no_auto_abbrev no_ignore_case);
use Mojo::Server::Daemon;

has description => 'Quickly serve perldoc files';
has usage => sub { shift->extract_usage };

use File::Basename;

sub run {
  my ($self, @args) = @_;

  my $daemon = Mojo::Server::Daemon->new(app => Mojolicious->new);
  $daemon->app->plugin('PODRenderer');

  GetOptionsFromArray \@args,
    'b|backlog=i'            => sub { $daemon->backlog($_[1]) },
    'c|clients=i'            => sub { $daemon->max_clients($_[1]) },
    'i|inactivity-timeout=i' => sub { $daemon->inactivity_timeout($_[1]) },
    'l|listen=s'   => \my @listen,
    'p|proxy'      => sub { $daemon->reverse_proxy(1) },
    'r|requests=i' => sub { $daemon->max_requests($_[1]) };

  $daemon->listen(\@listen) if @listen;
  $daemon->run;
}

1;

=encoding utf8

=head1 NAME

Mojolicious::Command::perldoc - Quickly serve perldoc files

=head1 SYNOPSIS

  Usage: APPLICATION perldoc [OPTIONS]

    ./myapp.pl perldoc

  Options:
    -h, --help          Show this summary of available options

=head1 DESCRIPTION

L<Mojolicious::Command::perldoc> quickly serves perldoc files

Serves files from the current directory as well as those specified on the
command line.  Numeric shortcuts (e.g. /1, /2, etc) are created for files
that are specified on the command line.

=head1 ATTRIBUTES

L<Mojolicious::Command::perldoc> inherits all attributes from
L<Mojolicious::Command> and implements the following new ones.

=head2 description

  my $description = $perldoc->description;
  $perldoc         = $perldoc->description('Foo');

Short description of this command, used for the command list.

=head2 usage

  my $usage = $perldoc->usage;
  $routes   = $perldoc->usage('Foo');

Usage information for this command, used for the help screen.

=head1 METHODS

L<Mojolicious::Command::perldoc> inherits all methods from
L<Mojolicious::Command> and implements the following new ones.

=head2 run

  $perldoc->run(@ARGV);

Run this command.

=head1 SEE ALSO

L<Mojolicious>, L<Mojolicious::Guides>, L<http://mojolicio.us>.

=cut
