#!/usr/bin/perl -w

require 5.010000;

$runtests=shift(@ARGV);
if ( -f "t/test.pl" ) {
  require "t/test.pl";
  $dir="./lib";
  $tdir="t";
} elsif ( -f "test.pl" ) {
  require "test.pl";
  $dir="../lib";
  $tdir=".";
} else {
  die "ERROR: cannot find test.pl\n";
}

unshift(@INC,$dir);
use Date::Manip::Date;

sub test {
  (@test)=@_;
  my $date = shift(@test);
  $obj->set("date",$date);
  $err = $obj->prev(@test);
  if ($err) {
     return $obj->err();
  } else {
     return [ $obj->value() ];
  }
}

$obj = new Date::Manip::Date;
$obj->config("forcedate","now,America/New_York");

$tests="

[] 1996,11,22,17,49,30
4
0
   ~
   [] 1996,11,21,17,49,30

[] 1996,11,22,17,49,30
4
1
   ~
   [] 1996,11,21,17,49,30

[] 1996,11,22,17,49,30
5
0
   ~
   [] 1996,11,15,17,49,30

[] 1996,11,22,17,49,30
5
0
   ~
   [] 1996,11,15,17,49,30

[] 1996,11,22,17,49,30
5
1
   ~
   [] 1996,11,22,17,49,30

[] 1996,11,22,17,49,30
5
0
[] 18,30
   ~
   [] 1996,11,15,18,30,0

[] 1996,11,22,17,49,30
5
0
[] 18,30,45
   ~
   [] 1996,11,15,18,30,45

[] 1996,11,22,17,49,30
5
1
[] 18,30,45
   ~
   [] 1996,11,22,18,30,45

[] 1996,11,22,17,49,30
5
2
[] 18,30,45
   ~
   [] 1996,11,15,18,30,45

[] 1996,11,22,17,49,30
_undef_
0
[] 18,0,0
   ~
   [] 1996,11,21,18,0,0

[] 1996,11,22,17,49,33
_undef_
0
[] 18,30,0
   ~
   [] 1996,11,21,18,30,0

[] 1996,11,22,17,49,33
_undef_
0
[] 18,30,45
   ~
   [] 1996,11,21,18,30,45

[] 1996,11,22,17,49,33
_undef_
0
[] 18,_undef_,45
   ~
   [] 1996,11,21,18,0,45

[] 1996,11,22,17,0,0
_undef_
0
[] 17,0,0
   ~
   [] 1996,11,21,17,0,0

[] 1996,11,22,17,0,0
_undef_
1
[] 17,0,0
   ~
   [] 1996,11,22,17,0,0

[] 1996,11,22,17,49,0
_undef_
0
[] 17,49,0
   ~
   [] 1996,11,21,17,49,0

[] 1996,11,22,17,49,0
_undef_
1
[] 17,49,0
   ~
   [] 1996,11,22,17,49,0

[] 1996,11,22,17,49,33
_undef_
0
[] 17,49,33
   ~
   [] 1996,11,21,17,49,33

[] 1996,11,22,17,49,33
_undef_
1
[] 17,49,33
   ~
   [] 1996,11,22,17,49,33

[] 1996,11,22,17,0,33
_undef_
0
[] 17,_undef_,33
   ~
   [] 1996,11,21,17,0,33

[] 1996,11,22,17,0,33
_undef_
1
[] 17,_undef_,33
   ~
   [] 1996,11,22,17,0,33

[] 1996,11,22,17,49,30
_undef_
0
[] _undef_,30,0
   ~
   [] 1996,11,22,17,30,0

[] 1996,11,22,17,49,30
_undef_
0
[] _undef_,30,45
   ~
   [] 1996,11,22,17,30,45

[] 1996,11,22,17,49,30
_undef_
0
[] _undef_,_undef_,30
   ~
   [] 1996,11,22,17,48,30

[] 1996,11,22,17,30,0
_undef_
0
[] _undef_,30,0
   ~
   [] 1996,11,22,16,30,0

[] 1996,11,22,17,30,0
_undef_
1
[] _undef_,30,0
   ~
   [] 1996,11,22,17,30,0

[] 1996,11,22,17,30,45
_undef_
0
[] _undef_,30,45
   ~
   [] 1996,11,22,16,30,45

[] 1996,11,22,17,30,45
_undef_
1
[] _undef_,30,45
   ~
   [] 1996,11,22,17,30,45

[] 1996,11,22,17,30,45
_undef_
0
[] _undef_,_undef_,45
   ~
   [] 1996,11,22,17,29,45

[] 1996,11,22,17,30,45
_undef_
1
[] _undef_,_undef_,45
   ~
   [] 1996,11,22,17,30,45

[] 2002,11,22,18,15,0
4
0
   ~
   [] 2002,11,21,18,15,0

[] 2002,11,22,18,15,0
4
0
[] 12,30
   ~
   [] 2002,11,21,12,30,0

[] 2002,11,22,18,15,0
5
0
   ~
   [] 2002,11,15,18,15,0

[] 2002,11,22,18,15,0
5
1
   ~
   [] 2002,11,22,18,15,0

[] 2002,11,22,18,15,0
5
2
   ~
   [] 2002,11,15,18,15,0

[] 2002,11,22,18,15,0
5
0
[] 12,30
   ~
   [] 2002,11,15,12,30,0

[] 2002,11,22,18,15,0
5
1
[] 12,30
   ~
   [] 2002,11,22,12,30,0

[] 2002,11,22,18,15,0
5
2
[] 12,30
   ~
   [] 2002,11,22,12,30,0

[] 2002,11,22,18,15,0
5
0
[] 19,30
   ~
   [] 2002,11,15,19,30,0

[] 2002,11,22,18,15,0
5
1
[] 19,30
   ~
   [] 2002,11,22,19,30,0

[] 2002,11,22,18,15,0
5
2
[] 19,30
   ~
   [] 2002,11,15,19,30,0

";

print "prev...\n";
test_Func(\&test,$tests,$runtests);

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: -2
# End:

