#!/usr/bin/perl -w

use Test::Inter;
$t = new Test::Inter 'GetNext';
$testdir = '';
$testdir = $t->testdir();

use Date::Manip;
if ($Date::Manip::VERSION < 6.00) {
   $t->feature("DM5",1);
}

$t->skip_all('Date::Manip 5.xx required','DM5');

$tests ="

'Fri Nov 22 1996 17:49:30' sat 0 => 1996112317:49:30

'Fri Nov 22 1996 17:49:30' sat 1 => 1996112317:49:30

'Fri Nov 22 1996 17:49:30' fri 0 => 1996112917:49:30

'Fri Nov 22 1996 17:49:30' 5 0 => 1996112917:49:30

'Fri Nov 22 1996 17:49:30' fri 1 => 1996112217:49:30

'Fri Nov 22 1996 17:49:30' fri 0 18:30 => 1996112918:30:00

'Fri Nov 22 1996 17:49:30' fri 0 18:30:45 => 1996112918:30:45

'Fri Nov 22 1996 17:49:30' fri 0 18 30 => 1996112918:30:00

'Fri Nov 22 1996 17:49:30' fri 0 18 30 45 => 1996112918:30:45

'Fri Nov 22 1996 17:49:30' fri 1 14 30 45 => 1996112214:30:45

'Fri Nov 22 1996 17:49:30' fri 2 14 30 45 => 1996112914:30:45

'Fri Nov 22 1996 17:49:30' '' 0 18 => 1996112218:00:00

'Fri Nov 22 1996 17:49:33' '' 0 18:30 => 1996112218:30:00

'Fri Nov 22 1996 17:49:33' '' 0 18 30 => 1996112218:30:00

'Fri Nov 22 1996 17:49:33' '' 0 18:30:45 => 1996112218:30:45

'Fri Nov 22 1996 17:49:33' '' 0 18 30 45 => 1996112218:30:45

'Fri Nov 22 1996 17:49:33' '' 0 18 '' 45 => 1996112218:00:45


'Fri Nov 22 1996 17:00:00' '' 0 17 => 1996112317:00:00

'Fri Nov 22 1996 17:00:00' '' 1 17 => 1996112217:00:00

'Fri Nov 22 1996 17:49:00' '' 0 17 49 => 1996112317:49:00

'Fri Nov 22 1996 17:49:00' '' 1 17 49 => 1996112217:49:00

'Fri Nov 22 1996 17:49:33' '' 0 17 49 33 => 1996112317:49:33

'Fri Nov 22 1996 17:49:33' '' 1 17 49 33 => 1996112217:49:33

'Fri Nov 22 1996 17:00:33' '' 0 17 '' 33 => 1996112317:00:33

'Fri Nov 22 1996 17:00:33' '' 1 17 '' 33 => 1996112217:00:33



'Fri Nov 22 1996 17:49:30' '' 0 '' 30 => 1996112218:30:00

'Fri Nov 22 1996 17:49:30' '' 0 '' 30 45 => 1996112218:30:45

'Fri Nov 22 1996 17:49:30' '' 0 '' '' 30 => 1996112217:50:30



'Fri Nov 22 1996 17:30:00' '' 0 '' 30 => 1996112218:30:00

'Fri Nov 22 1996 17:30:00' '' 1 '' 30 => 1996112217:30:00

'Fri Nov 22 1996 17:30:45' '' 0 '' 30 45 => 1996112218:30:45

'Fri Nov 22 1996 17:30:45' '' 1 '' 30 45 => 1996112217:30:45

'Fri Nov 22 1996 17:30:45' '' 0 '' '' 45 => 1996112217:31:45

'Fri Nov 22 1996 17:30:45' '' 1 '' '' 45 => 1996112217:30:45

";

$t->tests(func  => \&Date_GetNext,
          tests => $tests);
$t->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: -2
#End:
