package Date::Manip::TZ::aulord00;
# Copyright (c) 2008-2012 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 30 12:40:04 EST 2012
#    Data version: tzdata2012j
#    Code version: tzcode2012j

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::aulord00 - Support for the Australia/Lord_Howe time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.37';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,10,36,20],'+10:36:20',[10,36,20],
          'LMT',0,[1895,1,31,13,23,39],[1895,1,31,23,59,59],
          '0001010200:00:00','0001010210:36:20','1895013113:23:39','1895013123:59:59' ],
     ],
   1895 =>
     [
        [ [1895,1,31,13,23,40],[1895,1,31,23,23,40],'+10:00:00',[10,0,0],
          'EST',0,[1981,2,28,13,59,59],[1981,2,28,23,59,59],
          '1895013113:23:40','1895013123:23:40','1981022813:59:59','1981022823:59:59' ],
     ],
   1981 =>
     [
        [ [1981,2,28,14,0,0],[1981,3,1,0,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1981,10,24,15,29,59],[1981,10,25,1,59,59],
          '1981022814:00:00','1981030100:30:00','1981102415:29:59','1981102501:59:59' ],
        [ [1981,10,24,15,30,0],[1981,10,25,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1982,3,6,14,29,59],[1982,3,7,1,59,59],
          '1981102415:30:00','1981102503:00:00','1982030614:29:59','1982030701:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,6,14,30,0],[1982,3,7,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1982,10,30,15,29,59],[1982,10,31,1,59,59],
          '1982030614:30:00','1982030701:00:00','1982103015:29:59','1982103101:59:59' ],
        [ [1982,10,30,15,30,0],[1982,10,31,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1983,3,5,14,29,59],[1983,3,6,1,59,59],
          '1982103015:30:00','1982103103:00:00','1983030514:29:59','1983030601:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,5,14,30,0],[1983,3,6,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1983,10,29,15,29,59],[1983,10,30,1,59,59],
          '1983030514:30:00','1983030601:00:00','1983102915:29:59','1983103001:59:59' ],
        [ [1983,10,29,15,30,0],[1983,10,30,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1984,3,3,14,29,59],[1984,3,4,1,59,59],
          '1983102915:30:00','1983103003:00:00','1984030314:29:59','1984030401:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,3,14,30,0],[1984,3,4,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1984,10,27,15,29,59],[1984,10,28,1,59,59],
          '1984030314:30:00','1984030401:00:00','1984102715:29:59','1984102801:59:59' ],
        [ [1984,10,27,15,30,0],[1984,10,28,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1985,3,2,14,29,59],[1985,3,3,1,59,59],
          '1984102715:30:00','1984102803:00:00','1985030214:29:59','1985030301:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,2,14,30,0],[1985,3,3,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1985,10,26,15,29,59],[1985,10,27,1,59,59],
          '1985030214:30:00','1985030301:00:00','1985102615:29:59','1985102701:59:59' ],
        [ [1985,10,26,15,30,0],[1985,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1986,3,15,14,59,59],[1986,3,16,1,59,59],
          '1985102615:30:00','1985102702:30:00','1986031514:59:59','1986031601:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,15,15,0,0],[1986,3,16,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1986,10,18,15,29,59],[1986,10,19,1,59,59],
          '1986031515:00:00','1986031601:30:00','1986101815:29:59','1986101901:59:59' ],
        [ [1986,10,18,15,30,0],[1986,10,19,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1987,3,14,14,59,59],[1987,3,15,1,59,59],
          '1986101815:30:00','1986101902:30:00','1987031414:59:59','1987031501:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,14,15,0,0],[1987,3,15,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1987,10,24,15,29,59],[1987,10,25,1,59,59],
          '1987031415:00:00','1987031501:30:00','1987102415:29:59','1987102501:59:59' ],
        [ [1987,10,24,15,30,0],[1987,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1988,3,19,14,59,59],[1988,3,20,1,59,59],
          '1987102415:30:00','1987102502:30:00','1988031914:59:59','1988032001:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,19,15,0,0],[1988,3,20,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1988,10,29,15,29,59],[1988,10,30,1,59,59],
          '1988031915:00:00','1988032001:30:00','1988102915:29:59','1988103001:59:59' ],
        [ [1988,10,29,15,30,0],[1988,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1989,3,18,14,59,59],[1989,3,19,1,59,59],
          '1988102915:30:00','1988103002:30:00','1989031814:59:59','1989031901:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,18,15,0,0],[1989,3,19,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1989,10,28,15,29,59],[1989,10,29,1,59,59],
          '1989031815:00:00','1989031901:30:00','1989102815:29:59','1989102901:59:59' ],
        [ [1989,10,28,15,30,0],[1989,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1990,3,3,14,59,59],[1990,3,4,1,59,59],
          '1989102815:30:00','1989102902:30:00','1990030314:59:59','1990030401:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,3,15,0,0],[1990,3,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1990,10,27,15,29,59],[1990,10,28,1,59,59],
          '1990030315:00:00','1990030401:30:00','1990102715:29:59','1990102801:59:59' ],
        [ [1990,10,27,15,30,0],[1990,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1991,3,2,14,59,59],[1991,3,3,1,59,59],
          '1990102715:30:00','1990102802:30:00','1991030214:59:59','1991030301:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,2,15,0,0],[1991,3,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1991,10,26,15,29,59],[1991,10,27,1,59,59],
          '1991030215:00:00','1991030301:30:00','1991102615:29:59','1991102701:59:59' ],
        [ [1991,10,26,15,30,0],[1991,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1992,2,29,14,59,59],[1992,3,1,1,59,59],
          '1991102615:30:00','1991102702:30:00','1992022914:59:59','1992030101:59:59' ],
     ],
   1992 =>
     [
        [ [1992,2,29,15,0,0],[1992,3,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1992,10,24,15,29,59],[1992,10,25,1,59,59],
          '1992022915:00:00','1992030101:30:00','1992102415:29:59','1992102501:59:59' ],
        [ [1992,10,24,15,30,0],[1992,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1993,3,6,14,59,59],[1993,3,7,1,59,59],
          '1992102415:30:00','1992102502:30:00','1993030614:59:59','1993030701:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,6,15,0,0],[1993,3,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1993,10,30,15,29,59],[1993,10,31,1,59,59],
          '1993030615:00:00','1993030701:30:00','1993103015:29:59','1993103101:59:59' ],
        [ [1993,10,30,15,30,0],[1993,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1994,3,5,14,59,59],[1994,3,6,1,59,59],
          '1993103015:30:00','1993103102:30:00','1994030514:59:59','1994030601:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,5,15,0,0],[1994,3,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1994,10,29,15,29,59],[1994,10,30,1,59,59],
          '1994030515:00:00','1994030601:30:00','1994102915:29:59','1994103001:59:59' ],
        [ [1994,10,29,15,30,0],[1994,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1995,3,4,14,59,59],[1995,3,5,1,59,59],
          '1994102915:30:00','1994103002:30:00','1995030414:59:59','1995030501:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,4,15,0,0],[1995,3,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1995,10,28,15,29,59],[1995,10,29,1,59,59],
          '1995030415:00:00','1995030501:30:00','1995102815:29:59','1995102901:59:59' ],
        [ [1995,10,28,15,30,0],[1995,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1996,3,30,14,59,59],[1996,3,31,1,59,59],
          '1995102815:30:00','1995102902:30:00','1996033014:59:59','1996033101:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,30,15,0,0],[1996,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1996,10,26,15,29,59],[1996,10,27,1,59,59],
          '1996033015:00:00','1996033101:30:00','1996102615:29:59','1996102701:59:59' ],
        [ [1996,10,26,15,30,0],[1996,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1997,3,29,14,59,59],[1997,3,30,1,59,59],
          '1996102615:30:00','1996102702:30:00','1997032914:59:59','1997033001:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,29,15,0,0],[1997,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1997,10,25,15,29,59],[1997,10,26,1,59,59],
          '1997032915:00:00','1997033001:30:00','1997102515:29:59','1997102601:59:59' ],
        [ [1997,10,25,15,30,0],[1997,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1998,3,28,14,59,59],[1998,3,29,1,59,59],
          '1997102515:30:00','1997102602:30:00','1998032814:59:59','1998032901:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,28,15,0,0],[1998,3,29,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1998,10,24,15,29,59],[1998,10,25,1,59,59],
          '1998032815:00:00','1998032901:30:00','1998102415:29:59','1998102501:59:59' ],
        [ [1998,10,24,15,30,0],[1998,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1999,3,27,14,59,59],[1999,3,28,1,59,59],
          '1998102415:30:00','1998102502:30:00','1999032714:59:59','1999032801:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,27,15,0,0],[1999,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1999,10,30,15,29,59],[1999,10,31,1,59,59],
          '1999032715:00:00','1999032801:30:00','1999103015:29:59','1999103101:59:59' ],
        [ [1999,10,30,15,30,0],[1999,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2000,3,25,14,59,59],[2000,3,26,1,59,59],
          '1999103015:30:00','1999103102:30:00','2000032514:59:59','2000032601:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,25,15,0,0],[2000,3,26,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2000,8,26,15,29,59],[2000,8,27,1,59,59],
          '2000032515:00:00','2000032601:30:00','2000082615:29:59','2000082701:59:59' ],
        [ [2000,8,26,15,30,0],[2000,8,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2001,3,24,14,59,59],[2001,3,25,1,59,59],
          '2000082615:30:00','2000082702:30:00','2001032414:59:59','2001032501:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,24,15,0,0],[2001,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2001,10,27,15,29,59],[2001,10,28,1,59,59],
          '2001032415:00:00','2001032501:30:00','2001102715:29:59','2001102801:59:59' ],
        [ [2001,10,27,15,30,0],[2001,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2002,3,30,14,59,59],[2002,3,31,1,59,59],
          '2001102715:30:00','2001102802:30:00','2002033014:59:59','2002033101:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,30,15,0,0],[2002,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2002,10,26,15,29,59],[2002,10,27,1,59,59],
          '2002033015:00:00','2002033101:30:00','2002102615:29:59','2002102701:59:59' ],
        [ [2002,10,26,15,30,0],[2002,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2003,3,29,14,59,59],[2003,3,30,1,59,59],
          '2002102615:30:00','2002102702:30:00','2003032914:59:59','2003033001:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,29,15,0,0],[2003,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2003,10,25,15,29,59],[2003,10,26,1,59,59],
          '2003032915:00:00','2003033001:30:00','2003102515:29:59','2003102601:59:59' ],
        [ [2003,10,25,15,30,0],[2003,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2004,3,27,14,59,59],[2004,3,28,1,59,59],
          '2003102515:30:00','2003102602:30:00','2004032714:59:59','2004032801:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,27,15,0,0],[2004,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2004,10,30,15,29,59],[2004,10,31,1,59,59],
          '2004032715:00:00','2004032801:30:00','2004103015:29:59','2004103101:59:59' ],
        [ [2004,10,30,15,30,0],[2004,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2005,3,26,14,59,59],[2005,3,27,1,59,59],
          '2004103015:30:00','2004103102:30:00','2005032614:59:59','2005032701:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,26,15,0,0],[2005,3,27,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2005,10,29,15,29,59],[2005,10,30,1,59,59],
          '2005032615:00:00','2005032701:30:00','2005102915:29:59','2005103001:59:59' ],
        [ [2005,10,29,15,30,0],[2005,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2006,4,1,14,59,59],[2006,4,2,1,59,59],
          '2005102915:30:00','2005103002:30:00','2006040114:59:59','2006040201:59:59' ],
     ],
   2006 =>
     [
        [ [2006,4,1,15,0,0],[2006,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2006,10,28,15,29,59],[2006,10,29,1,59,59],
          '2006040115:00:00','2006040201:30:00','2006102815:29:59','2006102901:59:59' ],
        [ [2006,10,28,15,30,0],[2006,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2007,3,24,14,59,59],[2007,3,25,1,59,59],
          '2006102815:30:00','2006102902:30:00','2007032414:59:59','2007032501:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,24,15,0,0],[2007,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2007,10,27,15,29,59],[2007,10,28,1,59,59],
          '2007032415:00:00','2007032501:30:00','2007102715:29:59','2007102801:59:59' ],
        [ [2007,10,27,15,30,0],[2007,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2008,4,5,14,59,59],[2008,4,6,1,59,59],
          '2007102715:30:00','2007102802:30:00','2008040514:59:59','2008040601:59:59' ],
     ],
   2008 =>
     [
        [ [2008,4,5,15,0,0],[2008,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2008,10,4,15,29,59],[2008,10,5,1,59,59],
          '2008040515:00:00','2008040601:30:00','2008100415:29:59','2008100501:59:59' ],
        [ [2008,10,4,15,30,0],[2008,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2009,4,4,14,59,59],[2009,4,5,1,59,59],
          '2008100415:30:00','2008100502:30:00','2009040414:59:59','2009040501:59:59' ],
     ],
   2009 =>
     [
        [ [2009,4,4,15,0,0],[2009,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2009,10,3,15,29,59],[2009,10,4,1,59,59],
          '2009040415:00:00','2009040501:30:00','2009100315:29:59','2009100401:59:59' ],
        [ [2009,10,3,15,30,0],[2009,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2010,4,3,14,59,59],[2010,4,4,1,59,59],
          '2009100315:30:00','2009100402:30:00','2010040314:59:59','2010040401:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,3,15,0,0],[2010,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2010,10,2,15,29,59],[2010,10,3,1,59,59],
          '2010040315:00:00','2010040401:30:00','2010100215:29:59','2010100301:59:59' ],
        [ [2010,10,2,15,30,0],[2010,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2011,4,2,14,59,59],[2011,4,3,1,59,59],
          '2010100215:30:00','2010100302:30:00','2011040214:59:59','2011040301:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,2,15,0,0],[2011,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2011,10,1,15,29,59],[2011,10,2,1,59,59],
          '2011040215:00:00','2011040301:30:00','2011100115:29:59','2011100201:59:59' ],
        [ [2011,10,1,15,30,0],[2011,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2012,3,31,14,59,59],[2012,4,1,1,59,59],
          '2011100115:30:00','2011100202:30:00','2012033114:59:59','2012040101:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,31,15,0,0],[2012,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2012,10,6,15,29,59],[2012,10,7,1,59,59],
          '2012033115:00:00','2012040101:30:00','2012100615:29:59','2012100701:59:59' ],
        [ [2012,10,6,15,30,0],[2012,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2013,4,6,14,59,59],[2013,4,7,1,59,59],
          '2012100615:30:00','2012100702:30:00','2013040614:59:59','2013040701:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,6,15,0,0],[2013,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2013,10,5,15,29,59],[2013,10,6,1,59,59],
          '2013040615:00:00','2013040701:30:00','2013100515:29:59','2013100601:59:59' ],
        [ [2013,10,5,15,30,0],[2013,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2014,4,5,14,59,59],[2014,4,6,1,59,59],
          '2013100515:30:00','2013100602:30:00','2014040514:59:59','2014040601:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,5,15,0,0],[2014,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2014,10,4,15,29,59],[2014,10,5,1,59,59],
          '2014040515:00:00','2014040601:30:00','2014100415:29:59','2014100501:59:59' ],
        [ [2014,10,4,15,30,0],[2014,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2015,4,4,14,59,59],[2015,4,5,1,59,59],
          '2014100415:30:00','2014100502:30:00','2015040414:59:59','2015040501:59:59' ],
     ],
   2015 =>
     [
        [ [2015,4,4,15,0,0],[2015,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2015,10,3,15,29,59],[2015,10,4,1,59,59],
          '2015040415:00:00','2015040501:30:00','2015100315:29:59','2015100401:59:59' ],
        [ [2015,10,3,15,30,0],[2015,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2016,4,2,14,59,59],[2016,4,3,1,59,59],
          '2015100315:30:00','2015100402:30:00','2016040214:59:59','2016040301:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,2,15,0,0],[2016,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2016,10,1,15,29,59],[2016,10,2,1,59,59],
          '2016040215:00:00','2016040301:30:00','2016100115:29:59','2016100201:59:59' ],
        [ [2016,10,1,15,30,0],[2016,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2017,4,1,14,59,59],[2017,4,2,1,59,59],
          '2016100115:30:00','2016100202:30:00','2017040114:59:59','2017040201:59:59' ],
     ],
   2017 =>
     [
        [ [2017,4,1,15,0,0],[2017,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2017,9,30,15,29,59],[2017,10,1,1,59,59],
          '2017040115:00:00','2017040201:30:00','2017093015:29:59','2017100101:59:59' ],
        [ [2017,9,30,15,30,0],[2017,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2018,3,31,14,59,59],[2018,4,1,1,59,59],
          '2017093015:30:00','2017100102:30:00','2018033114:59:59','2018040101:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,31,15,0,0],[2018,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2018,10,6,15,29,59],[2018,10,7,1,59,59],
          '2018033115:00:00','2018040101:30:00','2018100615:29:59','2018100701:59:59' ],
        [ [2018,10,6,15,30,0],[2018,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2019,4,6,14,59,59],[2019,4,7,1,59,59],
          '2018100615:30:00','2018100702:30:00','2019040614:59:59','2019040701:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,6,15,0,0],[2019,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2019,10,5,15,29,59],[2019,10,6,1,59,59],
          '2019040615:00:00','2019040701:30:00','2019100515:29:59','2019100601:59:59' ],
        [ [2019,10,5,15,30,0],[2019,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2020,4,4,14,59,59],[2020,4,5,1,59,59],
          '2019100515:30:00','2019100602:30:00','2020040414:59:59','2020040501:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,4,15,0,0],[2020,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2020,10,3,15,29,59],[2020,10,4,1,59,59],
          '2020040415:00:00','2020040501:30:00','2020100315:29:59','2020100401:59:59' ],
        [ [2020,10,3,15,30,0],[2020,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2021,4,3,14,59,59],[2021,4,4,1,59,59],
          '2020100315:30:00','2020100402:30:00','2021040314:59:59','2021040401:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,3,15,0,0],[2021,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2021,10,2,15,29,59],[2021,10,3,1,59,59],
          '2021040315:00:00','2021040401:30:00','2021100215:29:59','2021100301:59:59' ],
        [ [2021,10,2,15,30,0],[2021,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2022,4,2,14,59,59],[2022,4,3,1,59,59],
          '2021100215:30:00','2021100302:30:00','2022040214:59:59','2022040301:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,2,15,0,0],[2022,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2022,10,1,15,29,59],[2022,10,2,1,59,59],
          '2022040215:00:00','2022040301:30:00','2022100115:29:59','2022100201:59:59' ],
        [ [2022,10,1,15,30,0],[2022,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2023,4,1,14,59,59],[2023,4,2,1,59,59],
          '2022100115:30:00','2022100202:30:00','2023040114:59:59','2023040201:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,1,15,0,0],[2023,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2023,9,30,15,29,59],[2023,10,1,1,59,59],
          '2023040115:00:00','2023040201:30:00','2023093015:29:59','2023100101:59:59' ],
        [ [2023,9,30,15,30,0],[2023,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2024,4,6,14,59,59],[2024,4,7,1,59,59],
          '2023093015:30:00','2023100102:30:00','2024040614:59:59','2024040701:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,6,15,0,0],[2024,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2024,10,5,15,29,59],[2024,10,6,1,59,59],
          '2024040615:00:00','2024040701:30:00','2024100515:29:59','2024100601:59:59' ],
        [ [2024,10,5,15,30,0],[2024,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2025,4,5,14,59,59],[2025,4,6,1,59,59],
          '2024100515:30:00','2024100602:30:00','2025040514:59:59','2025040601:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,5,15,0,0],[2025,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2025,10,4,15,29,59],[2025,10,5,1,59,59],
          '2025040515:00:00','2025040601:30:00','2025100415:29:59','2025100501:59:59' ],
        [ [2025,10,4,15,30,0],[2025,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2026,4,4,14,59,59],[2026,4,5,1,59,59],
          '2025100415:30:00','2025100502:30:00','2026040414:59:59','2026040501:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,4,15,0,0],[2026,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2026,10,3,15,29,59],[2026,10,4,1,59,59],
          '2026040415:00:00','2026040501:30:00','2026100315:29:59','2026100401:59:59' ],
        [ [2026,10,3,15,30,0],[2026,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2027,4,3,14,59,59],[2027,4,4,1,59,59],
          '2026100315:30:00','2026100402:30:00','2027040314:59:59','2027040401:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,3,15,0,0],[2027,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2027,10,2,15,29,59],[2027,10,3,1,59,59],
          '2027040315:00:00','2027040401:30:00','2027100215:29:59','2027100301:59:59' ],
        [ [2027,10,2,15,30,0],[2027,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2028,4,1,14,59,59],[2028,4,2,1,59,59],
          '2027100215:30:00','2027100302:30:00','2028040114:59:59','2028040201:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,1,15,0,0],[2028,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2028,9,30,15,29,59],[2028,10,1,1,59,59],
          '2028040115:00:00','2028040201:30:00','2028093015:29:59','2028100101:59:59' ],
        [ [2028,9,30,15,30,0],[2028,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2029,3,31,14,59,59],[2029,4,1,1,59,59],
          '2028093015:30:00','2028100102:30:00','2029033114:59:59','2029040101:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,31,15,0,0],[2029,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2029,10,6,15,29,59],[2029,10,7,1,59,59],
          '2029033115:00:00','2029040101:30:00','2029100615:29:59','2029100701:59:59' ],
        [ [2029,10,6,15,30,0],[2029,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2030,4,6,14,59,59],[2030,4,7,1,59,59],
          '2029100615:30:00','2029100702:30:00','2030040614:59:59','2030040701:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,6,15,0,0],[2030,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2030,10,5,15,29,59],[2030,10,6,1,59,59],
          '2030040615:00:00','2030040701:30:00','2030100515:29:59','2030100601:59:59' ],
        [ [2030,10,5,15,30,0],[2030,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2031,4,5,14,59,59],[2031,4,6,1,59,59],
          '2030100515:30:00','2030100602:30:00','2031040514:59:59','2031040601:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,5,15,0,0],[2031,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2031,10,4,15,29,59],[2031,10,5,1,59,59],
          '2031040515:00:00','2031040601:30:00','2031100415:29:59','2031100501:59:59' ],
        [ [2031,10,4,15,30,0],[2031,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2032,4,3,14,59,59],[2032,4,4,1,59,59],
          '2031100415:30:00','2031100502:30:00','2032040314:59:59','2032040401:59:59' ],
     ],
   2032 =>
     [
        [ [2032,4,3,15,0,0],[2032,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2032,10,2,15,29,59],[2032,10,3,1,59,59],
          '2032040315:00:00','2032040401:30:00','2032100215:29:59','2032100301:59:59' ],
        [ [2032,10,2,15,30,0],[2032,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2033,4,2,14,59,59],[2033,4,3,1,59,59],
          '2032100215:30:00','2032100302:30:00','2033040214:59:59','2033040301:59:59' ],
     ],
   2033 =>
     [
        [ [2033,4,2,15,0,0],[2033,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2033,10,1,15,29,59],[2033,10,2,1,59,59],
          '2033040215:00:00','2033040301:30:00','2033100115:29:59','2033100201:59:59' ],
        [ [2033,10,1,15,30,0],[2033,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2034,4,1,14,59,59],[2034,4,2,1,59,59],
          '2033100115:30:00','2033100202:30:00','2034040114:59:59','2034040201:59:59' ],
     ],
   2034 =>
     [
        [ [2034,4,1,15,0,0],[2034,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2034,9,30,15,29,59],[2034,10,1,1,59,59],
          '2034040115:00:00','2034040201:30:00','2034093015:29:59','2034100101:59:59' ],
        [ [2034,9,30,15,30,0],[2034,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2035,3,31,14,59,59],[2035,4,1,1,59,59],
          '2034093015:30:00','2034100102:30:00','2035033114:59:59','2035040101:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,31,15,0,0],[2035,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2035,10,6,15,29,59],[2035,10,7,1,59,59],
          '2035033115:00:00','2035040101:30:00','2035100615:29:59','2035100701:59:59' ],
        [ [2035,10,6,15,30,0],[2035,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2036,4,5,14,59,59],[2036,4,6,1,59,59],
          '2035100615:30:00','2035100702:30:00','2036040514:59:59','2036040601:59:59' ],
     ],
   2036 =>
     [
        [ [2036,4,5,15,0,0],[2036,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2036,10,4,15,29,59],[2036,10,5,1,59,59],
          '2036040515:00:00','2036040601:30:00','2036100415:29:59','2036100501:59:59' ],
        [ [2036,10,4,15,30,0],[2036,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2037,4,4,14,59,59],[2037,4,5,1,59,59],
          '2036100415:30:00','2036100502:30:00','2037040414:59:59','2037040501:59:59' ],
     ],
   2037 =>
     [
        [ [2037,4,4,15,0,0],[2037,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2037,10,3,15,29,59],[2037,10,4,1,59,59],
          '2037040415:00:00','2037040501:30:00','2037100315:29:59','2037100401:59:59' ],
        [ [2037,10,3,15,30,0],[2037,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2038,4,3,14,59,59],[2038,4,4,1,59,59],
          '2037100315:30:00','2037100402:30:00','2038040314:59:59','2038040401:59:59' ],
     ],
   2038 =>
     [
        [ [2038,4,3,15,0,0],[2038,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2038,10,2,15,29,59],[2038,10,3,1,59,59],
          '2038040315:00:00','2038040401:30:00','2038100215:29:59','2038100301:59:59' ],
        [ [2038,10,2,15,30,0],[2038,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2039,4,2,14,59,59],[2039,4,3,1,59,59],
          '2038100215:30:00','2038100302:30:00','2039040214:59:59','2039040301:59:59' ],
     ],
   2039 =>
     [
        [ [2039,4,2,15,0,0],[2039,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2039,10,1,15,29,59],[2039,10,2,1,59,59],
          '2039040215:00:00','2039040301:30:00','2039100115:29:59','2039100201:59:59' ],
        [ [2039,10,1,15,30,0],[2039,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2040,3,31,14,59,59],[2040,4,1,1,59,59],
          '2039100115:30:00','2039100202:30:00','2040033114:59:59','2040040101:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,31,15,0,0],[2040,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2040,10,6,15,29,59],[2040,10,7,1,59,59],
          '2040033115:00:00','2040040101:30:00','2040100615:29:59','2040100701:59:59' ],
        [ [2040,10,6,15,30,0],[2040,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2041,4,6,14,59,59],[2041,4,7,1,59,59],
          '2040100615:30:00','2040100702:30:00','2041040614:59:59','2041040701:59:59' ],
     ],
   2041 =>
     [
        [ [2041,4,6,15,0,0],[2041,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2041,10,5,15,29,59],[2041,10,6,1,59,59],
          '2041040615:00:00','2041040701:30:00','2041100515:29:59','2041100601:59:59' ],
        [ [2041,10,5,15,30,0],[2041,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2042,4,5,14,59,59],[2042,4,6,1,59,59],
          '2041100515:30:00','2041100602:30:00','2042040514:59:59','2042040601:59:59' ],
     ],
   2042 =>
     [
        [ [2042,4,5,15,0,0],[2042,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2042,10,4,15,29,59],[2042,10,5,1,59,59],
          '2042040515:00:00','2042040601:30:00','2042100415:29:59','2042100501:59:59' ],
        [ [2042,10,4,15,30,0],[2042,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2043,4,4,14,59,59],[2043,4,5,1,59,59],
          '2042100415:30:00','2042100502:30:00','2043040414:59:59','2043040501:59:59' ],
     ],
   2043 =>
     [
        [ [2043,4,4,15,0,0],[2043,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2043,10,3,15,29,59],[2043,10,4,1,59,59],
          '2043040415:00:00','2043040501:30:00','2043100315:29:59','2043100401:59:59' ],
        [ [2043,10,3,15,30,0],[2043,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2044,4,2,14,59,59],[2044,4,3,1,59,59],
          '2043100315:30:00','2043100402:30:00','2044040214:59:59','2044040301:59:59' ],
     ],
   2044 =>
     [
        [ [2044,4,2,15,0,0],[2044,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2044,10,1,15,29,59],[2044,10,2,1,59,59],
          '2044040215:00:00','2044040301:30:00','2044100115:29:59','2044100201:59:59' ],
        [ [2044,10,1,15,30,0],[2044,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2045,4,1,14,59,59],[2045,4,2,1,59,59],
          '2044100115:30:00','2044100202:30:00','2045040114:59:59','2045040201:59:59' ],
     ],
   2045 =>
     [
        [ [2045,4,1,15,0,0],[2045,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2045,9,30,15,29,59],[2045,10,1,1,59,59],
          '2045040115:00:00','2045040201:30:00','2045093015:29:59','2045100101:59:59' ],
        [ [2045,9,30,15,30,0],[2045,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2046,3,31,14,59,59],[2046,4,1,1,59,59],
          '2045093015:30:00','2045100102:30:00','2046033114:59:59','2046040101:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,31,15,0,0],[2046,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2046,10,6,15,29,59],[2046,10,7,1,59,59],
          '2046033115:00:00','2046040101:30:00','2046100615:29:59','2046100701:59:59' ],
        [ [2046,10,6,15,30,0],[2046,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2047,4,6,14,59,59],[2047,4,7,1,59,59],
          '2046100615:30:00','2046100702:30:00','2047040614:59:59','2047040701:59:59' ],
     ],
   2047 =>
     [
        [ [2047,4,6,15,0,0],[2047,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2047,10,5,15,29,59],[2047,10,6,1,59,59],
          '2047040615:00:00','2047040701:30:00','2047100515:29:59','2047100601:59:59' ],
        [ [2047,10,5,15,30,0],[2047,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2048,4,4,14,59,59],[2048,4,5,1,59,59],
          '2047100515:30:00','2047100602:30:00','2048040414:59:59','2048040501:59:59' ],
     ],
   2048 =>
     [
        [ [2048,4,4,15,0,0],[2048,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2048,10,3,15,29,59],[2048,10,4,1,59,59],
          '2048040415:00:00','2048040501:30:00','2048100315:29:59','2048100401:59:59' ],
        [ [2048,10,3,15,30,0],[2048,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2049,4,3,14,59,59],[2049,4,4,1,59,59],
          '2048100315:30:00','2048100402:30:00','2049040314:59:59','2049040401:59:59' ],
     ],
   2049 =>
     [
        [ [2049,4,3,15,0,0],[2049,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2049,10,2,15,29,59],[2049,10,3,1,59,59],
          '2049040315:00:00','2049040401:30:00','2049100215:29:59','2049100301:59:59' ],
        [ [2049,10,2,15,30,0],[2049,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2050,4,2,14,59,59],[2050,4,3,1,59,59],
          '2049100215:30:00','2049100302:30:00','2050040214:59:59','2050040301:59:59' ],
     ],
   2050 =>
     [
        [ [2050,4,2,15,0,0],[2050,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2050,10,1,15,29,59],[2050,10,2,1,59,59],
          '2050040215:00:00','2050040301:30:00','2050100115:29:59','2050100201:59:59' ],
        [ [2050,10,1,15,30,0],[2050,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2051,4,1,14,59,59],[2051,4,2,1,59,59],
          '2050100115:30:00','2050100202:30:00','2051040114:59:59','2051040201:59:59' ],
     ],
   2051 =>
     [
        [ [2051,4,1,15,0,0],[2051,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2051,9,30,15,29,59],[2051,10,1,1,59,59],
          '2051040115:00:00','2051040201:30:00','2051093015:29:59','2051100101:59:59' ],
        [ [2051,9,30,15,30,0],[2051,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2052,4,6,14,59,59],[2052,4,7,1,59,59],
          '2051093015:30:00','2051100102:30:00','2052040614:59:59','2052040701:59:59' ],
     ],
   2052 =>
     [
        [ [2052,4,6,15,0,0],[2052,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2052,10,5,15,29,59],[2052,10,6,1,59,59],
          '2052040615:00:00','2052040701:30:00','2052100515:29:59','2052100601:59:59' ],
        [ [2052,10,5,15,30,0],[2052,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2053,4,5,14,59,59],[2053,4,6,1,59,59],
          '2052100515:30:00','2052100602:30:00','2053040514:59:59','2053040601:59:59' ],
     ],
   2053 =>
     [
        [ [2053,4,5,15,0,0],[2053,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2053,10,4,15,29,59],[2053,10,5,1,59,59],
          '2053040515:00:00','2053040601:30:00','2053100415:29:59','2053100501:59:59' ],
        [ [2053,10,4,15,30,0],[2053,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2054,4,4,14,59,59],[2054,4,5,1,59,59],
          '2053100415:30:00','2053100502:30:00','2054040414:59:59','2054040501:59:59' ],
     ],
   2054 =>
     [
        [ [2054,4,4,15,0,0],[2054,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2054,10,3,15,29,59],[2054,10,4,1,59,59],
          '2054040415:00:00','2054040501:30:00','2054100315:29:59','2054100401:59:59' ],
        [ [2054,10,3,15,30,0],[2054,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2055,4,3,14,59,59],[2055,4,4,1,59,59],
          '2054100315:30:00','2054100402:30:00','2055040314:59:59','2055040401:59:59' ],
     ],
   2055 =>
     [
        [ [2055,4,3,15,0,0],[2055,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2055,10,2,15,29,59],[2055,10,3,1,59,59],
          '2055040315:00:00','2055040401:30:00','2055100215:29:59','2055100301:59:59' ],
        [ [2055,10,2,15,30,0],[2055,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2056,4,1,14,59,59],[2056,4,2,1,59,59],
          '2055100215:30:00','2055100302:30:00','2056040114:59:59','2056040201:59:59' ],
     ],
   2056 =>
     [
        [ [2056,4,1,15,0,0],[2056,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2056,9,30,15,29,59],[2056,10,1,1,59,59],
          '2056040115:00:00','2056040201:30:00','2056093015:29:59','2056100101:59:59' ],
        [ [2056,9,30,15,30,0],[2056,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2057,3,31,14,59,59],[2057,4,1,1,59,59],
          '2056093015:30:00','2056100102:30:00','2057033114:59:59','2057040101:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,31,15,0,0],[2057,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2057,10,6,15,29,59],[2057,10,7,1,59,59],
          '2057033115:00:00','2057040101:30:00','2057100615:29:59','2057100701:59:59' ],
        [ [2057,10,6,15,30,0],[2057,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2058,4,6,14,59,59],[2058,4,7,1,59,59],
          '2057100615:30:00','2057100702:30:00','2058040614:59:59','2058040701:59:59' ],
     ],
   2058 =>
     [
        [ [2058,4,6,15,0,0],[2058,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2058,10,5,15,29,59],[2058,10,6,1,59,59],
          '2058040615:00:00','2058040701:30:00','2058100515:29:59','2058100601:59:59' ],
        [ [2058,10,5,15,30,0],[2058,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2059,4,5,14,59,59],[2059,4,6,1,59,59],
          '2058100515:30:00','2058100602:30:00','2059040514:59:59','2059040601:59:59' ],
     ],
   2059 =>
     [
        [ [2059,4,5,15,0,0],[2059,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2059,10,4,15,29,59],[2059,10,5,1,59,59],
          '2059040515:00:00','2059040601:30:00','2059100415:29:59','2059100501:59:59' ],
        [ [2059,10,4,15,30,0],[2059,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2060,4,3,14,59,59],[2060,4,4,1,59,59],
          '2059100415:30:00','2059100502:30:00','2060040314:59:59','2060040401:59:59' ],
     ],
   2060 =>
     [
        [ [2060,4,3,15,0,0],[2060,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2060,10,2,15,29,59],[2060,10,3,1,59,59],
          '2060040315:00:00','2060040401:30:00','2060100215:29:59','2060100301:59:59' ],
        [ [2060,10,2,15,30,0],[2060,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2061,4,2,14,59,59],[2061,4,3,1,59,59],
          '2060100215:30:00','2060100302:30:00','2061040214:59:59','2061040301:59:59' ],
     ],
   2061 =>
     [
        [ [2061,4,2,15,0,0],[2061,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2061,10,1,15,29,59],[2061,10,2,1,59,59],
          '2061040215:00:00','2061040301:30:00','2061100115:29:59','2061100201:59:59' ],
        [ [2061,10,1,15,30,0],[2061,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2062,4,1,14,59,59],[2062,4,2,1,59,59],
          '2061100115:30:00','2061100202:30:00','2062040114:59:59','2062040201:59:59' ],
     ],
   2062 =>
     [
        [ [2062,4,1,15,0,0],[2062,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2062,9,30,15,29,59],[2062,10,1,1,59,59],
          '2062040115:00:00','2062040201:30:00','2062093015:29:59','2062100101:59:59' ],
        [ [2062,9,30,15,30,0],[2062,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2063,3,31,14,59,59],[2063,4,1,1,59,59],
          '2062093015:30:00','2062100102:30:00','2063033114:59:59','2063040101:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,31,15,0,0],[2063,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2063,10,6,15,29,59],[2063,10,7,1,59,59],
          '2063033115:00:00','2063040101:30:00','2063100615:29:59','2063100701:59:59' ],
        [ [2063,10,6,15,30,0],[2063,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2064,4,5,14,59,59],[2064,4,6,1,59,59],
          '2063100615:30:00','2063100702:30:00','2064040514:59:59','2064040601:59:59' ],
     ],
   2064 =>
     [
        [ [2064,4,5,15,0,0],[2064,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2064,10,4,15,29,59],[2064,10,5,1,59,59],
          '2064040515:00:00','2064040601:30:00','2064100415:29:59','2064100501:59:59' ],
        [ [2064,10,4,15,30,0],[2064,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2065,4,4,14,59,59],[2065,4,5,1,59,59],
          '2064100415:30:00','2064100502:30:00','2065040414:59:59','2065040501:59:59' ],
     ],
   2065 =>
     [
        [ [2065,4,4,15,0,0],[2065,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2065,10,3,15,29,59],[2065,10,4,1,59,59],
          '2065040415:00:00','2065040501:30:00','2065100315:29:59','2065100401:59:59' ],
        [ [2065,10,3,15,30,0],[2065,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2066,4,3,14,59,59],[2066,4,4,1,59,59],
          '2065100315:30:00','2065100402:30:00','2066040314:59:59','2066040401:59:59' ],
     ],
   2066 =>
     [
        [ [2066,4,3,15,0,0],[2066,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2066,10,2,15,29,59],[2066,10,3,1,59,59],
          '2066040315:00:00','2066040401:30:00','2066100215:29:59','2066100301:59:59' ],
        [ [2066,10,2,15,30,0],[2066,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2067,4,2,14,59,59],[2067,4,3,1,59,59],
          '2066100215:30:00','2066100302:30:00','2067040214:59:59','2067040301:59:59' ],
     ],
   2067 =>
     [
        [ [2067,4,2,15,0,0],[2067,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2067,10,1,15,29,59],[2067,10,2,1,59,59],
          '2067040215:00:00','2067040301:30:00','2067100115:29:59','2067100201:59:59' ],
        [ [2067,10,1,15,30,0],[2067,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2068,3,31,14,59,59],[2068,4,1,1,59,59],
          '2067100115:30:00','2067100202:30:00','2068033114:59:59','2068040101:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,31,15,0,0],[2068,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2068,10,6,15,29,59],[2068,10,7,1,59,59],
          '2068033115:00:00','2068040101:30:00','2068100615:29:59','2068100701:59:59' ],
        [ [2068,10,6,15,30,0],[2068,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2069,4,6,14,59,59],[2069,4,7,1,59,59],
          '2068100615:30:00','2068100702:30:00','2069040614:59:59','2069040701:59:59' ],
     ],
   2069 =>
     [
        [ [2069,4,6,15,0,0],[2069,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2069,10,5,15,29,59],[2069,10,6,1,59,59],
          '2069040615:00:00','2069040701:30:00','2069100515:29:59','2069100601:59:59' ],
        [ [2069,10,5,15,30,0],[2069,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2070,4,5,14,59,59],[2070,4,6,1,59,59],
          '2069100515:30:00','2069100602:30:00','2070040514:59:59','2070040601:59:59' ],
     ],
   2070 =>
     [
        [ [2070,4,5,15,0,0],[2070,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2070,10,4,15,29,59],[2070,10,5,1,59,59],
          '2070040515:00:00','2070040601:30:00','2070100415:29:59','2070100501:59:59' ],
        [ [2070,10,4,15,30,0],[2070,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2071,4,4,14,59,59],[2071,4,5,1,59,59],
          '2070100415:30:00','2070100502:30:00','2071040414:59:59','2071040501:59:59' ],
     ],
   2071 =>
     [
        [ [2071,4,4,15,0,0],[2071,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2071,10,3,15,29,59],[2071,10,4,1,59,59],
          '2071040415:00:00','2071040501:30:00','2071100315:29:59','2071100401:59:59' ],
        [ [2071,10,3,15,30,0],[2071,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2072,4,2,14,59,59],[2072,4,3,1,59,59],
          '2071100315:30:00','2071100402:30:00','2072040214:59:59','2072040301:59:59' ],
     ],
   2072 =>
     [
        [ [2072,4,2,15,0,0],[2072,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2072,10,1,15,29,59],[2072,10,2,1,59,59],
          '2072040215:00:00','2072040301:30:00','2072100115:29:59','2072100201:59:59' ],
        [ [2072,10,1,15,30,0],[2072,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2073,4,1,14,59,59],[2073,4,2,1,59,59],
          '2072100115:30:00','2072100202:30:00','2073040114:59:59','2073040201:59:59' ],
     ],
   2073 =>
     [
        [ [2073,4,1,15,0,0],[2073,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2073,9,30,15,29,59],[2073,10,1,1,59,59],
          '2073040115:00:00','2073040201:30:00','2073093015:29:59','2073100101:59:59' ],
        [ [2073,9,30,15,30,0],[2073,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2074,3,31,14,59,59],[2074,4,1,1,59,59],
          '2073093015:30:00','2073100102:30:00','2074033114:59:59','2074040101:59:59' ],
     ],
   2074 =>
     [
        [ [2074,3,31,15,0,0],[2074,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2074,10,6,15,29,59],[2074,10,7,1,59,59],
          '2074033115:00:00','2074040101:30:00','2074100615:29:59','2074100701:59:59' ],
        [ [2074,10,6,15,30,0],[2074,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2075,4,6,14,59,59],[2075,4,7,1,59,59],
          '2074100615:30:00','2074100702:30:00','2075040614:59:59','2075040701:59:59' ],
     ],
   2075 =>
     [
        [ [2075,4,6,15,0,0],[2075,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2075,10,5,15,29,59],[2075,10,6,1,59,59],
          '2075040615:00:00','2075040701:30:00','2075100515:29:59','2075100601:59:59' ],
        [ [2075,10,5,15,30,0],[2075,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2076,4,4,14,59,59],[2076,4,5,1,59,59],
          '2075100515:30:00','2075100602:30:00','2076040414:59:59','2076040501:59:59' ],
     ],
   2076 =>
     [
        [ [2076,4,4,15,0,0],[2076,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2076,10,3,15,29,59],[2076,10,4,1,59,59],
          '2076040415:00:00','2076040501:30:00','2076100315:29:59','2076100401:59:59' ],
        [ [2076,10,3,15,30,0],[2076,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2077,4,3,14,59,59],[2077,4,4,1,59,59],
          '2076100315:30:00','2076100402:30:00','2077040314:59:59','2077040401:59:59' ],
     ],
   2077 =>
     [
        [ [2077,4,3,15,0,0],[2077,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2077,10,2,15,29,59],[2077,10,3,1,59,59],
          '2077040315:00:00','2077040401:30:00','2077100215:29:59','2077100301:59:59' ],
        [ [2077,10,2,15,30,0],[2077,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2078,4,2,14,59,59],[2078,4,3,1,59,59],
          '2077100215:30:00','2077100302:30:00','2078040214:59:59','2078040301:59:59' ],
     ],
   2078 =>
     [
        [ [2078,4,2,15,0,0],[2078,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2078,10,1,15,29,59],[2078,10,2,1,59,59],
          '2078040215:00:00','2078040301:30:00','2078100115:29:59','2078100201:59:59' ],
        [ [2078,10,1,15,30,0],[2078,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2079,4,1,14,59,59],[2079,4,2,1,59,59],
          '2078100115:30:00','2078100202:30:00','2079040114:59:59','2079040201:59:59' ],
     ],
   2079 =>
     [
        [ [2079,4,1,15,0,0],[2079,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2079,9,30,15,29,59],[2079,10,1,1,59,59],
          '2079040115:00:00','2079040201:30:00','2079093015:29:59','2079100101:59:59' ],
        [ [2079,9,30,15,30,0],[2079,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2080,4,6,14,59,59],[2080,4,7,1,59,59],
          '2079093015:30:00','2079100102:30:00','2080040614:59:59','2080040701:59:59' ],
     ],
   2080 =>
     [
        [ [2080,4,6,15,0,0],[2080,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2080,10,5,15,29,59],[2080,10,6,1,59,59],
          '2080040615:00:00','2080040701:30:00','2080100515:29:59','2080100601:59:59' ],
        [ [2080,10,5,15,30,0],[2080,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2081,4,5,14,59,59],[2081,4,6,1,59,59],
          '2080100515:30:00','2080100602:30:00','2081040514:59:59','2081040601:59:59' ],
     ],
   2081 =>
     [
        [ [2081,4,5,15,0,0],[2081,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2081,10,4,15,29,59],[2081,10,5,1,59,59],
          '2081040515:00:00','2081040601:30:00','2081100415:29:59','2081100501:59:59' ],
        [ [2081,10,4,15,30,0],[2081,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2082,4,4,14,59,59],[2082,4,5,1,59,59],
          '2081100415:30:00','2081100502:30:00','2082040414:59:59','2082040501:59:59' ],
     ],
   2082 =>
     [
        [ [2082,4,4,15,0,0],[2082,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2082,10,3,15,29,59],[2082,10,4,1,59,59],
          '2082040415:00:00','2082040501:30:00','2082100315:29:59','2082100401:59:59' ],
        [ [2082,10,3,15,30,0],[2082,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2083,4,3,14,59,59],[2083,4,4,1,59,59],
          '2082100315:30:00','2082100402:30:00','2083040314:59:59','2083040401:59:59' ],
     ],
   2083 =>
     [
        [ [2083,4,3,15,0,0],[2083,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2083,10,2,15,29,59],[2083,10,3,1,59,59],
          '2083040315:00:00','2083040401:30:00','2083100215:29:59','2083100301:59:59' ],
        [ [2083,10,2,15,30,0],[2083,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2084,4,1,14,59,59],[2084,4,2,1,59,59],
          '2083100215:30:00','2083100302:30:00','2084040114:59:59','2084040201:59:59' ],
     ],
   2084 =>
     [
        [ [2084,4,1,15,0,0],[2084,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2084,9,30,15,29,59],[2084,10,1,1,59,59],
          '2084040115:00:00','2084040201:30:00','2084093015:29:59','2084100101:59:59' ],
        [ [2084,9,30,15,30,0],[2084,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2085,3,31,14,59,59],[2085,4,1,1,59,59],
          '2084093015:30:00','2084100102:30:00','2085033114:59:59','2085040101:59:59' ],
     ],
   2085 =>
     [
        [ [2085,3,31,15,0,0],[2085,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2085,10,6,15,29,59],[2085,10,7,1,59,59],
          '2085033115:00:00','2085040101:30:00','2085100615:29:59','2085100701:59:59' ],
        [ [2085,10,6,15,30,0],[2085,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2086,4,6,14,59,59],[2086,4,7,1,59,59],
          '2085100615:30:00','2085100702:30:00','2086040614:59:59','2086040701:59:59' ],
     ],
   2086 =>
     [
        [ [2086,4,6,15,0,0],[2086,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2086,10,5,15,29,59],[2086,10,6,1,59,59],
          '2086040615:00:00','2086040701:30:00','2086100515:29:59','2086100601:59:59' ],
        [ [2086,10,5,15,30,0],[2086,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2087,4,5,14,59,59],[2087,4,6,1,59,59],
          '2086100515:30:00','2086100602:30:00','2087040514:59:59','2087040601:59:59' ],
     ],
   2087 =>
     [
        [ [2087,4,5,15,0,0],[2087,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2087,10,4,15,29,59],[2087,10,5,1,59,59],
          '2087040515:00:00','2087040601:30:00','2087100415:29:59','2087100501:59:59' ],
        [ [2087,10,4,15,30,0],[2087,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2088,4,3,14,59,59],[2088,4,4,1,59,59],
          '2087100415:30:00','2087100502:30:00','2088040314:59:59','2088040401:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+11:00:00',
                'stdoff' => '+10:30:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'LHST',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'LHST',
                        },
               },
);

1;
