package Date::Manip::Zones;
# Copyright (c) 2008-2013 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Mon Jun  3 13:00:51 EDT 2013
#    Data version: tzdata2013c
#    Code version: tzcode2013c

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.orgtz

use strict;
use warnings;
require 5.010000;

our ($VERSION);
$VERSION='6.40';
END { undef $VERSION; }

our ($TzdataVersion,$TzcodeVersion,
     $FirstDate,$LastDate,$LastYear,
     %Module,%ZoneNames,%Alias,%Abbrev,%Offmod);
END {
   undef $TzdataVersion;
   undef $TzcodeVersion;
   undef $FirstDate;
   undef $LastDate;
   undef $LastYear;
   undef %Module;
   undef %ZoneNames;
   undef %Alias;
   undef %Abbrev;
   undef %Offmod;
}

$TzdataVersion = 'tzdata2013c';
$TzcodeVersion = 'tzcode2013c';
$FirstDate     = '0001010200:00:00';
$LastDate      = '9999123100:00:00';
$LastYear      = '2088';


%Module = (
  'africa/abidjan'                     => 'afabid00',
  'africa/accra'                       => 'afaccr00',
  'africa/addis_ababa'                 => 'afaddi00',
  'africa/algiers'                     => 'afalgi00',
  'africa/asmara'                      => 'afasma00',
  'africa/bamako'                      => 'afbama00',
  'africa/bangui'                      => 'afbang00',
  'africa/banjul'                      => 'afbanj00',
  'africa/bissau'                      => 'afbiss00',
  'africa/blantyre'                    => 'afblan00',
  'africa/brazzaville'                 => 'afbraz00',
  'africa/bujumbura'                   => 'afbuju00',
  'africa/cairo'                       => 'afcair00',
  'africa/casablanca'                  => 'afcasa00',
  'africa/ceuta'                       => 'afceut00',
  'africa/conakry'                     => 'afcona00',
  'africa/dakar'                       => 'afdaka00',
  'africa/dar_es_salaam'               => 'afdar_00',
  'africa/djibouti'                    => 'afdjib00',
  'africa/douala'                      => 'afdoua00',
  'africa/el_aaiun'                    => 'afel_a00',
  'africa/freetown'                    => 'affree00',
  'africa/gaborone'                    => 'afgabo00',
  'africa/harare'                      => 'afhara00',
  'africa/johannesburg'                => 'afjoha00',
  'africa/juba'                        => 'afjuba00',
  'africa/kampala'                     => 'afkamp00',
  'africa/khartoum'                    => 'afkhar00',
  'africa/kigali'                      => 'afkiga00',
  'africa/kinshasa'                    => 'afkins00',
  'africa/lagos'                       => 'aflago00',
  'africa/libreville'                  => 'aflibr00',
  'africa/lome'                        => 'aflome00',
  'africa/luanda'                      => 'afluan00',
  'africa/lubumbashi'                  => 'aflubu00',
  'africa/lusaka'                      => 'aflusa00',
  'africa/malabo'                      => 'afmala00',
  'africa/maputo'                      => 'afmapu00',
  'africa/maseru'                      => 'afmase00',
  'africa/mbabane'                     => 'afmbab00',
  'africa/mogadishu'                   => 'afmoga00',
  'africa/monrovia'                    => 'afmonr00',
  'africa/nairobi'                     => 'afnair00',
  'africa/ndjamena'                    => 'afndja00',
  'africa/niamey'                      => 'afniam00',
  'africa/nouakchott'                  => 'afnoua00',
  'africa/ouagadougou'                 => 'afouag00',
  'africa/porto-novo'                  => 'afport00',
  'africa/sao_tome'                    => 'afsao_00',
  'africa/tripoli'                     => 'aftrip00',
  'africa/tunis'                       => 'aftuni00',
  'africa/windhoek'                    => 'afwind00',
  'america/adak'                       => 'amadak00',
  'america/anchorage'                  => 'amanch00',
  'america/anguilla'                   => 'amangu00',
  'america/antigua'                    => 'amanti00',
  'america/araguaina'                  => 'amarag00',
  'america/argentina/buenos_aires'     => 'ambuen00',
  'america/argentina/catamarca'        => 'amcata00',
  'america/argentina/cordoba'          => 'amcord00',
  'america/argentina/jujuy'            => 'amjuju00',
  'america/argentina/la_rioja'         => 'amla_r00',
  'america/argentina/mendoza'          => 'ammend00',
  'america/argentina/rio_gallegos'     => 'amrio_00',
  'america/argentina/salta'            => 'amsalt00',
  'america/argentina/san_juan'         => 'amsan_00',
  'america/argentina/san_luis'         => 'amsan_01',
  'america/argentina/tucuman'          => 'amtucu00',
  'america/argentina/ushuaia'          => 'amushu00',
  'america/aruba'                      => 'amarub00',
  'america/asuncion'                   => 'amasun00',
  'america/atikokan'                   => 'amatik00',
  'america/bahia'                      => 'ambahi00',
  'america/bahia_banderas'             => 'ambahi01',
  'america/barbados'                   => 'ambarb00',
  'america/belem'                      => 'ambele00',
  'america/belize'                     => 'ambeli00',
  'america/blanc-sablon'               => 'amblan00',
  'america/boa_vista'                  => 'amboa_00',
  'america/bogota'                     => 'ambogo00',
  'america/boise'                      => 'ambois00',
  'america/cambridge_bay'              => 'amcamb00',
  'america/campo_grande'               => 'amcamp00',
  'america/cancun'                     => 'amcanc00',
  'america/caracas'                    => 'amcara00',
  'america/cayenne'                    => 'amcaye00',
  'america/cayman'                     => 'amcaym00',
  'america/chicago'                    => 'amchic00',
  'america/chihuahua'                  => 'amchih00',
  'america/costa_rica'                 => 'amcost00',
  'america/creston'                    => 'amcres00',
  'america/cuiaba'                     => 'amcuia00',
  'america/curacao'                    => 'amcura00',
  'america/danmarkshavn'               => 'amdanm00',
  'america/dawson'                     => 'amdaws00',
  'america/dawson_creek'               => 'amdaws01',
  'america/denver'                     => 'amdenv00',
  'america/detroit'                    => 'amdetr00',
  'america/dominica'                   => 'amdomi00',
  'america/edmonton'                   => 'amedmo00',
  'america/eirunepe'                   => 'ameiru00',
  'america/el_salvador'                => 'amel_s00',
  'america/fortaleza'                  => 'amfort00',
  'america/glace_bay'                  => 'amglac00',
  'america/godthab'                    => 'amgodt00',
  'america/goose_bay'                  => 'amgoos00',
  'america/grand_turk'                 => 'amgran00',
  'america/grenada'                    => 'amgren00',
  'america/guadeloupe'                 => 'amguad00',
  'america/guatemala'                  => 'amguat00',
  'america/guayaquil'                  => 'amguay00',
  'america/guyana'                     => 'amguya00',
  'america/halifax'                    => 'amhali00',
  'america/havana'                     => 'amhava00',
  'america/hermosillo'                 => 'amherm00',
  'america/indiana/indianapolis'       => 'amindi00',
  'america/indiana/knox'               => 'amknox00',
  'america/indiana/marengo'            => 'ammare00',
  'america/indiana/petersburg'         => 'ampete00',
  'america/indiana/tell_city'          => 'amtell00',
  'america/indiana/vevay'              => 'amveva00',
  'america/indiana/vincennes'          => 'amvinc00',
  'america/indiana/winamac'            => 'amwina00',
  'america/inuvik'                     => 'aminuv00',
  'america/iqaluit'                    => 'amiqal00',
  'america/jamaica'                    => 'amjama00',
  'america/juneau'                     => 'amjune00',
  'america/kentucky/louisville'        => 'amloui00',
  'america/kentucky/monticello'        => 'ammont00',
  'america/la_paz'                     => 'amla_p00',
  'america/lima'                       => 'amlima00',
  'america/los_angeles'                => 'amlos_00',
  'america/maceio'                     => 'ammace00',
  'america/managua'                    => 'ammana00',
  'america/manaus'                     => 'ammana01',
  'america/martinique'                 => 'ammart00',
  'america/matamoros'                  => 'ammata00',
  'america/mazatlan'                   => 'ammaza00',
  'america/menominee'                  => 'ammeno00',
  'america/merida'                     => 'ammeri00',
  'america/metlakatla'                 => 'ammetl00',
  'america/mexico_city'                => 'ammexi00',
  'america/miquelon'                   => 'ammiqu00',
  'america/moncton'                    => 'ammonc00',
  'america/monterrey'                  => 'ammont01',
  'america/montevideo'                 => 'ammont02',
  'america/montreal'                   => 'ammont03',
  'america/montserrat'                 => 'ammont04',
  'america/nassau'                     => 'amnass00',
  'america/new_york'                   => 'amnew_00',
  'america/nipigon'                    => 'amnipi00',
  'america/nome'                       => 'amnome00',
  'america/noronha'                    => 'amnoro00',
  'america/north_dakota/beulah'        => 'ambeul00',
  'america/north_dakota/center'        => 'amcent00',
  'america/north_dakota/new_salem'     => 'amnew_01',
  'america/ojinaga'                    => 'amojin00',
  'america/panama'                     => 'ampana00',
  'america/pangnirtung'                => 'ampang00',
  'america/paramaribo'                 => 'ampara00',
  'america/phoenix'                    => 'amphoe00',
  'america/port-au-prince'             => 'amport00',
  'america/port_of_spain'              => 'amport01',
  'america/porto_velho'                => 'amport02',
  'america/puerto_rico'                => 'ampuer00',
  'america/rainy_river'                => 'amrain00',
  'america/rankin_inlet'               => 'amrank00',
  'america/recife'                     => 'amreci00',
  'america/regina'                     => 'amregi00',
  'america/resolute'                   => 'amreso00',
  'america/rio_branco'                 => 'amrio_01',
  'america/santa_isabel'               => 'amsant00',
  'america/santarem'                   => 'amsant01',
  'america/santiago'                   => 'amsant02',
  'america/santo_domingo'              => 'amsant03',
  'america/sao_paulo'                  => 'amsao_00',
  'america/scoresbysund'               => 'amscor00',
  'america/sitka'                      => 'amsitk00',
  'america/st_johns'                   => 'amst_j00',
  'america/st_kitts'                   => 'amst_k00',
  'america/st_lucia'                   => 'amst_l00',
  'america/st_thomas'                  => 'amst_t00',
  'america/st_vincent'                 => 'amst_v00',
  'america/swift_current'              => 'amswif00',
  'america/tegucigalpa'                => 'amtegu00',
  'america/thule'                      => 'amthul00',
  'america/thunder_bay'                => 'amthun00',
  'america/tijuana'                    => 'amtiju00',
  'america/toronto'                    => 'amtoro00',
  'america/tortola'                    => 'amtort00',
  'america/vancouver'                  => 'amvanc00',
  'america/whitehorse'                 => 'amwhit00',
  'america/winnipeg'                   => 'amwinn00',
  'america/yakutat'                    => 'amyaku00',
  'america/yellowknife'                => 'amyell00',
  'antarctica/casey'                   => 'ancase00',
  'antarctica/davis'                   => 'andavi00',
  'antarctica/dumontdurville'          => 'andumo00',
  'antarctica/macquarie'               => 'anmacq00',
  'antarctica/mawson'                  => 'anmaws00',
  'antarctica/mcmurdo'                 => 'anmcmu00',
  'antarctica/palmer'                  => 'anpalm00',
  'antarctica/rothera'                 => 'anroth00',
  'antarctica/syowa'                   => 'ansyow00',
  'antarctica/vostok'                  => 'anvost00',
  'asia/aden'                          => 'asaden00',
  'asia/almaty'                        => 'asalma00',
  'asia/amman'                         => 'asamma00',
  'asia/anadyr'                        => 'asanad00',
  'asia/aqtau'                         => 'asaqta00',
  'asia/aqtobe'                        => 'asaqto00',
  'asia/ashgabat'                      => 'asashg00',
  'asia/baghdad'                       => 'asbagh00',
  'asia/bahrain'                       => 'asbahr00',
  'asia/baku'                          => 'asbaku00',
  'asia/bangkok'                       => 'asbang00',
  'asia/beirut'                        => 'asbeir00',
  'asia/bishkek'                       => 'asbish00',
  'asia/brunei'                        => 'asbrun00',
  'asia/choibalsan'                    => 'aschoi00',
  'asia/chongqing'                     => 'aschon00',
  'asia/colombo'                       => 'ascolo00',
  'asia/damascus'                      => 'asdama00',
  'asia/dhaka'                         => 'asdhak00',
  'asia/dili'                          => 'asdili00',
  'asia/dubai'                         => 'asduba00',
  'asia/dushanbe'                      => 'asdush00',
  'asia/gaza'                          => 'asgaza00',
  'asia/harbin'                        => 'asharb00',
  'asia/hebron'                        => 'ashebr00',
  'asia/ho_chi_minh'                   => 'asho_c00',
  'asia/hong_kong'                     => 'ashong00',
  'asia/hovd'                          => 'ashovd00',
  'asia/irkutsk'                       => 'asirku00',
  'asia/jakarta'                       => 'asjaka00',
  'asia/jayapura'                      => 'asjaya00',
  'asia/jerusalem'                     => 'asjeru00',
  'asia/kabul'                         => 'askabu00',
  'asia/kamchatka'                     => 'askamc00',
  'asia/karachi'                       => 'askara00',
  'asia/kashgar'                       => 'askash00',
  'asia/kathmandu'                     => 'askath00',
  'asia/khandyga'                      => 'askhan00',
  'asia/kolkata'                       => 'askolk00',
  'asia/krasnoyarsk'                   => 'askras00',
  'asia/kuala_lumpur'                  => 'askual00',
  'asia/kuching'                       => 'askuch00',
  'asia/kuwait'                        => 'askuwa00',
  'asia/macau'                         => 'asmaca00',
  'asia/magadan'                       => 'asmaga00',
  'asia/makassar'                      => 'asmaka00',
  'asia/manila'                        => 'asmani00',
  'asia/muscat'                        => 'asmusc00',
  'asia/nicosia'                       => 'asnico00',
  'asia/novokuznetsk'                  => 'asnovo00',
  'asia/novosibirsk'                   => 'asnovo01',
  'asia/omsk'                          => 'asomsk00',
  'asia/oral'                          => 'asoral00',
  'asia/phnom_penh'                    => 'asphno00',
  'asia/pontianak'                     => 'aspont00',
  'asia/pyongyang'                     => 'aspyon00',
  'asia/qatar'                         => 'asqata00',
  'asia/qyzylorda'                     => 'asqyzy00',
  'asia/rangoon'                       => 'asrang00',
  'asia/riyadh'                        => 'asriya00',
  'asia/sakhalin'                      => 'assakh00',
  'asia/samarkand'                     => 'assama00',
  'asia/seoul'                         => 'asseou00',
  'asia/shanghai'                      => 'asshan00',
  'asia/singapore'                     => 'assing00',
  'asia/taipei'                        => 'astaip00',
  'asia/tashkent'                      => 'astash00',
  'asia/tbilisi'                       => 'astbil00',
  'asia/tehran'                        => 'astehr00',
  'asia/thimphu'                       => 'asthim00',
  'asia/tokyo'                         => 'astoky00',
  'asia/ulaanbaatar'                   => 'asulaa00',
  'asia/urumqi'                        => 'asurum00',
  'asia/ust-nera'                      => 'asustm00',
  'asia/vientiane'                     => 'asvien00',
  'asia/vladivostok'                   => 'asvlad00',
  'asia/yakutsk'                       => 'asyaku00',
  'asia/yekaterinburg'                 => 'asyeka00',
  'asia/yerevan'                       => 'asyere00',
  'atlantic/azores'                    => 'atazor00',
  'atlantic/bermuda'                   => 'atberm00',
  'atlantic/canary'                    => 'atcana00',
  'atlantic/cape_verde'                => 'atcape00',
  'atlantic/faroe'                     => 'atfaro00',
  'atlantic/madeira'                   => 'atmade00',
  'atlantic/reykjavik'                 => 'atreyk00',
  'atlantic/south_georgia'             => 'atsout00',
  'atlantic/st_helena'                 => 'atst_h00',
  'atlantic/stanley'                   => 'atstan00',
  'australia/adelaide'                 => 'auadel00',
  'australia/brisbane'                 => 'aubris00',
  'australia/broken_hill'              => 'aubrok00',
  'australia/currie'                   => 'aucurr00',
  'australia/darwin'                   => 'audarw00',
  'australia/eucla'                    => 'aueucl00',
  'australia/hobart'                   => 'auhoba00',
  'australia/lindeman'                 => 'aulind00',
  'australia/lord_howe'                => 'aulord00',
  'australia/melbourne'                => 'aumelb00',
  'australia/perth'                    => 'aupert00',
  'australia/sydney'                   => 'ausydn00',
  'cet'                                => 'cet00',
  'eet'                                => 'eet00',
  'europe/amsterdam'                   => 'euamst00',
  'europe/andorra'                     => 'euando00',
  'europe/athens'                      => 'euathe00',
  'europe/belgrade'                    => 'eubelg00',
  'europe/berlin'                      => 'euberl00',
  'europe/brussels'                    => 'eubrus00',
  'europe/bucharest'                   => 'eubuch00',
  'europe/budapest'                    => 'eubuda00',
  'europe/chisinau'                    => 'euchis00',
  'europe/copenhagen'                  => 'eucope00',
  'europe/dublin'                      => 'eudubl00',
  'europe/gibraltar'                   => 'eugibr00',
  'europe/helsinki'                    => 'euhels00',
  'europe/istanbul'                    => 'euista00',
  'europe/kaliningrad'                 => 'eukali00',
  'europe/kiev'                        => 'eukiev00',
  'europe/lisbon'                      => 'eulisb00',
  'europe/london'                      => 'eulond00',
  'europe/luxembourg'                  => 'euluxe00',
  'europe/madrid'                      => 'eumadr00',
  'europe/malta'                       => 'eumalt00',
  'europe/minsk'                       => 'eumins00',
  'europe/monaco'                      => 'eumona00',
  'europe/moscow'                      => 'eumosc00',
  'europe/oslo'                        => 'euoslo00',
  'europe/paris'                       => 'eupari00',
  'europe/prague'                      => 'euprag00',
  'europe/riga'                        => 'euriga00',
  'europe/rome'                        => 'eurome00',
  'europe/samara'                      => 'eusama00',
  'europe/simferopol'                  => 'eusimf00',
  'europe/sofia'                       => 'eusofi00',
  'europe/stockholm'                   => 'eustoc00',
  'europe/tallinn'                     => 'eutall00',
  'europe/tirane'                      => 'eutira00',
  'europe/uzhgorod'                    => 'euuzhg00',
  'europe/vaduz'                       => 'euvadu00',
  'europe/vienna'                      => 'euvien00',
  'europe/vilnius'                     => 'euviln00',
  'europe/volgograd'                   => 'euvolg00',
  'europe/warsaw'                      => 'euwars00',
  'europe/zaporozhye'                  => 'euzapo00',
  'europe/zurich'                      => 'euzuri00',
  'indian/antananarivo'                => 'inanta00',
  'indian/chagos'                      => 'inchag00',
  'indian/christmas'                   => 'inchri00',
  'indian/cocos'                       => 'incoco00',
  'indian/comoro'                      => 'incomo00',
  'indian/kerguelen'                   => 'inkerg00',
  'indian/mahe'                        => 'inmahe00',
  'indian/maldives'                    => 'inmald00',
  'indian/mauritius'                   => 'inmaur00',
  'indian/mayotte'                     => 'inmayo00',
  'indian/reunion'                     => 'inreun00',
  'met'                                => 'met00',
  'pacific/apia'                       => 'paapia00',
  'pacific/auckland'                   => 'paauck00',
  'pacific/chatham'                    => 'pachat00',
  'pacific/chuuk'                      => 'pachuu00',
  'pacific/easter'                     => 'paeast00',
  'pacific/efate'                      => 'paefat00',
  'pacific/enderbury'                  => 'paende00',
  'pacific/fakaofo'                    => 'pafaka00',
  'pacific/fiji'                       => 'pafiji00',
  'pacific/funafuti'                   => 'pafuna00',
  'pacific/galapagos'                  => 'pagala00',
  'pacific/gambier'                    => 'pagamb00',
  'pacific/guadalcanal'                => 'paguad00',
  'pacific/guam'                       => 'paguam00',
  'pacific/honolulu'                   => 'pahono00',
  'pacific/kiritimati'                 => 'pakiri00',
  'pacific/kosrae'                     => 'pakosr00',
  'pacific/kwajalein'                  => 'pakwaj00',
  'pacific/majuro'                     => 'pamaju00',
  'pacific/marquesas'                  => 'pamarq00',
  'pacific/midway'                     => 'pamidw00',
  'pacific/nauru'                      => 'panaur00',
  'pacific/niue'                       => 'paniue00',
  'pacific/norfolk'                    => 'panorf00',
  'pacific/noumea'                     => 'panoum00',
  'pacific/pago_pago'                  => 'papago00',
  'pacific/palau'                      => 'papala00',
  'pacific/pitcairn'                   => 'papitc00',
  'pacific/pohnpei'                    => 'papohn00',
  'pacific/port_moresby'               => 'paport00',
  'pacific/rarotonga'                  => 'pararo00',
  'pacific/saipan'                     => 'pasaip00',
  'pacific/tahiti'                     => 'patahi00',
  'pacific/tarawa'                     => 'patara00',
  'pacific/tongatapu'                  => 'patong00',
  'pacific/wake'                       => 'pawake00',
  'pacific/wallis'                     => 'pawall00',
  'wet'                                => 'wet00',
  'a'                                  => 'a00',
  'b'                                  => 'b00',
  'c'                                  => 'c00',
  'd'                                  => 'd00',
  'e'                                  => 'e00',
  'etc/gmt'                            => 'etgmt00',
  'etc/gmt+1'                          => 'etgmtp00',
  'etc/gmt+10'                         => 'etgmtp01',
  'etc/gmt+11'                         => 'etgmtp02',
  'etc/gmt+12'                         => 'etgmtp03',
  'etc/gmt+2'                          => 'etgmtp04',
  'etc/gmt+3'                          => 'etgmtp05',
  'etc/gmt+4'                          => 'etgmtp06',
  'etc/gmt+5'                          => 'etgmtp07',
  'etc/gmt+6'                          => 'etgmtp08',
  'etc/gmt+7'                          => 'etgmtp09',
  'etc/gmt+8'                          => 'etgmtp10',
  'etc/gmt+9'                          => 'etgmtp11',
  'etc/gmt-1'                          => 'etgmtm00',
  'etc/gmt-10'                         => 'etgmtm01',
  'etc/gmt-11'                         => 'etgmtm02',
  'etc/gmt-12'                         => 'etgmtm03',
  'etc/gmt-13'                         => 'etgmtm04',
  'etc/gmt-14'                         => 'etgmtm05',
  'etc/gmt-2'                          => 'etgmtm06',
  'etc/gmt-3'                          => 'etgmtm07',
  'etc/gmt-4'                          => 'etgmtm08',
  'etc/gmt-5'                          => 'etgmtm09',
  'etc/gmt-6'                          => 'etgmtm10',
  'etc/gmt-7'                          => 'etgmtm11',
  'etc/gmt-8'                          => 'etgmtm12',
  'etc/gmt-9'                          => 'etgmtm13',
  'f'                                  => 'f00',
  'g'                                  => 'g00',
  'h'                                  => 'h00',
  'i'                                  => 'i00',
  'k'                                  => 'k00',
  'l'                                  => 'l00',
  'm'                                  => 'm00',
  'n'                                  => 'n00',
  'o'                                  => 'o00',
  'p'                                  => 'p00',
  'q'                                  => 'q00',
  'r'                                  => 'r00',
  's'                                  => 's00',
  't'                                  => 't00',
  'u'                                  => 'u00',
  'ut'                                 => 'ut00',
  'utc'                                => 'utc00',
  'v'                                  => 'v00',
  'w'                                  => 'w00',
  'x'                                  => 'x00',
  'y'                                  => 'y00',
  'z'                                  => 'z00',
);

%ZoneNames = (
  'africa/abidjan'                     => 'Africa/Abidjan',
  'africa/accra'                       => 'Africa/Accra',
  'africa/addis_ababa'                 => 'Africa/Addis_Ababa',
  'africa/algiers'                     => 'Africa/Algiers',
  'africa/asmara'                      => 'Africa/Asmara',
  'africa/bamako'                      => 'Africa/Bamako',
  'africa/bangui'                      => 'Africa/Bangui',
  'africa/banjul'                      => 'Africa/Banjul',
  'africa/bissau'                      => 'Africa/Bissau',
  'africa/blantyre'                    => 'Africa/Blantyre',
  'africa/brazzaville'                 => 'Africa/Brazzaville',
  'africa/bujumbura'                   => 'Africa/Bujumbura',
  'africa/cairo'                       => 'Africa/Cairo',
  'africa/casablanca'                  => 'Africa/Casablanca',
  'africa/ceuta'                       => 'Africa/Ceuta',
  'africa/conakry'                     => 'Africa/Conakry',
  'africa/dakar'                       => 'Africa/Dakar',
  'africa/dar_es_salaam'               => 'Africa/Dar_es_Salaam',
  'africa/djibouti'                    => 'Africa/Djibouti',
  'africa/douala'                      => 'Africa/Douala',
  'africa/el_aaiun'                    => 'Africa/El_Aaiun',
  'africa/freetown'                    => 'Africa/Freetown',
  'africa/gaborone'                    => 'Africa/Gaborone',
  'africa/harare'                      => 'Africa/Harare',
  'africa/johannesburg'                => 'Africa/Johannesburg',
  'africa/juba'                        => 'Africa/Juba',
  'africa/kampala'                     => 'Africa/Kampala',
  'africa/khartoum'                    => 'Africa/Khartoum',
  'africa/kigali'                      => 'Africa/Kigali',
  'africa/kinshasa'                    => 'Africa/Kinshasa',
  'africa/lagos'                       => 'Africa/Lagos',
  'africa/libreville'                  => 'Africa/Libreville',
  'africa/lome'                        => 'Africa/Lome',
  'africa/luanda'                      => 'Africa/Luanda',
  'africa/lubumbashi'                  => 'Africa/Lubumbashi',
  'africa/lusaka'                      => 'Africa/Lusaka',
  'africa/malabo'                      => 'Africa/Malabo',
  'africa/maputo'                      => 'Africa/Maputo',
  'africa/maseru'                      => 'Africa/Maseru',
  'africa/mbabane'                     => 'Africa/Mbabane',
  'africa/mogadishu'                   => 'Africa/Mogadishu',
  'africa/monrovia'                    => 'Africa/Monrovia',
  'africa/nairobi'                     => 'Africa/Nairobi',
  'africa/ndjamena'                    => 'Africa/Ndjamena',
  'africa/niamey'                      => 'Africa/Niamey',
  'africa/nouakchott'                  => 'Africa/Nouakchott',
  'africa/ouagadougou'                 => 'Africa/Ouagadougou',
  'africa/porto-novo'                  => 'Africa/Porto-Novo',
  'africa/sao_tome'                    => 'Africa/Sao_Tome',
  'africa/tripoli'                     => 'Africa/Tripoli',
  'africa/tunis'                       => 'Africa/Tunis',
  'africa/windhoek'                    => 'Africa/Windhoek',
  'america/adak'                       => 'America/Adak',
  'america/anchorage'                  => 'America/Anchorage',
  'america/anguilla'                   => 'America/Anguilla',
  'america/antigua'                    => 'America/Antigua',
  'america/araguaina'                  => 'America/Araguaina',
  'america/argentina/buenos_aires'     => 'America/Argentina/Buenos_Aires',
  'america/argentina/catamarca'        => 'America/Argentina/Catamarca',
  'america/argentina/cordoba'          => 'America/Argentina/Cordoba',
  'america/argentina/jujuy'            => 'America/Argentina/Jujuy',
  'america/argentina/la_rioja'         => 'America/Argentina/La_Rioja',
  'america/argentina/mendoza'          => 'America/Argentina/Mendoza',
  'america/argentina/rio_gallegos'     => 'America/Argentina/Rio_Gallegos',
  'america/argentina/salta'            => 'America/Argentina/Salta',
  'america/argentina/san_juan'         => 'America/Argentina/San_Juan',
  'america/argentina/san_luis'         => 'America/Argentina/San_Luis',
  'america/argentina/tucuman'          => 'America/Argentina/Tucuman',
  'america/argentina/ushuaia'          => 'America/Argentina/Ushuaia',
  'america/aruba'                      => 'America/Aruba',
  'america/asuncion'                   => 'America/Asuncion',
  'america/atikokan'                   => 'America/Atikokan',
  'america/bahia'                      => 'America/Bahia',
  'america/bahia_banderas'             => 'America/Bahia_Banderas',
  'america/barbados'                   => 'America/Barbados',
  'america/belem'                      => 'America/Belem',
  'america/belize'                     => 'America/Belize',
  'america/blanc-sablon'               => 'America/Blanc-Sablon',
  'america/boa_vista'                  => 'America/Boa_Vista',
  'america/bogota'                     => 'America/Bogota',
  'america/boise'                      => 'America/Boise',
  'america/cambridge_bay'              => 'America/Cambridge_Bay',
  'america/campo_grande'               => 'America/Campo_Grande',
  'america/cancun'                     => 'America/Cancun',
  'america/caracas'                    => 'America/Caracas',
  'america/cayenne'                    => 'America/Cayenne',
  'america/cayman'                     => 'America/Cayman',
  'america/chicago'                    => 'America/Chicago',
  'america/chihuahua'                  => 'America/Chihuahua',
  'america/costa_rica'                 => 'America/Costa_Rica',
  'america/creston'                    => 'America/Creston',
  'america/cuiaba'                     => 'America/Cuiaba',
  'america/curacao'                    => 'America/Curacao',
  'america/danmarkshavn'               => 'America/Danmarkshavn',
  'america/dawson'                     => 'America/Dawson',
  'america/dawson_creek'               => 'America/Dawson_Creek',
  'america/denver'                     => 'America/Denver',
  'america/detroit'                    => 'America/Detroit',
  'america/dominica'                   => 'America/Dominica',
  'america/edmonton'                   => 'America/Edmonton',
  'america/eirunepe'                   => 'America/Eirunepe',
  'america/el_salvador'                => 'America/El_Salvador',
  'america/fortaleza'                  => 'America/Fortaleza',
  'america/glace_bay'                  => 'America/Glace_Bay',
  'america/godthab'                    => 'America/Godthab',
  'america/goose_bay'                  => 'America/Goose_Bay',
  'america/grand_turk'                 => 'America/Grand_Turk',
  'america/grenada'                    => 'America/Grenada',
  'america/guadeloupe'                 => 'America/Guadeloupe',
  'america/guatemala'                  => 'America/Guatemala',
  'america/guayaquil'                  => 'America/Guayaquil',
  'america/guyana'                     => 'America/Guyana',
  'america/halifax'                    => 'America/Halifax',
  'america/havana'                     => 'America/Havana',
  'america/hermosillo'                 => 'America/Hermosillo',
  'america/indiana/indianapolis'       => 'America/Indiana/Indianapolis',
  'america/indiana/knox'               => 'America/Indiana/Knox',
  'america/indiana/marengo'            => 'America/Indiana/Marengo',
  'america/indiana/petersburg'         => 'America/Indiana/Petersburg',
  'america/indiana/tell_city'          => 'America/Indiana/Tell_City',
  'america/indiana/vevay'              => 'America/Indiana/Vevay',
  'america/indiana/vincennes'          => 'America/Indiana/Vincennes',
  'america/indiana/winamac'            => 'America/Indiana/Winamac',
  'america/inuvik'                     => 'America/Inuvik',
  'america/iqaluit'                    => 'America/Iqaluit',
  'america/jamaica'                    => 'America/Jamaica',
  'america/juneau'                     => 'America/Juneau',
  'america/kentucky/louisville'        => 'America/Kentucky/Louisville',
  'america/kentucky/monticello'        => 'America/Kentucky/Monticello',
  'america/la_paz'                     => 'America/La_Paz',
  'america/lima'                       => 'America/Lima',
  'america/los_angeles'                => 'America/Los_Angeles',
  'america/maceio'                     => 'America/Maceio',
  'america/managua'                    => 'America/Managua',
  'america/manaus'                     => 'America/Manaus',
  'america/martinique'                 => 'America/Martinique',
  'america/matamoros'                  => 'America/Matamoros',
  'america/mazatlan'                   => 'America/Mazatlan',
  'america/menominee'                  => 'America/Menominee',
  'america/merida'                     => 'America/Merida',
  'america/metlakatla'                 => 'America/Metlakatla',
  'america/mexico_city'                => 'America/Mexico_City',
  'america/miquelon'                   => 'America/Miquelon',
  'america/moncton'                    => 'America/Moncton',
  'america/monterrey'                  => 'America/Monterrey',
  'america/montevideo'                 => 'America/Montevideo',
  'america/montreal'                   => 'America/Montreal',
  'america/montserrat'                 => 'America/Montserrat',
  'america/nassau'                     => 'America/Nassau',
  'america/new_york'                   => 'America/New_York',
  'america/nipigon'                    => 'America/Nipigon',
  'america/nome'                       => 'America/Nome',
  'america/noronha'                    => 'America/Noronha',
  'america/north_dakota/beulah'        => 'America/North_Dakota/Beulah',
  'america/north_dakota/center'        => 'America/North_Dakota/Center',
  'america/north_dakota/new_salem'     => 'America/North_Dakota/New_Salem',
  'america/ojinaga'                    => 'America/Ojinaga',
  'america/panama'                     => 'America/Panama',
  'america/pangnirtung'                => 'America/Pangnirtung',
  'america/paramaribo'                 => 'America/Paramaribo',
  'america/phoenix'                    => 'America/Phoenix',
  'america/port-au-prince'             => 'America/Port-au-Prince',
  'america/port_of_spain'              => 'America/Port_of_Spain',
  'america/porto_velho'                => 'America/Porto_Velho',
  'america/puerto_rico'                => 'America/Puerto_Rico',
  'america/rainy_river'                => 'America/Rainy_River',
  'america/rankin_inlet'               => 'America/Rankin_Inlet',
  'america/recife'                     => 'America/Recife',
  'america/regina'                     => 'America/Regina',
  'america/resolute'                   => 'America/Resolute',
  'america/rio_branco'                 => 'America/Rio_Branco',
  'america/santa_isabel'               => 'America/Santa_Isabel',
  'america/santarem'                   => 'America/Santarem',
  'america/santiago'                   => 'America/Santiago',
  'america/santo_domingo'              => 'America/Santo_Domingo',
  'america/sao_paulo'                  => 'America/Sao_Paulo',
  'america/scoresbysund'               => 'America/Scoresbysund',
  'america/sitka'                      => 'America/Sitka',
  'america/st_johns'                   => 'America/St_Johns',
  'america/st_kitts'                   => 'America/St_Kitts',
  'america/st_lucia'                   => 'America/St_Lucia',
  'america/st_thomas'                  => 'America/St_Thomas',
  'america/st_vincent'                 => 'America/St_Vincent',
  'america/swift_current'              => 'America/Swift_Current',
  'america/tegucigalpa'                => 'America/Tegucigalpa',
  'america/thule'                      => 'America/Thule',
  'america/thunder_bay'                => 'America/Thunder_Bay',
  'america/tijuana'                    => 'America/Tijuana',
  'america/toronto'                    => 'America/Toronto',
  'america/tortola'                    => 'America/Tortola',
  'america/vancouver'                  => 'America/Vancouver',
  'america/whitehorse'                 => 'America/Whitehorse',
  'america/winnipeg'                   => 'America/Winnipeg',
  'america/yakutat'                    => 'America/Yakutat',
  'america/yellowknife'                => 'America/Yellowknife',
  'antarctica/casey'                   => 'Antarctica/Casey',
  'antarctica/davis'                   => 'Antarctica/Davis',
  'antarctica/dumontdurville'          => 'Antarctica/DumontDUrville',
  'antarctica/macquarie'               => 'Antarctica/Macquarie',
  'antarctica/mawson'                  => 'Antarctica/Mawson',
  'antarctica/mcmurdo'                 => 'Antarctica/McMurdo',
  'antarctica/palmer'                  => 'Antarctica/Palmer',
  'antarctica/rothera'                 => 'Antarctica/Rothera',
  'antarctica/syowa'                   => 'Antarctica/Syowa',
  'antarctica/vostok'                  => 'Antarctica/Vostok',
  'asia/aden'                          => 'Asia/Aden',
  'asia/almaty'                        => 'Asia/Almaty',
  'asia/amman'                         => 'Asia/Amman',
  'asia/anadyr'                        => 'Asia/Anadyr',
  'asia/aqtau'                         => 'Asia/Aqtau',
  'asia/aqtobe'                        => 'Asia/Aqtobe',
  'asia/ashgabat'                      => 'Asia/Ashgabat',
  'asia/baghdad'                       => 'Asia/Baghdad',
  'asia/bahrain'                       => 'Asia/Bahrain',
  'asia/baku'                          => 'Asia/Baku',
  'asia/bangkok'                       => 'Asia/Bangkok',
  'asia/beirut'                        => 'Asia/Beirut',
  'asia/bishkek'                       => 'Asia/Bishkek',
  'asia/brunei'                        => 'Asia/Brunei',
  'asia/choibalsan'                    => 'Asia/Choibalsan',
  'asia/chongqing'                     => 'Asia/Chongqing',
  'asia/colombo'                       => 'Asia/Colombo',
  'asia/damascus'                      => 'Asia/Damascus',
  'asia/dhaka'                         => 'Asia/Dhaka',
  'asia/dili'                          => 'Asia/Dili',
  'asia/dubai'                         => 'Asia/Dubai',
  'asia/dushanbe'                      => 'Asia/Dushanbe',
  'asia/gaza'                          => 'Asia/Gaza',
  'asia/harbin'                        => 'Asia/Harbin',
  'asia/hebron'                        => 'Asia/Hebron',
  'asia/ho_chi_minh'                   => 'Asia/Ho_Chi_Minh',
  'asia/hong_kong'                     => 'Asia/Hong_Kong',
  'asia/hovd'                          => 'Asia/Hovd',
  'asia/irkutsk'                       => 'Asia/Irkutsk',
  'asia/jakarta'                       => 'Asia/Jakarta',
  'asia/jayapura'                      => 'Asia/Jayapura',
  'asia/jerusalem'                     => 'Asia/Jerusalem',
  'asia/kabul'                         => 'Asia/Kabul',
  'asia/kamchatka'                     => 'Asia/Kamchatka',
  'asia/karachi'                       => 'Asia/Karachi',
  'asia/kashgar'                       => 'Asia/Kashgar',
  'asia/kathmandu'                     => 'Asia/Kathmandu',
  'asia/khandyga'                      => 'Asia/Khandyga',
  'asia/kolkata'                       => 'Asia/Kolkata',
  'asia/krasnoyarsk'                   => 'Asia/Krasnoyarsk',
  'asia/kuala_lumpur'                  => 'Asia/Kuala_Lumpur',
  'asia/kuching'                       => 'Asia/Kuching',
  'asia/kuwait'                        => 'Asia/Kuwait',
  'asia/macau'                         => 'Asia/Macau',
  'asia/magadan'                       => 'Asia/Magadan',
  'asia/makassar'                      => 'Asia/Makassar',
  'asia/manila'                        => 'Asia/Manila',
  'asia/muscat'                        => 'Asia/Muscat',
  'asia/nicosia'                       => 'Asia/Nicosia',
  'asia/novokuznetsk'                  => 'Asia/Novokuznetsk',
  'asia/novosibirsk'                   => 'Asia/Novosibirsk',
  'asia/omsk'                          => 'Asia/Omsk',
  'asia/oral'                          => 'Asia/Oral',
  'asia/phnom_penh'                    => 'Asia/Phnom_Penh',
  'asia/pontianak'                     => 'Asia/Pontianak',
  'asia/pyongyang'                     => 'Asia/Pyongyang',
  'asia/qatar'                         => 'Asia/Qatar',
  'asia/qyzylorda'                     => 'Asia/Qyzylorda',
  'asia/rangoon'                       => 'Asia/Rangoon',
  'asia/riyadh'                        => 'Asia/Riyadh',
  'asia/sakhalin'                      => 'Asia/Sakhalin',
  'asia/samarkand'                     => 'Asia/Samarkand',
  'asia/seoul'                         => 'Asia/Seoul',
  'asia/shanghai'                      => 'Asia/Shanghai',
  'asia/singapore'                     => 'Asia/Singapore',
  'asia/taipei'                        => 'Asia/Taipei',
  'asia/tashkent'                      => 'Asia/Tashkent',
  'asia/tbilisi'                       => 'Asia/Tbilisi',
  'asia/tehran'                        => 'Asia/Tehran',
  'asia/thimphu'                       => 'Asia/Thimphu',
  'asia/tokyo'                         => 'Asia/Tokyo',
  'asia/ulaanbaatar'                   => 'Asia/Ulaanbaatar',
  'asia/urumqi'                        => 'Asia/Urumqi',
  'asia/ust-nera'                      => 'Asia/Ust-Nera',
  'asia/vientiane'                     => 'Asia/Vientiane',
  'asia/vladivostok'                   => 'Asia/Vladivostok',
  'asia/yakutsk'                       => 'Asia/Yakutsk',
  'asia/yekaterinburg'                 => 'Asia/Yekaterinburg',
  'asia/yerevan'                       => 'Asia/Yerevan',
  'atlantic/azores'                    => 'Atlantic/Azores',
  'atlantic/bermuda'                   => 'Atlantic/Bermuda',
  'atlantic/canary'                    => 'Atlantic/Canary',
  'atlantic/cape_verde'                => 'Atlantic/Cape_Verde',
  'atlantic/faroe'                     => 'Atlantic/Faroe',
  'atlantic/madeira'                   => 'Atlantic/Madeira',
  'atlantic/reykjavik'                 => 'Atlantic/Reykjavik',
  'atlantic/south_georgia'             => 'Atlantic/South_Georgia',
  'atlantic/st_helena'                 => 'Atlantic/St_Helena',
  'atlantic/stanley'                   => 'Atlantic/Stanley',
  'australia/adelaide'                 => 'Australia/Adelaide',
  'australia/brisbane'                 => 'Australia/Brisbane',
  'australia/broken_hill'              => 'Australia/Broken_Hill',
  'australia/currie'                   => 'Australia/Currie',
  'australia/darwin'                   => 'Australia/Darwin',
  'australia/eucla'                    => 'Australia/Eucla',
  'australia/hobart'                   => 'Australia/Hobart',
  'australia/lindeman'                 => 'Australia/Lindeman',
  'australia/lord_howe'                => 'Australia/Lord_Howe',
  'australia/melbourne'                => 'Australia/Melbourne',
  'australia/perth'                    => 'Australia/Perth',
  'australia/sydney'                   => 'Australia/Sydney',
  'cet'                                => 'CET',
  'eet'                                => 'EET',
  'europe/amsterdam'                   => 'Europe/Amsterdam',
  'europe/andorra'                     => 'Europe/Andorra',
  'europe/athens'                      => 'Europe/Athens',
  'europe/belgrade'                    => 'Europe/Belgrade',
  'europe/berlin'                      => 'Europe/Berlin',
  'europe/brussels'                    => 'Europe/Brussels',
  'europe/bucharest'                   => 'Europe/Bucharest',
  'europe/budapest'                    => 'Europe/Budapest',
  'europe/chisinau'                    => 'Europe/Chisinau',
  'europe/copenhagen'                  => 'Europe/Copenhagen',
  'europe/dublin'                      => 'Europe/Dublin',
  'europe/gibraltar'                   => 'Europe/Gibraltar',
  'europe/helsinki'                    => 'Europe/Helsinki',
  'europe/istanbul'                    => 'Europe/Istanbul',
  'europe/kaliningrad'                 => 'Europe/Kaliningrad',
  'europe/kiev'                        => 'Europe/Kiev',
  'europe/lisbon'                      => 'Europe/Lisbon',
  'europe/london'                      => 'Europe/London',
  'europe/luxembourg'                  => 'Europe/Luxembourg',
  'europe/madrid'                      => 'Europe/Madrid',
  'europe/malta'                       => 'Europe/Malta',
  'europe/minsk'                       => 'Europe/Minsk',
  'europe/monaco'                      => 'Europe/Monaco',
  'europe/moscow'                      => 'Europe/Moscow',
  'europe/oslo'                        => 'Europe/Oslo',
  'europe/paris'                       => 'Europe/Paris',
  'europe/prague'                      => 'Europe/Prague',
  'europe/riga'                        => 'Europe/Riga',
  'europe/rome'                        => 'Europe/Rome',
  'europe/samara'                      => 'Europe/Samara',
  'europe/simferopol'                  => 'Europe/Simferopol',
  'europe/sofia'                       => 'Europe/Sofia',
  'europe/stockholm'                   => 'Europe/Stockholm',
  'europe/tallinn'                     => 'Europe/Tallinn',
  'europe/tirane'                      => 'Europe/Tirane',
  'europe/uzhgorod'                    => 'Europe/Uzhgorod',
  'europe/vaduz'                       => 'Europe/Vaduz',
  'europe/vienna'                      => 'Europe/Vienna',
  'europe/vilnius'                     => 'Europe/Vilnius',
  'europe/volgograd'                   => 'Europe/Volgograd',
  'europe/warsaw'                      => 'Europe/Warsaw',
  'europe/zaporozhye'                  => 'Europe/Zaporozhye',
  'europe/zurich'                      => 'Europe/Zurich',
  'indian/antananarivo'                => 'Indian/Antananarivo',
  'indian/chagos'                      => 'Indian/Chagos',
  'indian/christmas'                   => 'Indian/Christmas',
  'indian/cocos'                       => 'Indian/Cocos',
  'indian/comoro'                      => 'Indian/Comoro',
  'indian/kerguelen'                   => 'Indian/Kerguelen',
  'indian/mahe'                        => 'Indian/Mahe',
  'indian/maldives'                    => 'Indian/Maldives',
  'indian/mauritius'                   => 'Indian/Mauritius',
  'indian/mayotte'                     => 'Indian/Mayotte',
  'indian/reunion'                     => 'Indian/Reunion',
  'met'                                => 'MET',
  'pacific/apia'                       => 'Pacific/Apia',
  'pacific/auckland'                   => 'Pacific/Auckland',
  'pacific/chatham'                    => 'Pacific/Chatham',
  'pacific/chuuk'                      => 'Pacific/Chuuk',
  'pacific/easter'                     => 'Pacific/Easter',
  'pacific/efate'                      => 'Pacific/Efate',
  'pacific/enderbury'                  => 'Pacific/Enderbury',
  'pacific/fakaofo'                    => 'Pacific/Fakaofo',
  'pacific/fiji'                       => 'Pacific/Fiji',
  'pacific/funafuti'                   => 'Pacific/Funafuti',
  'pacific/galapagos'                  => 'Pacific/Galapagos',
  'pacific/gambier'                    => 'Pacific/Gambier',
  'pacific/guadalcanal'                => 'Pacific/Guadalcanal',
  'pacific/guam'                       => 'Pacific/Guam',
  'pacific/honolulu'                   => 'Pacific/Honolulu',
  'pacific/kiritimati'                 => 'Pacific/Kiritimati',
  'pacific/kosrae'                     => 'Pacific/Kosrae',
  'pacific/kwajalein'                  => 'Pacific/Kwajalein',
  'pacific/majuro'                     => 'Pacific/Majuro',
  'pacific/marquesas'                  => 'Pacific/Marquesas',
  'pacific/midway'                     => 'Pacific/Midway',
  'pacific/nauru'                      => 'Pacific/Nauru',
  'pacific/niue'                       => 'Pacific/Niue',
  'pacific/norfolk'                    => 'Pacific/Norfolk',
  'pacific/noumea'                     => 'Pacific/Noumea',
  'pacific/pago_pago'                  => 'Pacific/Pago_Pago',
  'pacific/palau'                      => 'Pacific/Palau',
  'pacific/pitcairn'                   => 'Pacific/Pitcairn',
  'pacific/pohnpei'                    => 'Pacific/Pohnpei',
  'pacific/port_moresby'               => 'Pacific/Port_Moresby',
  'pacific/rarotonga'                  => 'Pacific/Rarotonga',
  'pacific/saipan'                     => 'Pacific/Saipan',
  'pacific/tahiti'                     => 'Pacific/Tahiti',
  'pacific/tarawa'                     => 'Pacific/Tarawa',
  'pacific/tongatapu'                  => 'Pacific/Tongatapu',
  'pacific/wake'                       => 'Pacific/Wake',
  'pacific/wallis'                     => 'Pacific/Wallis',
  'wet'                                => 'WET',
  'a'                                  => 'A',
  'b'                                  => 'B',
  'c'                                  => 'C',
  'd'                                  => 'D',
  'e'                                  => 'E',
  'etc/gmt'                            => 'Etc/GMT',
  'etc/gmt+1'                          => 'Etc/GMT+1',
  'etc/gmt+10'                         => 'Etc/GMT+10',
  'etc/gmt+11'                         => 'Etc/GMT+11',
  'etc/gmt+12'                         => 'Etc/GMT+12',
  'etc/gmt+2'                          => 'Etc/GMT+2',
  'etc/gmt+3'                          => 'Etc/GMT+3',
  'etc/gmt+4'                          => 'Etc/GMT+4',
  'etc/gmt+5'                          => 'Etc/GMT+5',
  'etc/gmt+6'                          => 'Etc/GMT+6',
  'etc/gmt+7'                          => 'Etc/GMT+7',
  'etc/gmt+8'                          => 'Etc/GMT+8',
  'etc/gmt+9'                          => 'Etc/GMT+9',
  'etc/gmt-1'                          => 'Etc/GMT-1',
  'etc/gmt-10'                         => 'Etc/GMT-10',
  'etc/gmt-11'                         => 'Etc/GMT-11',
  'etc/gmt-12'                         => 'Etc/GMT-12',
  'etc/gmt-13'                         => 'Etc/GMT-13',
  'etc/gmt-14'                         => 'Etc/GMT-14',
  'etc/gmt-2'                          => 'Etc/GMT-2',
  'etc/gmt-3'                          => 'Etc/GMT-3',
  'etc/gmt-4'                          => 'Etc/GMT-4',
  'etc/gmt-5'                          => 'Etc/GMT-5',
  'etc/gmt-6'                          => 'Etc/GMT-6',
  'etc/gmt-7'                          => 'Etc/GMT-7',
  'etc/gmt-8'                          => 'Etc/GMT-8',
  'etc/gmt-9'                          => 'Etc/GMT-9',
  'f'                                  => 'F',
  'g'                                  => 'G',
  'h'                                  => 'H',
  'i'                                  => 'I',
  'k'                                  => 'K',
  'l'                                  => 'L',
  'm'                                  => 'M',
  'n'                                  => 'N',
  'o'                                  => 'O',
  'p'                                  => 'P',
  'q'                                  => 'Q',
  'r'                                  => 'R',
  's'                                  => 'S',
  't'                                  => 'T',
  'u'                                  => 'U',
  'ut'                                 => 'UT',
  'utc'                                => 'UTC',
  'v'                                  => 'V',
  'w'                                  => 'W',
  'x'                                  => 'X',
  'y'                                  => 'Y',
  'z'                                  => 'Z',
);

%Alias = (
  'a'                                  => 'a',
  'africa/abidjan'                     => 'africa/abidjan',
  'africa/accra'                       => 'africa/accra',
  'africa/addis_ababa'                 => 'africa/addis_ababa',
  'africa/algiers'                     => 'africa/algiers',
  'africa/asmara'                      => 'africa/asmara',
  'africa/bamako'                      => 'africa/bamako',
  'africa/bangui'                      => 'africa/bangui',
  'africa/banjul'                      => 'africa/banjul',
  'africa/bissau'                      => 'africa/bissau',
  'africa/blantyre'                    => 'africa/blantyre',
  'africa/brazzaville'                 => 'africa/brazzaville',
  'africa/bujumbura'                   => 'africa/bujumbura',
  'africa/cairo'                       => 'africa/cairo',
  'africa/casablanca'                  => 'africa/casablanca',
  'africa/ceuta'                       => 'africa/ceuta',
  'africa/conakry'                     => 'africa/conakry',
  'africa/dakar'                       => 'africa/dakar',
  'africa/dar_es_salaam'               => 'africa/dar_es_salaam',
  'africa/djibouti'                    => 'africa/djibouti',
  'africa/douala'                      => 'africa/douala',
  'africa/el_aaiun'                    => 'africa/el_aaiun',
  'africa/freetown'                    => 'africa/freetown',
  'africa/gaborone'                    => 'africa/gaborone',
  'africa/harare'                      => 'africa/harare',
  'africa/johannesburg'                => 'africa/johannesburg',
  'africa/juba'                        => 'africa/juba',
  'africa/kampala'                     => 'africa/kampala',
  'africa/khartoum'                    => 'africa/khartoum',
  'africa/kigali'                      => 'africa/kigali',
  'africa/kinshasa'                    => 'africa/kinshasa',
  'africa/lagos'                       => 'africa/lagos',
  'africa/libreville'                  => 'africa/libreville',
  'africa/lome'                        => 'africa/lome',
  'africa/luanda'                      => 'africa/luanda',
  'africa/lubumbashi'                  => 'africa/lubumbashi',
  'africa/lusaka'                      => 'africa/lusaka',
  'africa/malabo'                      => 'africa/malabo',
  'africa/maputo'                      => 'africa/maputo',
  'africa/maseru'                      => 'africa/maseru',
  'africa/mbabane'                     => 'africa/mbabane',
  'africa/mogadishu'                   => 'africa/mogadishu',
  'africa/monrovia'                    => 'africa/monrovia',
  'africa/nairobi'                     => 'africa/nairobi',
  'africa/ndjamena'                    => 'africa/ndjamena',
  'africa/niamey'                      => 'africa/niamey',
  'africa/nouakchott'                  => 'africa/nouakchott',
  'africa/ouagadougou'                 => 'africa/ouagadougou',
  'africa/porto-novo'                  => 'africa/porto-novo',
  'africa/sao_tome'                    => 'africa/sao_tome',
  'africa/tripoli'                     => 'africa/tripoli',
  'africa/tunis'                       => 'africa/tunis',
  'africa/windhoek'                    => 'africa/windhoek',
  'america/adak'                       => 'america/adak',
  'america/anchorage'                  => 'america/anchorage',
  'america/anguilla'                   => 'america/anguilla',
  'america/antigua'                    => 'america/antigua',
  'america/araguaina'                  => 'america/araguaina',
  'america/argentina/buenos_aires'     => 'america/argentina/buenos_aires',
  'america/argentina/catamarca'        => 'america/argentina/catamarca',
  'america/argentina/cordoba'          => 'america/argentina/cordoba',
  'america/argentina/jujuy'            => 'america/argentina/jujuy',
  'america/argentina/la_rioja'         => 'america/argentina/la_rioja',
  'america/argentina/mendoza'          => 'america/argentina/mendoza',
  'america/argentina/rio_gallegos'     => 'america/argentina/rio_gallegos',
  'america/argentina/salta'            => 'america/argentina/salta',
  'america/argentina/san_juan'         => 'america/argentina/san_juan',
  'america/argentina/san_luis'         => 'america/argentina/san_luis',
  'america/argentina/tucuman'          => 'america/argentina/tucuman',
  'america/argentina/ushuaia'          => 'america/argentina/ushuaia',
  'america/aruba'                      => 'america/aruba',
  'america/asuncion'                   => 'america/asuncion',
  'america/atikokan'                   => 'america/atikokan',
  'america/bahia'                      => 'america/bahia',
  'america/bahia_banderas'             => 'america/bahia_banderas',
  'america/barbados'                   => 'america/barbados',
  'america/belem'                      => 'america/belem',
  'america/belize'                     => 'america/belize',
  'america/blanc-sablon'               => 'america/blanc-sablon',
  'america/boa_vista'                  => 'america/boa_vista',
  'america/bogota'                     => 'america/bogota',
  'america/boise'                      => 'america/boise',
  'america/cambridge_bay'              => 'america/cambridge_bay',
  'america/campo_grande'               => 'america/campo_grande',
  'america/cancun'                     => 'america/cancun',
  'america/caracas'                    => 'america/caracas',
  'america/cayenne'                    => 'america/cayenne',
  'america/cayman'                     => 'america/cayman',
  'america/chicago'                    => 'america/chicago',
  'america/chihuahua'                  => 'america/chihuahua',
  'america/costa_rica'                 => 'america/costa_rica',
  'america/creston'                    => 'america/creston',
  'america/cuiaba'                     => 'america/cuiaba',
  'america/curacao'                    => 'america/curacao',
  'america/danmarkshavn'               => 'america/danmarkshavn',
  'america/dawson'                     => 'america/dawson',
  'america/dawson_creek'               => 'america/dawson_creek',
  'america/denver'                     => 'america/denver',
  'america/detroit'                    => 'america/detroit',
  'america/dominica'                   => 'america/dominica',
  'america/edmonton'                   => 'america/edmonton',
  'america/eirunepe'                   => 'america/eirunepe',
  'america/el_salvador'                => 'america/el_salvador',
  'america/fortaleza'                  => 'america/fortaleza',
  'america/glace_bay'                  => 'america/glace_bay',
  'america/godthab'                    => 'america/godthab',
  'america/goose_bay'                  => 'america/goose_bay',
  'america/grand_turk'                 => 'america/grand_turk',
  'america/grenada'                    => 'america/grenada',
  'america/guadeloupe'                 => 'america/guadeloupe',
  'america/guatemala'                  => 'america/guatemala',
  'america/guayaquil'                  => 'america/guayaquil',
  'america/guyana'                     => 'america/guyana',
  'america/halifax'                    => 'america/halifax',
  'america/havana'                     => 'america/havana',
  'america/hermosillo'                 => 'america/hermosillo',
  'america/indiana/indianapolis'       => 'america/indiana/indianapolis',
  'america/indiana/knox'               => 'america/indiana/knox',
  'america/indiana/marengo'            => 'america/indiana/marengo',
  'america/indiana/petersburg'         => 'america/indiana/petersburg',
  'america/indiana/tell_city'          => 'america/indiana/tell_city',
  'america/indiana/vevay'              => 'america/indiana/vevay',
  'america/indiana/vincennes'          => 'america/indiana/vincennes',
  'america/indiana/winamac'            => 'america/indiana/winamac',
  'america/inuvik'                     => 'america/inuvik',
  'america/iqaluit'                    => 'america/iqaluit',
  'america/jamaica'                    => 'america/jamaica',
  'america/juneau'                     => 'america/juneau',
  'america/kentucky/louisville'        => 'america/kentucky/louisville',
  'america/kentucky/monticello'        => 'america/kentucky/monticello',
  'america/la_paz'                     => 'america/la_paz',
  'america/lima'                       => 'america/lima',
  'america/los_angeles'                => 'america/los_angeles',
  'america/maceio'                     => 'america/maceio',
  'america/managua'                    => 'america/managua',
  'america/manaus'                     => 'america/manaus',
  'america/martinique'                 => 'america/martinique',
  'america/matamoros'                  => 'america/matamoros',
  'america/mazatlan'                   => 'america/mazatlan',
  'america/menominee'                  => 'america/menominee',
  'america/merida'                     => 'america/merida',
  'america/metlakatla'                 => 'america/metlakatla',
  'america/mexico_city'                => 'america/mexico_city',
  'america/miquelon'                   => 'america/miquelon',
  'america/moncton'                    => 'america/moncton',
  'america/monterrey'                  => 'america/monterrey',
  'america/montevideo'                 => 'america/montevideo',
  'america/montreal'                   => 'america/montreal',
  'america/montserrat'                 => 'america/montserrat',
  'america/nassau'                     => 'america/nassau',
  'america/new_york'                   => 'america/new_york',
  'america/nipigon'                    => 'america/nipigon',
  'america/nome'                       => 'america/nome',
  'america/noronha'                    => 'america/noronha',
  'america/north_dakota/beulah'        => 'america/north_dakota/beulah',
  'america/north_dakota/center'        => 'america/north_dakota/center',
  'america/north_dakota/new_salem'     => 'america/north_dakota/new_salem',
  'america/ojinaga'                    => 'america/ojinaga',
  'america/panama'                     => 'america/panama',
  'america/pangnirtung'                => 'america/pangnirtung',
  'america/paramaribo'                 => 'america/paramaribo',
  'america/phoenix'                    => 'america/phoenix',
  'america/port-au-prince'             => 'america/port-au-prince',
  'america/port_of_spain'              => 'america/port_of_spain',
  'america/porto_velho'                => 'america/porto_velho',
  'america/puerto_rico'                => 'america/puerto_rico',
  'america/rainy_river'                => 'america/rainy_river',
  'america/rankin_inlet'               => 'america/rankin_inlet',
  'america/recife'                     => 'america/recife',
  'america/regina'                     => 'america/regina',
  'america/resolute'                   => 'america/resolute',
  'america/rio_branco'                 => 'america/rio_branco',
  'america/santa_isabel'               => 'america/santa_isabel',
  'america/santarem'                   => 'america/santarem',
  'america/santiago'                   => 'america/santiago',
  'america/santo_domingo'              => 'america/santo_domingo',
  'america/sao_paulo'                  => 'america/sao_paulo',
  'america/scoresbysund'               => 'america/scoresbysund',
  'america/sitka'                      => 'america/sitka',
  'america/st_johns'                   => 'america/st_johns',
  'america/st_kitts'                   => 'america/st_kitts',
  'america/st_lucia'                   => 'america/st_lucia',
  'america/st_thomas'                  => 'america/st_thomas',
  'america/st_vincent'                 => 'america/st_vincent',
  'america/swift_current'              => 'america/swift_current',
  'america/tegucigalpa'                => 'america/tegucigalpa',
  'america/thule'                      => 'america/thule',
  'america/thunder_bay'                => 'america/thunder_bay',
  'america/tijuana'                    => 'america/tijuana',
  'america/toronto'                    => 'america/toronto',
  'america/tortola'                    => 'america/tortola',
  'america/vancouver'                  => 'america/vancouver',
  'america/whitehorse'                 => 'america/whitehorse',
  'america/winnipeg'                   => 'america/winnipeg',
  'america/yakutat'                    => 'america/yakutat',
  'america/yellowknife'                => 'america/yellowknife',
  'antarctica/casey'                   => 'antarctica/casey',
  'antarctica/davis'                   => 'antarctica/davis',
  'antarctica/dumontdurville'          => 'antarctica/dumontdurville',
  'antarctica/macquarie'               => 'antarctica/macquarie',
  'antarctica/mawson'                  => 'antarctica/mawson',
  'antarctica/mcmurdo'                 => 'antarctica/mcmurdo',
  'antarctica/palmer'                  => 'antarctica/palmer',
  'antarctica/rothera'                 => 'antarctica/rothera',
  'antarctica/syowa'                   => 'antarctica/syowa',
  'antarctica/vostok'                  => 'antarctica/vostok',
  'asia/aden'                          => 'asia/aden',
  'asia/almaty'                        => 'asia/almaty',
  'asia/amman'                         => 'asia/amman',
  'asia/anadyr'                        => 'asia/anadyr',
  'asia/aqtau'                         => 'asia/aqtau',
  'asia/aqtobe'                        => 'asia/aqtobe',
  'asia/ashgabat'                      => 'asia/ashgabat',
  'asia/baghdad'                       => 'asia/baghdad',
  'asia/bahrain'                       => 'asia/bahrain',
  'asia/baku'                          => 'asia/baku',
  'asia/bangkok'                       => 'asia/bangkok',
  'asia/beirut'                        => 'asia/beirut',
  'asia/bishkek'                       => 'asia/bishkek',
  'asia/brunei'                        => 'asia/brunei',
  'asia/choibalsan'                    => 'asia/choibalsan',
  'asia/chongqing'                     => 'asia/chongqing',
  'asia/colombo'                       => 'asia/colombo',
  'asia/damascus'                      => 'asia/damascus',
  'asia/dhaka'                         => 'asia/dhaka',
  'asia/dili'                          => 'asia/dili',
  'asia/dubai'                         => 'asia/dubai',
  'asia/dushanbe'                      => 'asia/dushanbe',
  'asia/gaza'                          => 'asia/gaza',
  'asia/harbin'                        => 'asia/harbin',
  'asia/hebron'                        => 'asia/hebron',
  'asia/ho_chi_minh'                   => 'asia/ho_chi_minh',
  'asia/hong_kong'                     => 'asia/hong_kong',
  'asia/hovd'                          => 'asia/hovd',
  'asia/irkutsk'                       => 'asia/irkutsk',
  'asia/jakarta'                       => 'asia/jakarta',
  'asia/jayapura'                      => 'asia/jayapura',
  'asia/jerusalem'                     => 'asia/jerusalem',
  'asia/kabul'                         => 'asia/kabul',
  'asia/kamchatka'                     => 'asia/kamchatka',
  'asia/karachi'                       => 'asia/karachi',
  'asia/kashgar'                       => 'asia/kashgar',
  'asia/kathmandu'                     => 'asia/kathmandu',
  'asia/khandyga'                      => 'asia/khandyga',
  'asia/kolkata'                       => 'asia/kolkata',
  'asia/krasnoyarsk'                   => 'asia/krasnoyarsk',
  'asia/kuala_lumpur'                  => 'asia/kuala_lumpur',
  'asia/kuching'                       => 'asia/kuching',
  'asia/kuwait'                        => 'asia/kuwait',
  'asia/macau'                         => 'asia/macau',
  'asia/magadan'                       => 'asia/magadan',
  'asia/makassar'                      => 'asia/makassar',
  'asia/manila'                        => 'asia/manila',
  'asia/muscat'                        => 'asia/muscat',
  'asia/nicosia'                       => 'asia/nicosia',
  'asia/novokuznetsk'                  => 'asia/novokuznetsk',
  'asia/novosibirsk'                   => 'asia/novosibirsk',
  'asia/omsk'                          => 'asia/omsk',
  'asia/oral'                          => 'asia/oral',
  'asia/phnom_penh'                    => 'asia/phnom_penh',
  'asia/pontianak'                     => 'asia/pontianak',
  'asia/pyongyang'                     => 'asia/pyongyang',
  'asia/qatar'                         => 'asia/qatar',
  'asia/qyzylorda'                     => 'asia/qyzylorda',
  'asia/rangoon'                       => 'asia/rangoon',
  'asia/riyadh'                        => 'asia/riyadh',
  'asia/sakhalin'                      => 'asia/sakhalin',
  'asia/samarkand'                     => 'asia/samarkand',
  'asia/seoul'                         => 'asia/seoul',
  'asia/shanghai'                      => 'asia/shanghai',
  'asia/singapore'                     => 'asia/singapore',
  'asia/taipei'                        => 'asia/taipei',
  'asia/tashkent'                      => 'asia/tashkent',
  'asia/tbilisi'                       => 'asia/tbilisi',
  'asia/tehran'                        => 'asia/tehran',
  'asia/thimphu'                       => 'asia/thimphu',
  'asia/tokyo'                         => 'asia/tokyo',
  'asia/ulaanbaatar'                   => 'asia/ulaanbaatar',
  'asia/urumqi'                        => 'asia/urumqi',
  'asia/ust-nera'                      => 'asia/ust-nera',
  'asia/vientiane'                     => 'asia/vientiane',
  'asia/vladivostok'                   => 'asia/vladivostok',
  'asia/yakutsk'                       => 'asia/yakutsk',
  'asia/yekaterinburg'                 => 'asia/yekaterinburg',
  'asia/yerevan'                       => 'asia/yerevan',
  'atlantic/azores'                    => 'atlantic/azores',
  'atlantic/bermuda'                   => 'atlantic/bermuda',
  'atlantic/canary'                    => 'atlantic/canary',
  'atlantic/cape_verde'                => 'atlantic/cape_verde',
  'atlantic/faroe'                     => 'atlantic/faroe',
  'atlantic/madeira'                   => 'atlantic/madeira',
  'atlantic/reykjavik'                 => 'atlantic/reykjavik',
  'atlantic/south_georgia'             => 'atlantic/south_georgia',
  'atlantic/st_helena'                 => 'atlantic/st_helena',
  'atlantic/stanley'                   => 'atlantic/stanley',
  'australia/adelaide'                 => 'australia/adelaide',
  'australia/brisbane'                 => 'australia/brisbane',
  'australia/broken_hill'              => 'australia/broken_hill',
  'australia/currie'                   => 'australia/currie',
  'australia/darwin'                   => 'australia/darwin',
  'australia/eucla'                    => 'australia/eucla',
  'australia/hobart'                   => 'australia/hobart',
  'australia/lindeman'                 => 'australia/lindeman',
  'australia/lord_howe'                => 'australia/lord_howe',
  'australia/melbourne'                => 'australia/melbourne',
  'australia/perth'                    => 'australia/perth',
  'australia/sydney'                   => 'australia/sydney',
  'b'                                  => 'b',
  'c'                                  => 'c',
  'cet'                                => 'cet',
  'd'                                  => 'd',
  'e'                                  => 'e',
  'eet'                                => 'eet',
  'etc/gmt'                            => 'etc/gmt',
  'etc/gmt+1'                          => 'etc/gmt+1',
  'etc/gmt+10'                         => 'etc/gmt+10',
  'etc/gmt+11'                         => 'etc/gmt+11',
  'etc/gmt+12'                         => 'etc/gmt+12',
  'etc/gmt+2'                          => 'etc/gmt+2',
  'etc/gmt+3'                          => 'etc/gmt+3',
  'etc/gmt+4'                          => 'etc/gmt+4',
  'etc/gmt+5'                          => 'etc/gmt+5',
  'etc/gmt+6'                          => 'etc/gmt+6',
  'etc/gmt+7'                          => 'etc/gmt+7',
  'etc/gmt+8'                          => 'etc/gmt+8',
  'etc/gmt+9'                          => 'etc/gmt+9',
  'etc/gmt-1'                          => 'etc/gmt-1',
  'etc/gmt-10'                         => 'etc/gmt-10',
  'etc/gmt-11'                         => 'etc/gmt-11',
  'etc/gmt-12'                         => 'etc/gmt-12',
  'etc/gmt-13'                         => 'etc/gmt-13',
  'etc/gmt-14'                         => 'etc/gmt-14',
  'etc/gmt-2'                          => 'etc/gmt-2',
  'etc/gmt-3'                          => 'etc/gmt-3',
  'etc/gmt-4'                          => 'etc/gmt-4',
  'etc/gmt-5'                          => 'etc/gmt-5',
  'etc/gmt-6'                          => 'etc/gmt-6',
  'etc/gmt-7'                          => 'etc/gmt-7',
  'etc/gmt-8'                          => 'etc/gmt-8',
  'etc/gmt-9'                          => 'etc/gmt-9',
  'europe/amsterdam'                   => 'europe/amsterdam',
  'europe/andorra'                     => 'europe/andorra',
  'europe/athens'                      => 'europe/athens',
  'europe/belgrade'                    => 'europe/belgrade',
  'europe/berlin'                      => 'europe/berlin',
  'europe/brussels'                    => 'europe/brussels',
  'europe/bucharest'                   => 'europe/bucharest',
  'europe/budapest'                    => 'europe/budapest',
  'europe/chisinau'                    => 'europe/chisinau',
  'europe/copenhagen'                  => 'europe/copenhagen',
  'europe/dublin'                      => 'europe/dublin',
  'europe/gibraltar'                   => 'europe/gibraltar',
  'europe/helsinki'                    => 'europe/helsinki',
  'europe/istanbul'                    => 'europe/istanbul',
  'europe/kaliningrad'                 => 'europe/kaliningrad',
  'europe/kiev'                        => 'europe/kiev',
  'europe/lisbon'                      => 'europe/lisbon',
  'europe/london'                      => 'europe/london',
  'europe/luxembourg'                  => 'europe/luxembourg',
  'europe/madrid'                      => 'europe/madrid',
  'europe/malta'                       => 'europe/malta',
  'europe/minsk'                       => 'europe/minsk',
  'europe/monaco'                      => 'europe/monaco',
  'europe/moscow'                      => 'europe/moscow',
  'europe/oslo'                        => 'europe/oslo',
  'europe/paris'                       => 'europe/paris',
  'europe/prague'                      => 'europe/prague',
  'europe/riga'                        => 'europe/riga',
  'europe/rome'                        => 'europe/rome',
  'europe/samara'                      => 'europe/samara',
  'europe/simferopol'                  => 'europe/simferopol',
  'europe/sofia'                       => 'europe/sofia',
  'europe/stockholm'                   => 'europe/stockholm',
  'europe/tallinn'                     => 'europe/tallinn',
  'europe/tirane'                      => 'europe/tirane',
  'europe/uzhgorod'                    => 'europe/uzhgorod',
  'europe/vaduz'                       => 'europe/vaduz',
  'europe/vienna'                      => 'europe/vienna',
  'europe/vilnius'                     => 'europe/vilnius',
  'europe/volgograd'                   => 'europe/volgograd',
  'europe/warsaw'                      => 'europe/warsaw',
  'europe/zaporozhye'                  => 'europe/zaporozhye',
  'europe/zurich'                      => 'europe/zurich',
  'f'                                  => 'f',
  'g'                                  => 'g',
  'h'                                  => 'h',
  'i'                                  => 'i',
  'indian/antananarivo'                => 'indian/antananarivo',
  'indian/chagos'                      => 'indian/chagos',
  'indian/christmas'                   => 'indian/christmas',
  'indian/cocos'                       => 'indian/cocos',
  'indian/comoro'                      => 'indian/comoro',
  'indian/kerguelen'                   => 'indian/kerguelen',
  'indian/mahe'                        => 'indian/mahe',
  'indian/maldives'                    => 'indian/maldives',
  'indian/mauritius'                   => 'indian/mauritius',
  'indian/mayotte'                     => 'indian/mayotte',
  'indian/reunion'                     => 'indian/reunion',
  'k'                                  => 'k',
  'l'                                  => 'l',
  'm'                                  => 'm',
  'met'                                => 'met',
  'n'                                  => 'n',
  'o'                                  => 'o',
  'p'                                  => 'p',
  'pacific/apia'                       => 'pacific/apia',
  'pacific/auckland'                   => 'pacific/auckland',
  'pacific/chatham'                    => 'pacific/chatham',
  'pacific/chuuk'                      => 'pacific/chuuk',
  'pacific/easter'                     => 'pacific/easter',
  'pacific/efate'                      => 'pacific/efate',
  'pacific/enderbury'                  => 'pacific/enderbury',
  'pacific/fakaofo'                    => 'pacific/fakaofo',
  'pacific/fiji'                       => 'pacific/fiji',
  'pacific/funafuti'                   => 'pacific/funafuti',
  'pacific/galapagos'                  => 'pacific/galapagos',
  'pacific/gambier'                    => 'pacific/gambier',
  'pacific/guadalcanal'                => 'pacific/guadalcanal',
  'pacific/guam'                       => 'pacific/guam',
  'pacific/honolulu'                   => 'pacific/honolulu',
  'pacific/kiritimati'                 => 'pacific/kiritimati',
  'pacific/kosrae'                     => 'pacific/kosrae',
  'pacific/kwajalein'                  => 'pacific/kwajalein',
  'pacific/majuro'                     => 'pacific/majuro',
  'pacific/marquesas'                  => 'pacific/marquesas',
  'pacific/midway'                     => 'pacific/midway',
  'pacific/nauru'                      => 'pacific/nauru',
  'pacific/niue'                       => 'pacific/niue',
  'pacific/norfolk'                    => 'pacific/norfolk',
  'pacific/noumea'                     => 'pacific/noumea',
  'pacific/pago_pago'                  => 'pacific/pago_pago',
  'pacific/palau'                      => 'pacific/palau',
  'pacific/pitcairn'                   => 'pacific/pitcairn',
  'pacific/pohnpei'                    => 'pacific/pohnpei',
  'pacific/port_moresby'               => 'pacific/port_moresby',
  'pacific/rarotonga'                  => 'pacific/rarotonga',
  'pacific/saipan'                     => 'pacific/saipan',
  'pacific/tahiti'                     => 'pacific/tahiti',
  'pacific/tarawa'                     => 'pacific/tarawa',
  'pacific/tongatapu'                  => 'pacific/tongatapu',
  'pacific/wake'                       => 'pacific/wake',
  'pacific/wallis'                     => 'pacific/wallis',
  'q'                                  => 'q',
  'r'                                  => 'r',
  's'                                  => 's',
  't'                                  => 't',
  'u'                                  => 'u',
  'ut'                                 => 'ut',
  'utc'                                => 'utc',
  'v'                                  => 'v',
  'w'                                  => 'w',
  'wet'                                => 'wet',
  'x'                                  => 'x',
  'y'                                  => 'y',
  'z'                                  => 'z',
  'africa/asmera'                      => 'africa/asmara',
  'africa/timbuktu'                    => 'africa/bamako',
  'america/argentina/comodrivadavia'   => 'america/argentina/catamarca',
  'america/atka'                       => 'america/adak',
  'america/buenos_aires'               => 'america/argentina/buenos_aires',
  'america/catamarca'                  => 'america/argentina/catamarca',
  'america/coral_harbour'              => 'america/atikokan',
  'america/cordoba'                    => 'america/argentina/cordoba',
  'america/ensenada'                   => 'america/tijuana',
  'america/fort_wayne'                 => 'america/indiana/indianapolis',
  'america/indianapolis'               => 'america/indiana/indianapolis',
  'america/jujuy'                      => 'america/argentina/jujuy',
  'america/knox_in'                    => 'america/indiana/knox',
  'america/kralendijk'                 => 'america/curacao',
  'america/louisville'                 => 'america/kentucky/louisville',
  'america/lower_princes'              => 'america/curacao',
  'america/marigot'                    => 'america/guadeloupe',
  'america/mendoza'                    => 'america/argentina/mendoza',
  'america/porto_acre'                 => 'america/rio_branco',
  'america/rosario'                    => 'america/argentina/cordoba',
  'america/shiprock'                   => 'america/denver',
  'america/st_barthelemy'              => 'america/guadeloupe',
  'america/virgin'                     => 'america/st_thomas',
  'antarctica/south_pole'              => 'antarctica/mcmurdo',
  'arctic/longyearbyen'                => 'europe/oslo',
  'asia/ashkhabad'                     => 'asia/ashgabat',
  'asia/calcutta'                      => 'asia/kolkata',
  'asia/chungking'                     => 'asia/chongqing',
  'asia/dacca'                         => 'asia/dhaka',
  'asia/istanbul'                      => 'europe/istanbul',
  'asia/katmandu'                      => 'asia/kathmandu',
  'asia/macao'                         => 'asia/macau',
  'asia/saigon'                        => 'asia/ho_chi_minh',
  'asia/tel_aviv'                      => 'asia/jerusalem',
  'asia/thimbu'                        => 'asia/thimphu',
  'asia/ujung_pandang'                 => 'asia/makassar',
  'asia/ulan_bator'                    => 'asia/ulaanbaatar',
  'atlantic/faeroe'                    => 'atlantic/faroe',
  'atlantic/jan_mayen'                 => 'europe/oslo',
  'australia/act'                      => 'australia/sydney',
  'australia/canberra'                 => 'australia/sydney',
  'australia/lhi'                      => 'australia/lord_howe',
  'australia/nsw'                      => 'australia/sydney',
  'australia/north'                    => 'australia/darwin',
  'australia/queensland'               => 'australia/brisbane',
  'australia/south'                    => 'australia/adelaide',
  'australia/tasmania'                 => 'australia/hobart',
  'australia/victoria'                 => 'australia/melbourne',
  'australia/west'                     => 'australia/perth',
  'australia/yancowinna'               => 'australia/broken_hill',
  'brazil/acre'                        => 'america/rio_branco',
  'brazil/denoronha'                   => 'america/noronha',
  'brazil/east'                        => 'america/sao_paulo',
  'brazil/west'                        => 'america/manaus',
  'canada/atlantic'                    => 'america/halifax',
  'canada/central'                     => 'america/winnipeg',
  'canada/east-saskatchewan'           => 'america/regina',
  'canada/eastern'                     => 'america/toronto',
  'canada/mountain'                    => 'america/edmonton',
  'canada/newfoundland'                => 'america/st_johns',
  'canada/pacific'                     => 'america/vancouver',
  'canada/saskatchewan'                => 'america/regina',
  'canada/yukon'                       => 'america/whitehorse',
  'chile/continental'                  => 'america/santiago',
  'chile/easterisland'                 => 'pacific/easter',
  'cuba'                               => 'america/havana',
  'egypt'                              => 'africa/cairo',
  'eire'                               => 'europe/dublin',
  'europe/belfast'                     => 'europe/london',
  'europe/bratislava'                  => 'europe/prague',
  'europe/busingen'                    => 'europe/zurich',
  'europe/guernsey'                    => 'europe/london',
  'europe/isle_of_man'                 => 'europe/london',
  'europe/jersey'                      => 'europe/london',
  'europe/ljubljana'                   => 'europe/belgrade',
  'europe/mariehamn'                   => 'europe/helsinki',
  'europe/nicosia'                     => 'asia/nicosia',
  'europe/podgorica'                   => 'europe/belgrade',
  'europe/san_marino'                  => 'europe/rome',
  'europe/sarajevo'                    => 'europe/belgrade',
  'europe/skopje'                      => 'europe/belgrade',
  'europe/tiraspol'                    => 'europe/chisinau',
  'europe/vatican'                     => 'europe/rome',
  'europe/zagreb'                      => 'europe/belgrade',
  'gb'                                 => 'europe/london',
  'gb-eire'                            => 'europe/london',
  'hongkong'                           => 'asia/hong_kong',
  'iceland'                            => 'atlantic/reykjavik',
  'iran'                               => 'asia/tehran',
  'israel'                             => 'asia/jerusalem',
  'jamaica'                            => 'america/jamaica',
  'japan'                              => 'asia/tokyo',
  'kwajalein'                          => 'pacific/kwajalein',
  'libya'                              => 'africa/tripoli',
  'mexico/bajanorte'                   => 'america/tijuana',
  'mexico/bajasur'                     => 'america/mazatlan',
  'mexico/general'                     => 'america/mexico_city',
  'nz'                                 => 'pacific/auckland',
  'nz-chat'                            => 'pacific/chatham',
  'navajo'                             => 'america/denver',
  'prc'                                => 'asia/shanghai',
  'pacific/ponape'                     => 'pacific/pohnpei',
  'pacific/samoa'                      => 'pacific/pago_pago',
  'pacific/truk'                       => 'pacific/chuuk',
  'pacific/yap'                        => 'pacific/chuuk',
  'poland'                             => 'europe/warsaw',
  'portugal'                           => 'europe/lisbon',
  'roc'                                => 'asia/taipei',
  'rok'                                => 'asia/seoul',
  'singapore'                          => 'asia/singapore',
  'turkey'                             => 'europe/istanbul',
  'us/alaska'                          => 'america/anchorage',
  'us/aleutian'                        => 'america/adak',
  'us/arizona'                         => 'america/phoenix',
  'us/central'                         => 'america/chicago',
  'us/east-indiana'                    => 'america/indiana/indianapolis',
  'us/eastern'                         => 'america/new_york',
  'us/hawaii'                          => 'pacific/honolulu',
  'us/indiana-starke'                  => 'america/indiana/knox',
  'us/michigan'                        => 'america/detroit',
  'us/mountain'                        => 'america/denver',
  'us/pacific'                         => 'america/los_angeles',
  'us/pacific-new'                     => 'america/los_angeles',
  'us/samoa'                           => 'pacific/pago_pago',
  'w-su'                               => 'europe/moscow',
  'act5acst'                           => 'america/rio_branco',
  'ahst10ahdt'                         => 'america/anchorage',
  'akst9akdt'                          => 'america/juneau',
  'aktt-5aktst'                        => 'asia/aqtobe',
  'almt-6almst'                        => 'asia/almaty',
  'amt-3amst'                          => 'asia/yerevan',
  'amt-4amst'                          => 'asia/yerevan',
  'amt4amst'                           => 'america/campo_grande',
  'anat-11anast'                       => 'asia/anadyr',
  'anat-12anast'                       => 'asia/anadyr',
  'anat-13anast'                       => 'asia/anadyr',
  'aqtt-4aqtst'                        => 'asia/aqtau',
  'aqtt-5aqtst'                        => 'asia/aqtobe',
  'art3arst'                           => 'america/argentina/buenos_aires',
  'art4arst'                           => 'america/argentina/buenos_aires',
  'asht-5ashst'                        => 'asia/ashgabat',
  'ast-3adt'                           => 'asia/baghdad',
  'ast4adt'                            => 'america/halifax',
  'ast4apt'                            => 'america/blanc-sablon',
  'azot1azost'                         => 'atlantic/azores',
  'azot2azost'                         => 'atlantic/azores',
  'azt-4azst'                          => 'asia/baku',
  'bakt-4bakst'                        => 'asia/baku',
  'bdt-6bdst'                          => 'asia/dhaka',
  'brt3brst'                           => 'america/sao_paulo',
  'bst11bdt'                           => 'america/adak',
  'cat-2cast'                          => 'africa/khartoum',
  'cat10capt'                          => 'america/anchorage',
  'cet-1cest'                          => 'cet',
  'cet-1wemt'                          => 'europe/madrid',
  'cet-1west'                          => 'europe/luxembourg',
  'cgt2cgst'                           => 'america/scoresbysund',
  'chot-9chost'                        => 'asia/choibalsan',
  'clt4clst'                           => 'america/santiago',
  'clt5clst'                           => 'america/santiago',
  'cst-8cdt'                           => 'asia/shanghai',
  'cst5cdt'                            => 'america/havana',
  'cst6cdt'                            => 'america/chicago',
  'cst6cpt'                            => 'america/chicago',
  'dust-6dusst'                        => 'asia/dushanbe',
  'east6easst'                         => 'pacific/easter',
  'east7easst'                         => 'pacific/easter',
  'eat-3east'                          => 'indian/antananarivo',
  'eet-2eest'                          => 'eet',
  'eet-2eet'                           => 'asia/gaza',
  'egt1egst'                           => 'america/scoresbysund',
  'est-10est'                          => 'australia/melbourne',
  'est5edt'                            => 'america/new_york',
  'est5ept'                            => 'america/new_york',
  'fjt-12fjst'                         => 'pacific/fiji',
  'fkt3fkst'                           => 'atlantic/stanley',
  'fkt4fkst'                           => 'atlantic/stanley',
  'fnt2fnst'                           => 'america/noronha',
  'frut-6frust'                        => 'asia/bishkek',
  'get-3gest'                          => 'asia/tbilisi',
  'get-4gest'                          => 'asia/tbilisi',
  'gmt0bst'                            => 'europe/london',
  'gmt0ist'                            => 'europe/dublin',
  'gmt0slst'                           => 'africa/freetown',
  'hast10hadt'                         => 'america/adak',
  'hkt-8hkst'                          => 'asia/hong_kong',
  'hovt-7hovst'                        => 'asia/hovd',
  'irkt-7irkst'                        => 'asia/irkutsk',
  'irkt-8irkst'                        => 'asia/irkutsk',
  'ist-2eest'                          => 'asia/gaza',
  'ist-2idt'                           => 'asia/jerusalem',
  'ist1isst'                           => 'atlantic/reykjavik',
  'jst-9jdt'                           => 'asia/tokyo',
  'kgt-5frust'                         => 'asia/bishkek',
  'kgt-5kgst'                          => 'asia/bishkek',
  'kizt-5kizst'                        => 'asia/qyzylorda',
  'krat-6krast'                        => 'asia/krasnoyarsk',
  'krat-7krast'                        => 'asia/krasnoyarsk',
  'kst-8kdt'                           => 'asia/seoul',
  'kst-9kdt'                           => 'asia/seoul',
  'kuyt-3kuyst'                        => 'europe/samara',
  'kuyt-4kuyst'                        => 'europe/samara',
  'madt1madst'                         => 'atlantic/madeira',
  'magt-10magst'                       => 'asia/magadan',
  'magt-11magst'                       => 'asia/magadan',
  'met-1mest'                          => 'met',
  'mot-8most'                          => 'asia/macau',
  'msk-3cest'                          => 'europe/minsk',
  'msk-3msd'                           => 'europe/moscow',
  'mst7mdt'                            => 'america/denver',
  'mst7mpt'                            => 'america/denver',
  'mest8pdt'                           => 'america/metlakatla',
  'nct-11ncst'                         => 'pacific/noumea',
  'novt-6novst'                        => 'asia/novosibirsk',
  'novt-7novst'                        => 'asia/novosibirsk',
  'nst11ndt'                           => 'pacific/midway',
  'nst11npt'                           => 'america/adak',
  'nzst-12nzdt'                        => 'pacific/auckland',
  'omst-5omsst'                        => 'asia/omsk',
  'omst-6omsst'                        => 'asia/omsk',
  'orat-4orast'                        => 'asia/oral',
  'pet5pest'                           => 'america/lima',
  'pett-11petst'                       => 'asia/kamchatka',
  'pett-12petst'                       => 'asia/kamchatka',
  'pht-8phst'                          => 'asia/manila',
  'pkt-5pkst'                          => 'asia/karachi',
  'pmst3pmdt'                          => 'america/miquelon',
  'pst8pdt'                            => 'america/los_angeles',
  'pst8ppt'                            => 'america/los_angeles',
  'pyt4pyst'                           => 'america/asuncion',
  'qyzt-6qyzst'                        => 'asia/qyzylorda',
  'sakt-10sakst'                       => 'asia/sakhalin',
  'sakt-11sakst'                       => 'asia/sakhalin',
  'samt-3samst'                        => 'europe/samara',
  'samt-4samst'                        => 'europe/samara',
  'samt-5samst'                        => 'asia/samarkand',
  'sast-2sast'                         => 'africa/johannesburg',
  'shet-5shest'                        => 'asia/aqtau',
  'svet-4svest'                        => 'asia/yekaterinburg',
  'svet-5svest'                        => 'asia/yekaterinburg',
  'tast-6tasst'                        => 'asia/tashkent',
  'tbit-4tbist'                        => 'asia/tbilisi',
  'tjt-5dusst'                         => 'asia/dushanbe',
  'tot-13tost'                         => 'pacific/tongatapu',
  'trt-3trst'                          => 'europe/istanbul',
  'ulat-8ulast'                        => 'asia/ulaanbaatar',
  'urat-4urast'                        => 'asia/oral',
  'urat-5urast'                        => 'asia/oral',
  'uyt3uyst'                           => 'america/montevideo',
  'vlast-9vlasst'                      => 'asia/vladivostok',
  'vlat-10vlast'                       => 'asia/vladivostok',
  'volt-3volst'                        => 'europe/volgograd',
  'volt-4volst'                        => 'europe/volgograd',
  'vut-11vust'                         => 'pacific/efate',
  'wart4warst'                         => 'america/argentina/san_luis',
  'wat-1wast'                          => 'africa/windhoek',
  'wet-1west'                          => 'europe/luxembourg',
  'wet0west'                           => 'wet',
  'wgt3wgst'                           => 'america/godthab',
  'wst-13wsdt'                         => 'pacific/apia',
  'wst-8wst'                           => 'australia/perth',
  'yakt-8yakst'                        => 'asia/yakutsk',
  'yakt-9yakst'                        => 'asia/yakutsk',
  'yekt-5yekst'                        => 'asia/yekaterinburg',
  'yert-4yerst'                        => 'asia/yerevan',
  'yst9ydt'                            => 'america/yakutat',
  'yst9ypt'                            => 'america/yakutat',
  'aus central standard time'          => 'australia/darwin',
  'aus eastern standard time'          => 'australia/sydney',
  'afghanistan standard time'          => 'asia/kabul',
  'alaskan standard time'              => 'america/anchorage',
  'arab standard time'                 => 'asia/riyadh',
  'arabian standard time'              => 'asia/dubai',
  'arabic standard time'               => 'asia/baghdad',
  'argentina standard time'            => 'america/argentina/buenos_aires',
  'atlantic standard time'             => 'america/halifax',
  'azerbaijan standard time'           => 'asia/baku',
  'azores standard time'               => 'atlantic/azores',
  'bahia standard time'                => 'america/bahia',
  'bangladesh standard time'           => 'asia/dhaka',
  'canada central standard time'       => 'america/regina',
  'cape verde standard time'           => 'atlantic/cape_verde',
  'caucasus standard time'             => 'asia/yerevan',
  'cen. australia standard time'       => 'australia/adelaide',
  'central america standard time'      => 'america/guatemala',
  'central asia standard time'         => 'asia/almaty',
  'central brazilian standard time'    => 'america/cuiaba',
  'central europe standard time'       => 'europe/budapest',
  'central european standard time'     => 'europe/warsaw',
  'central pacific standard time'      => 'pacific/guadalcanal',
  'central standard time'              => 'america/chicago',
  'central standard time (mexico)'     => 'america/mexico_city',
  'china standard time'                => 'asia/shanghai',
  'dateline standard time'             => 'etc/gmt+12',
  'e. africa standard time'            => 'africa/nairobi',
  'e. australia standard time'         => 'australia/brisbane',
  'e. europe standard time'            => 'asia/nicosia',
  'e. south america standard time'     => 'america/sao_paulo',
  'eastern standard time'              => 'america/new_york',
  'egypt standard time'                => 'africa/cairo',
  'ekaterinburg standard time'         => 'asia/yekaterinburg',
  'etc/uct'                            => 'utc',
  'etc/utc'                            => 'utc',
  'fle standard time'                  => 'europe/kiev',
  'fiji standard time'                 => 'pacific/fiji',
  'gmt'                                => 'etc/gmt',
  'gmt standard time'                  => 'europe/london',
  'gtb standard time'                  => 'europe/istanbul',
  'georgian standard time'             => 'asia/tbilisi',
  'greenland standard time'            => 'america/godthab',
  'greenwich standard time'            => 'atlantic/reykjavik',
  'hawaiian standard time'             => 'pacific/honolulu',
  'india standard time'                => 'asia/kolkata',
  'iran standard time'                 => 'asia/tehran',
  'israel standard time'               => 'asia/jerusalem',
  'jordan standard time'               => 'asia/amman',
  'kaliningrad standard time'          => 'europe/kaliningrad',
  'korea standard time'                => 'asia/seoul',
  'magadan standard time'              => 'asia/magadan',
  'mauritius standard time'            => 'indian/mauritius',
  'middle east standard time'          => 'asia/beirut',
  'montevideo standard time'           => 'america/montevideo',
  'morocco standard time'              => 'africa/casablanca',
  'mountain standard time'             => 'america/denver',
  'mountain standard time (mexico)'    => 'america/chihuahua',
  'myanmar standard time'              => 'asia/rangoon',
  'n. central asia standard time'      => 'asia/novosibirsk',
  'namibia standard time'              => 'africa/windhoek',
  'nepal standard time'                => 'asia/kathmandu',
  'new zealand standard time'          => 'pacific/auckland',
  'newfoundland standard time'         => 'america/st_johns',
  'north asia east standard time'      => 'asia/irkutsk',
  'north asia standard time'           => 'asia/krasnoyarsk',
  'pacific sa standard time'           => 'america/santiago',
  'pacific standard time'              => 'america/los_angeles',
  'pacific standard time (mexico)'     => 'america/santa_isabel',
  'pacific/johnston'                   => 'pacific/honolulu',
  'pakistan standard time'             => 'asia/karachi',
  'paraguay standard time'             => 'america/asuncion',
  'romance standard time'              => 'europe/paris',
  'russian standard time'              => 'europe/moscow',
  'sa eastern standard time'           => 'america/cayenne',
  'sa pacific standard time'           => 'america/bogota',
  'sa western standard time'           => 'america/la_paz',
  'se asia standard time'              => 'asia/bangkok',
  'samoa standard time'                => 'pacific/apia',
  'singapore standard time'            => 'asia/singapore',
  'south africa standard time'         => 'africa/johannesburg',
  'sri lanka standard time'            => 'asia/colombo',
  'syria standard time'                => 'asia/damascus',
  'taipei standard time'               => 'asia/taipei',
  'tasmania standard time'             => 'australia/hobart',
  'tokyo standard time'                => 'asia/tokyo',
  'tonga standard time'                => 'pacific/tongatapu',
  'turkey standard time'               => 'europe/istanbul',
  'uct'                                => 'utc',
  'us eastern standard time'           => 'america/indiana/indianapolis',
  'us mountain standard time'          => 'america/phoenix',
  'utc+12'                             => 'etc/gmt-12',
  'utc-02'                             => 'etc/gmt+2',
  'utc-11'                             => 'etc/gmt+11',
  'ulaanbaatar standard time'          => 'asia/ulaanbaatar',
  'venezuela standard time'            => 'america/caracas',
  'vladivostok standard time'          => 'asia/vladivostok',
  'w. australia standard time'         => 'australia/perth',
  'w. central africa standard time'    => 'africa/lagos',
  'w. europe standard time'            => 'europe/berlin',
  'west asia standard time'            => 'asia/tashkent',
  'west pacific standard time'         => 'pacific/port_moresby',
  'yakutsk standard time'              => 'asia/yakutsk',
);

%Abbrev = (
  'a'           => [ 'a' ],
  'acst'        => [ 'america/eirunepe',
                     'america/rio_branco' ],
  'act'         => [ 'america/eirunepe',
                     'america/rio_branco' ],
  'addt'        => [ 'america/goose_bay',
                     'america/pangnirtung' ],
  'admt'        => [ 'africa/addis_ababa',
                     'africa/asmara' ],
  'adt'         => [ 'america/halifax',
                     'america/glace_bay',
                     'america/moncton',
                     'america/goose_bay',
                     'atlantic/bermuda',
                     'america/thule',
                     'asia/baghdad',
                     'america/pangnirtung',
                     'america/barbados',
                     'america/martinique',
                     'america/blanc-sablon' ],
  'aft'         => [ 'asia/kabul' ],
  'ahdt'        => [ 'america/anchorage' ],
  'ahst'        => [ 'america/anchorage',
                     'america/adak' ],
  'akdt'        => [ 'america/juneau',
                     'america/nome',
                     'america/yakutat',
                     'america/sitka',
                     'america/anchorage' ],
  'akst'        => [ 'america/anchorage',
                     'america/juneau',
                     'america/nome',
                     'america/yakutat',
                     'america/sitka' ],
  'aktst'       => [ 'asia/aqtobe' ],
  'aktt'        => [ 'asia/aqtobe' ],
  'almst'       => [ 'asia/almaty' ],
  'almt'        => [ 'asia/almaty' ],
  'amst'        => [ 'america/campo_grande',
                     'america/cuiaba',
                     'asia/yerevan',
                     'america/boa_vista',
                     'america/manaus',
                     'america/porto_velho',
                     'america/santarem' ],
  'amt'         => [ 'america/boa_vista',
                     'america/campo_grande',
                     'america/cuiaba',
                     'america/manaus',
                     'america/porto_velho',
                     'asia/yerevan',
                     'america/eirunepe',
                     'america/rio_branco',
                     'america/santarem',
                     'europe/amsterdam',
                     'america/asuncion',
                     'europe/athens',
                     'africa/asmara' ],
  'anast'       => [ 'asia/anadyr' ],
  'anat'        => [ 'asia/anadyr' ],
  'ant'         => [ 'america/aruba',
                     'america/curacao' ],
  'aot'         => [ 'africa/luanda' ],
  'apt'         => [ 'america/halifax',
                     'america/blanc-sablon',
                     'america/glace_bay',
                     'america/moncton',
                     'america/pangnirtung',
                     'america/puerto_rico' ],
  'aqtst'       => [ 'asia/aqtau',
                     'asia/aqtobe' ],
  'aqtt'        => [ 'asia/aqtau',
                     'asia/aqtobe' ],
  'arst'        => [ 'america/argentina/buenos_aires',
                     'america/argentina/cordoba',
                     'america/argentina/tucuman',
                     'america/argentina/catamarca',
                     'america/argentina/jujuy',
                     'america/argentina/la_rioja',
                     'america/argentina/mendoza',
                     'america/argentina/rio_gallegos',
                     'america/argentina/salta',
                     'america/argentina/san_juan',
                     'america/argentina/san_luis',
                     'america/argentina/ushuaia',
                     'antarctica/palmer' ],
  'art'         => [ 'america/argentina/buenos_aires',
                     'america/argentina/catamarca',
                     'america/argentina/cordoba',
                     'america/argentina/jujuy',
                     'america/argentina/la_rioja',
                     'america/argentina/mendoza',
                     'america/argentina/rio_gallegos',
                     'america/argentina/salta',
                     'america/argentina/san_juan',
                     'america/argentina/tucuman',
                     'america/argentina/ushuaia',
                     'america/argentina/san_luis',
                     'antarctica/palmer' ],
  'ashst'       => [ 'asia/ashgabat' ],
  'asht'        => [ 'asia/ashgabat' ],
  'ast'         => [ 'america/blanc-sablon',
                     'america/puerto_rico',
                     'america/glace_bay',
                     'america/halifax',
                     'america/moncton',
                     'america/dominica',
                     'america/grenada',
                     'america/guadeloupe',
                     'america/martinique',
                     'america/montserrat',
                     'america/st_thomas',
                     'america/tortola',
                     'america/anguilla',
                     'america/port_of_spain',
                     'america/st_kitts',
                     'america/st_lucia',
                     'america/st_vincent',
                     'america/thule',
                     'asia/baghdad',
                     'atlantic/bermuda',
                     'america/barbados',
                     'asia/aden',
                     'asia/kuwait',
                     'asia/riyadh',
                     'america/antigua',
                     'america/aruba',
                     'america/curacao',
                     'america/goose_bay',
                     'asia/bahrain',
                     'asia/qatar',
                     'america/santo_domingo',
                     'america/pangnirtung',
                     'america/miquelon' ],
  'awt'         => [ 'america/halifax',
                     'america/blanc-sablon',
                     'america/glace_bay',
                     'america/moncton',
                     'america/pangnirtung',
                     'america/puerto_rico' ],
  'azomt'       => [ 'atlantic/azores' ],
  'azost'       => [ 'atlantic/azores' ],
  'azot'        => [ 'atlantic/azores' ],
  'azst'        => [ 'asia/baku' ],
  'azt'         => [ 'asia/baku' ],
  'b'           => [ 'b' ],
  'bakst'       => [ 'asia/baku' ],
  'bakt'        => [ 'asia/baku' ],
  'bdst'        => [ 'asia/dhaka',
                     'europe/gibraltar',
                     'europe/london' ],
  'bdt'         => [ 'asia/dhaka',
                     'america/adak',
                     'america/nome' ],
  'beat'        => [ 'africa/mogadishu',
                     'africa/kampala',
                     'africa/nairobi' ],
  'beaut'       => [ 'africa/dar_es_salaam',
                     'africa/nairobi',
                     'africa/kampala' ],
  'bmt'         => [ 'africa/banjul',
                     'america/barbados',
                     'europe/bucharest',
                     'europe/chisinau',
                     'asia/bangkok',
                     'asia/baghdad',
                     'america/bogota',
                     'europe/zurich',
                     'europe/brussels' ],
  'bnt'         => [ 'asia/brunei' ],
  'bort'        => [ 'asia/kuching' ],
  'bortst'      => [ 'asia/kuching' ],
  'bost'        => [ 'america/la_paz' ],
  'bot'         => [ 'america/la_paz' ],
  'brst'        => [ 'america/sao_paulo',
                     'america/araguaina',
                     'america/bahia',
                     'america/fortaleza',
                     'america/maceio',
                     'america/recife',
                     'america/belem' ],
  'brt'         => [ 'america/araguaina',
                     'america/bahia',
                     'america/belem',
                     'america/fortaleza',
                     'america/maceio',
                     'america/recife',
                     'america/sao_paulo',
                     'america/santarem' ],
  'bst'         => [ 'europe/london',
                     'america/adak',
                     'america/nome',
                     'pacific/midway',
                     'pacific/pago_pago',
                     'europe/gibraltar',
                     'europe/dublin' ],
  'btt'         => [ 'asia/thimphu' ],
  'burt'        => [ 'asia/dhaka',
                     'asia/kolkata',
                     'asia/rangoon' ],
  'c'           => [ 'c' ],
  'cant'        => [ 'atlantic/canary' ],
  'capt'        => [ 'america/anchorage' ],
  'cast'        => [ 'antarctica/casey',
                     'africa/khartoum',
                     'africa/juba',
                     'africa/gaborone' ],
  'cat'         => [ 'africa/gaborone',
                     'africa/bujumbura',
                     'africa/lubumbashi',
                     'africa/blantyre',
                     'africa/harare',
                     'africa/lusaka',
                     'africa/maputo',
                     'africa/kigali',
                     'africa/khartoum',
                     'africa/juba',
                     'africa/windhoek',
                     'america/anchorage' ],
  'cawt'        => [ 'america/anchorage' ],
  'cct'         => [ 'indian/cocos' ],
  'cddt'        => [ 'america/resolute',
                     'america/rankin_inlet' ],
  'cdt'         => [ 'america/chicago',
                     'america/winnipeg',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/menominee',
                     'america/rainy_river',
                     'america/havana',
                     'america/mexico_city',
                     'america/rankin_inlet',
                     'america/resolute',
                     'america/matamoros',
                     'america/monterrey',
                     'america/north_dakota/center',
                     'america/merida',
                     'america/cancun',
                     'america/north_dakota/new_salem',
                     'america/bahia_banderas',
                     'america/indiana/petersburg',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/guatemala',
                     'america/managua',
                     'america/tegucigalpa',
                     'america/kentucky/monticello',
                     'america/cambridge_bay',
                     'america/iqaluit',
                     'america/pangnirtung',
                     'america/chihuahua',
                     'america/ojinaga',
                     'america/costa_rica',
                     'asia/shanghai',
                     'asia/chongqing',
                     'asia/harbin',
                     'asia/kashgar',
                     'asia/urumqi',
                     'america/el_salvador',
                     'america/belize',
                     'asia/taipei',
                     'america/indiana/marengo',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/atikokan',
                     'america/indiana/vevay',
                     'america/north_dakota/beulah' ],
  'cemt'        => [ 'europe/berlin' ],
  'cest'        => [ 'cet',
                     'europe/berlin',
                     'europe/brussels',
                     'europe/budapest',
                     'europe/copenhagen',
                     'europe/luxembourg',
                     'europe/malta',
                     'europe/oslo',
                     'europe/prague',
                     'europe/rome',
                     'europe/stockholm',
                     'europe/vienna',
                     'europe/warsaw',
                     'europe/amsterdam',
                     'europe/paris',
                     'europe/tirane',
                     'europe/belgrade',
                     'europe/zurich',
                     'europe/madrid',
                     'europe/monaco',
                     'europe/vaduz',
                     'europe/gibraltar',
                     'europe/andorra',
                     'africa/ceuta',
                     'africa/tunis',
                     'europe/vilnius',
                     'africa/tripoli',
                     'europe/lisbon',
                     'africa/algiers',
                     'europe/kaliningrad',
                     'europe/tallinn',
                     'europe/uzhgorod',
                     'europe/chisinau',
                     'europe/minsk',
                     'europe/riga',
                     'europe/simferopol',
                     'europe/sofia',
                     'europe/athens',
                     'europe/kiev',
                     'europe/zaporozhye' ],
  'cet'         => [ 'cet',
                     'europe/belgrade',
                     'europe/budapest',
                     'europe/prague',
                     'europe/berlin',
                     'europe/copenhagen',
                     'europe/malta',
                     'europe/rome',
                     'europe/vienna',
                     'europe/oslo',
                     'europe/vaduz',
                     'europe/zurich',
                     'europe/stockholm',
                     'europe/luxembourg',
                     'africa/tunis',
                     'europe/tirane',
                     'europe/brussels',
                     'europe/warsaw',
                     'africa/algiers',
                     'europe/amsterdam',
                     'europe/paris',
                     'europe/monaco',
                     'europe/andorra',
                     'europe/madrid',
                     'europe/gibraltar',
                     'africa/ceuta',
                     'europe/vilnius',
                     'africa/tripoli',
                     'europe/lisbon',
                     'europe/uzhgorod',
                     'africa/casablanca',
                     'europe/kaliningrad',
                     'europe/sofia',
                     'europe/tallinn',
                     'europe/athens',
                     'europe/chisinau',
                     'europe/minsk',
                     'europe/riga',
                     'europe/simferopol',
                     'europe/kiev',
                     'europe/zaporozhye' ],
  'cgst'        => [ 'america/scoresbysund' ],
  'cgt'         => [ 'america/scoresbysund' ],
  'chadt'       => [ 'pacific/chatham' ],
  'chast'       => [ 'pacific/chatham' ],
  'chat'        => [ 'asia/harbin' ],
  'chdt'        => [ 'america/belize' ],
  'chost'       => [ 'asia/choibalsan' ],
  'chot'        => [ 'asia/choibalsan' ],
  'chut'        => [ 'pacific/chuuk' ],
  'cit'         => [ 'asia/makassar',
                     'asia/dili',
                     'asia/pontianak' ],
  'cjt'         => [ 'asia/tokyo',
                     'asia/sakhalin' ],
  'ckhst'       => [ 'pacific/rarotonga' ],
  'ckt'         => [ 'pacific/rarotonga' ],
  'clst'        => [ 'america/santiago',
                     'antarctica/palmer' ],
  'clt'         => [ 'america/santiago',
                     'antarctica/palmer' ],
  'cmt'         => [ 'america/la_paz',
                     'america/argentina/buenos_aires',
                     'america/argentina/catamarca',
                     'america/argentina/cordoba',
                     'america/argentina/jujuy',
                     'america/argentina/la_rioja',
                     'america/argentina/mendoza',
                     'america/argentina/rio_gallegos',
                     'america/argentina/salta',
                     'america/argentina/san_juan',
                     'america/argentina/san_luis',
                     'america/argentina/tucuman',
                     'america/argentina/ushuaia',
                     'europe/chisinau',
                     'america/caracas',
                     'america/st_lucia',
                     'america/panama',
                     'europe/copenhagen' ],
  'cost'        => [ 'america/bogota' ],
  'cot'         => [ 'america/bogota' ],
  'cpt'         => [ 'america/chicago',
                     'america/atikokan',
                     'america/indiana/indianapolis',
                     'america/indiana/knox',
                     'america/indiana/marengo',
                     'america/indiana/petersburg',
                     'america/indiana/tell_city',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/kentucky/monticello',
                     'america/menominee',
                     'america/rainy_river',
                     'america/winnipeg' ],
  'cst'         => [ 'america/chicago',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/menominee',
                     'america/winnipeg',
                     'america/rainy_river',
                     'asia/taipei',
                     'australia/adelaide',
                     'australia/darwin',
                     'australia/broken_hill',
                     'america/belize',
                     'america/guatemala',
                     'america/costa_rica',
                     'america/el_salvador',
                     'america/tegucigalpa',
                     'america/cancun',
                     'america/matamoros',
                     'america/merida',
                     'america/monterrey',
                     'america/havana',
                     'america/bahia_banderas',
                     'america/mexico_city',
                     'asia/shanghai',
                     'asia/harbin',
                     'america/managua',
                     'america/rankin_inlet',
                     'america/regina',
                     'america/swift_current',
                     'asia/chongqing',
                     'asia/kashgar',
                     'asia/urumqi',
                     'america/north_dakota/center',
                     'asia/macau',
                     'america/north_dakota/new_salem',
                     'america/indiana/petersburg',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/resolute',
                     'america/cambridge_bay',
                     'america/kentucky/monticello',
                     'america/iqaluit',
                     'america/pangnirtung',
                     'america/chihuahua',
                     'america/ojinaga',
                     'asia/jayapura',
                     'america/indiana/marengo',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/indiana/vevay',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/atikokan',
                     'america/detroit',
                     'america/thunder_bay',
                     'america/north_dakota/beulah' ],
  'cut'         => [ 'europe/zaporozhye' ],
  'cvst'        => [ 'atlantic/cape_verde' ],
  'cvt'         => [ 'atlantic/cape_verde' ],
  'cwst'        => [ 'australia/eucla' ],
  'cwt'         => [ 'america/chicago',
                     'america/atikokan',
                     'america/indiana/indianapolis',
                     'america/indiana/knox',
                     'america/indiana/marengo',
                     'america/indiana/petersburg',
                     'america/indiana/tell_city',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/kentucky/monticello',
                     'america/menominee',
                     'america/rainy_river',
                     'america/winnipeg',
                     'america/mexico_city' ],
  'cxt'         => [ 'indian/christmas' ],
  'chst'        => [ 'pacific/guam',
                     'pacific/saipan' ],
  'd'           => [ 'd' ],
  'dact'        => [ 'asia/dhaka' ],
  'davt'        => [ 'antarctica/davis' ],
  'ddut'        => [ 'antarctica/dumontdurville' ],
  'dmt'         => [ 'europe/dublin' ],
  'dusst'       => [ 'asia/dushanbe' ],
  'dust'        => [ 'asia/dushanbe' ],
  'e'           => [ 'e' ],
  'easst'       => [ 'pacific/easter' ],
  'east'        => [ 'pacific/easter',
                     'indian/antananarivo' ],
  'eat'         => [ 'africa/mogadishu',
                     'africa/djibouti',
                     'indian/antananarivo',
                     'indian/comoro',
                     'indian/mayotte',
                     'africa/kampala',
                     'africa/nairobi',
                     'africa/dar_es_salaam',
                     'africa/addis_ababa',
                     'africa/asmara',
                     'africa/khartoum',
                     'africa/juba' ],
  'ect'         => [ 'america/guayaquil',
                     'pacific/galapagos' ],
  'eddt'        => [ 'america/iqaluit' ],
  'edt'         => [ 'america/new_york',
                     'america/montreal',
                     'america/nipigon',
                     'america/toronto',
                     'america/detroit',
                     'america/nassau',
                     'america/kentucky/louisville',
                     'america/indiana/indianapolis',
                     'america/indiana/marengo',
                     'america/indiana/vevay',
                     'america/indiana/vincennes',
                     'america/indiana/winamac',
                     'america/thunder_bay',
                     'america/grand_turk',
                     'america/iqaluit',
                     'america/pangnirtung',
                     'america/kentucky/monticello',
                     'america/indiana/petersburg',
                     'america/port-au-prince',
                     'america/cancun',
                     'america/jamaica',
                     'america/indiana/tell_city',
                     'america/santo_domingo' ],
  'eest'        => [ 'eet',
                     'europe/istanbul',
                     'asia/beirut',
                     'asia/damascus',
                     'europe/athens',
                     'europe/bucharest',
                     'europe/chisinau',
                     'africa/cairo',
                     'europe/helsinki',
                     'asia/gaza',
                     'asia/amman',
                     'asia/nicosia',
                     'europe/sofia',
                     'europe/riga',
                     'europe/tallinn',
                     'europe/kaliningrad',
                     'europe/minsk',
                     'europe/vilnius',
                     'europe/zaporozhye',
                     'europe/kiev',
                     'europe/simferopol',
                     'europe/uzhgorod',
                     'europe/moscow',
                     'europe/warsaw',
                     'asia/hebron' ],
  'eet'         => [ 'eet',
                     'asia/beirut',
                     'europe/sofia',
                     'africa/cairo',
                     'asia/gaza',
                     'europe/istanbul',
                     'europe/athens',
                     'asia/damascus',
                     'europe/vilnius',
                     'asia/nicosia',
                     'europe/helsinki',
                     'europe/tallinn',
                     'europe/kiev',
                     'europe/minsk',
                     'europe/simferopol',
                     'europe/zaporozhye',
                     'europe/riga',
                     'asia/amman',
                     'europe/bucharest',
                     'europe/chisinau',
                     'africa/tripoli',
                     'europe/kaliningrad',
                     'europe/uzhgorod',
                     'europe/moscow',
                     'europe/warsaw',
                     'asia/hebron' ],
  'egst'        => [ 'america/scoresbysund' ],
  'egt'         => [ 'america/scoresbysund' ],
  'ehdt'        => [ 'america/santo_domingo' ],
  'eit'         => [ 'asia/jayapura' ],
  'emt'         => [ 'pacific/easter' ],
  'ept'         => [ 'america/new_york',
                     'america/detroit',
                     'america/iqaluit',
                     'america/montreal',
                     'america/nipigon',
                     'america/thunder_bay',
                     'america/toronto' ],
  'est'         => [ 'america/new_york',
                     'america/montreal',
                     'australia/brisbane',
                     'australia/lindeman',
                     'america/nipigon',
                     'america/toronto',
                     'australia/currie',
                     'australia/hobart',
                     'australia/melbourne',
                     'australia/sydney',
                     'america/panama',
                     'america/thunder_bay',
                     'america/cayman',
                     'america/grand_turk',
                     'america/jamaica',
                     'america/nassau',
                     'america/detroit',
                     'america/port-au-prince',
                     'america/atikokan',
                     'america/iqaluit',
                     'america/indiana/vevay',
                     'america/indiana/indianapolis',
                     'america/indiana/marengo',
                     'america/indiana/winamac',
                     'america/kentucky/louisville',
                     'america/indiana/vincennes',
                     'america/indiana/petersburg',
                     'america/pangnirtung',
                     'america/kentucky/monticello',
                     'america/resolute',
                     'antarctica/macquarie',
                     'america/indiana/knox',
                     'america/indiana/tell_city',
                     'america/rankin_inlet',
                     'america/santo_domingo',
                     'america/cambridge_bay',
                     'america/cancun',
                     'america/managua',
                     'america/merida',
                     'australia/lord_howe',
                     'america/menominee',
                     'america/antigua',
                     'america/chicago',
                     'america/moncton',
                     'australia/broken_hill' ],
  'ewt'         => [ 'america/new_york',
                     'america/detroit',
                     'america/iqaluit',
                     'america/montreal',
                     'america/nipigon',
                     'america/thunder_bay',
                     'america/toronto' ],
  'f'           => [ 'f' ],
  'fet'         => [ 'europe/kaliningrad',
                     'europe/minsk' ],
  'ffmt'        => [ 'america/martinique' ],
  'fjst'        => [ 'pacific/fiji' ],
  'fjt'         => [ 'pacific/fiji' ],
  'fkst'        => [ 'atlantic/stanley' ],
  'fkt'         => [ 'atlantic/stanley' ],
  'fmt'         => [ 'africa/freetown',
                     'atlantic/madeira' ],
  'fnst'        => [ 'america/noronha' ],
  'fnt'         => [ 'america/noronha' ],
  'fort'        => [ 'asia/aqtau' ],
  'frust'       => [ 'asia/bishkek' ],
  'frut'        => [ 'asia/bishkek' ],
  'g'           => [ 'g' ],
  'galt'        => [ 'pacific/galapagos' ],
  'gamt'        => [ 'pacific/gambier' ],
  'gbgt'        => [ 'america/guyana' ],
  'gest'        => [ 'asia/tbilisi' ],
  'get'         => [ 'asia/tbilisi' ],
  'gft'         => [ 'america/cayenne' ],
  'ghst'        => [ 'africa/accra' ],
  'gilt'        => [ 'pacific/tarawa' ],
  'gmt'         => [ 'etc/gmt',
                     'europe/london',
                     'africa/lome',
                     'africa/abidjan',
                     'africa/bamako',
                     'africa/conakry',
                     'africa/nouakchott',
                     'africa/ouagadougou',
                     'africa/sao_tome',
                     'europe/dublin',
                     'africa/accra',
                     'africa/dakar',
                     'atlantic/st_helena',
                     'africa/freetown',
                     'africa/banjul',
                     'atlantic/reykjavik',
                     'africa/monrovia',
                     'africa/bissau',
                     'america/danmarkshavn',
                     'africa/malabo',
                     'africa/niamey',
                     'europe/gibraltar',
                     'africa/porto-novo' ],
  'gmt+1'       => [ 'etc/gmt+1' ],
  'gmt+10'      => [ 'etc/gmt+10' ],
  'gmt+11'      => [ 'etc/gmt+11' ],
  'gmt+12'      => [ 'etc/gmt+12' ],
  'gmt+2'       => [ 'etc/gmt+2' ],
  'gmt+3'       => [ 'etc/gmt+3' ],
  'gmt+4'       => [ 'etc/gmt+4' ],
  'gmt+5'       => [ 'etc/gmt+5' ],
  'gmt+6'       => [ 'etc/gmt+6' ],
  'gmt+7'       => [ 'etc/gmt+7' ],
  'gmt+8'       => [ 'etc/gmt+8' ],
  'gmt+9'       => [ 'etc/gmt+9' ],
  'gmt-1'       => [ 'etc/gmt-1' ],
  'gmt-10'      => [ 'etc/gmt-10' ],
  'gmt-11'      => [ 'etc/gmt-11' ],
  'gmt-12'      => [ 'etc/gmt-12' ],
  'gmt-13'      => [ 'etc/gmt-13' ],
  'gmt-14'      => [ 'etc/gmt-14' ],
  'gmt-2'       => [ 'etc/gmt-2' ],
  'gmt-3'       => [ 'etc/gmt-3' ],
  'gmt-4'       => [ 'etc/gmt-4' ],
  'gmt-5'       => [ 'etc/gmt-5' ],
  'gmt-6'       => [ 'etc/gmt-6' ],
  'gmt-7'       => [ 'etc/gmt-7' ],
  'gmt-8'       => [ 'etc/gmt-8' ],
  'gmt-9'       => [ 'etc/gmt-9' ],
  'gst'         => [ 'atlantic/south_georgia',
                     'asia/dubai',
                     'asia/muscat',
                     'pacific/guam',
                     'asia/bahrain',
                     'asia/qatar' ],
  'gyt'         => [ 'america/guyana' ],
  'h'           => [ 'h' ],
  'hadt'        => [ 'america/adak' ],
  'hast'        => [ 'america/adak' ],
  'hdt'         => [ 'pacific/honolulu' ],
  'hkst'        => [ 'asia/hong_kong' ],
  'hkt'         => [ 'asia/hong_kong' ],
  'hmt'         => [ 'asia/kolkata',
                     'asia/dhaka',
                     'america/havana',
                     'europe/helsinki',
                     'atlantic/azores' ],
  'hovst'       => [ 'asia/hovd' ],
  'hovt'        => [ 'asia/hovd' ],
  'hst'         => [ 'pacific/honolulu' ],
  'i'           => [ 'i' ],
  'ict'         => [ 'asia/ho_chi_minh',
                     'asia/phnom_penh',
                     'asia/vientiane',
                     'asia/bangkok' ],
  'iddt'        => [ 'asia/jerusalem' ],
  'idt'         => [ 'asia/jerusalem',
                     'asia/gaza',
                     'asia/hebron' ],
  'ihst'        => [ 'asia/colombo' ],
  'imt'         => [ 'asia/irkutsk',
                     'europe/istanbul',
                     'europe/sofia' ],
  'iot'         => [ 'indian/chagos' ],
  'irdt'        => [ 'asia/tehran' ],
  'irkst'       => [ 'asia/irkutsk' ],
  'irkt'        => [ 'asia/irkutsk' ],
  'irst'        => [ 'asia/tehran' ],
  'isst'        => [ 'atlantic/reykjavik' ],
  'ist'         => [ 'asia/jerusalem',
                     'asia/colombo',
                     'europe/dublin',
                     'asia/kolkata',
                     'asia/gaza',
                     'asia/thimphu',
                     'asia/kathmandu',
                     'atlantic/reykjavik',
                     'asia/karachi',
                     'asia/dhaka',
                     'asia/hebron' ],
  'javt'        => [ 'asia/jakarta' ],
  'jdt'         => [ 'asia/tokyo' ],
  'jmt'         => [ 'atlantic/st_helena',
                     'asia/jakarta',
                     'asia/jerusalem' ],
  'jst'         => [ 'asia/tokyo',
                     'asia/sakhalin',
                     'asia/hong_kong',
                     'asia/dili',
                     'asia/jakarta',
                     'asia/kuala_lumpur',
                     'asia/kuching',
                     'asia/makassar',
                     'asia/pontianak',
                     'asia/rangoon',
                     'asia/singapore',
                     'asia/manila',
                     'pacific/nauru' ],
  'k'           => [ 'k' ],
  'kart'        => [ 'asia/karachi' ],
  'kast'        => [ 'asia/kashgar' ],
  'kdt'         => [ 'asia/seoul' ],
  'kgst'        => [ 'asia/bishkek' ],
  'kgt'         => [ 'asia/bishkek' ],
  'kizst'       => [ 'asia/qyzylorda' ],
  'kizt'        => [ 'asia/qyzylorda' ],
  'kmt'         => [ 'europe/kiev',
                     'europe/vilnius',
                     'america/st_vincent',
                     'america/jamaica',
                     'america/grand_turk',
                     'america/cayman' ],
  'kost'        => [ 'pacific/kosrae' ],
  'krast'       => [ 'asia/krasnoyarsk',
                     'asia/novokuznetsk' ],
  'krat'        => [ 'asia/krasnoyarsk',
                     'asia/novokuznetsk' ],
  'kst'         => [ 'asia/seoul',
                     'asia/pyongyang' ],
  'kuyst'       => [ 'europe/samara' ],
  'kuyt'        => [ 'europe/samara' ],
  'kwat'        => [ 'pacific/kwajalein' ],
  'l'           => [ 'l' ],
  'lhst'        => [ 'australia/lord_howe' ],
  'lint'        => [ 'pacific/kiritimati' ],
  'lkt'         => [ 'asia/colombo' ],
  'lont'        => [ 'asia/chongqing' ],
  'lrt'         => [ 'africa/monrovia' ],
  'lst'         => [ 'europe/riga' ],
  'm'           => [ 'm' ],
  'madmt'       => [ 'atlantic/madeira' ],
  'madst'       => [ 'atlantic/madeira' ],
  'madt'        => [ 'atlantic/madeira' ],
  'magst'       => [ 'asia/magadan',
                     'asia/ust-nera' ],
  'magt'        => [ 'asia/magadan',
                     'asia/ust-nera' ],
  'malst'       => [ 'asia/singapore',
                     'asia/kuala_lumpur' ],
  'malt'        => [ 'asia/kuala_lumpur',
                     'asia/singapore' ],
  'mart'        => [ 'pacific/marquesas' ],
  'mawt'        => [ 'antarctica/mawson' ],
  'mddt'        => [ 'america/cambridge_bay',
                     'america/yellowknife' ],
  'mdst'        => [ 'europe/moscow' ],
  'mdt'         => [ 'america/denver',
                     'america/edmonton',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/inuvik',
                     'america/yellowknife',
                     'america/mazatlan',
                     'america/chihuahua',
                     'america/ojinaga',
                     'america/bahia_banderas',
                     'america/north_dakota/new_salem',
                     'america/hermosillo',
                     'america/north_dakota/center',
                     'america/phoenix',
                     'america/swift_current',
                     'america/regina',
                     'america/north_dakota/beulah' ],
  'mest'        => [ 'met' ],
  'met'         => [ 'met' ],
  'mht'         => [ 'pacific/kwajalein',
                     'pacific/majuro' ],
  'mist'        => [ 'antarctica/macquarie' ],
  'mmt'         => [ 'asia/rangoon',
                     'indian/maldives',
                     'america/managua',
                     'asia/makassar',
                     'europe/minsk',
                     'america/montevideo',
                     'africa/monrovia',
                     'europe/moscow',
                     'asia/colombo' ],
  'most'        => [ 'asia/macau' ],
  'mot'         => [ 'asia/macau' ],
  'mpt'         => [ 'pacific/saipan',
                     'america/denver',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/edmonton',
                     'america/north_dakota/center',
                     'america/north_dakota/new_salem',
                     'america/regina',
                     'america/swift_current',
                     'america/yellowknife',
                     'america/north_dakota/beulah' ],
  'msd'         => [ 'europe/moscow',
                     'europe/simferopol',
                     'europe/kaliningrad',
                     'europe/vilnius',
                     'europe/zaporozhye',
                     'europe/chisinau',
                     'europe/kiev',
                     'europe/minsk',
                     'europe/uzhgorod',
                     'europe/riga',
                     'europe/tallinn' ],
  'msk'         => [ 'europe/moscow',
                     'europe/simferopol',
                     'europe/minsk',
                     'europe/zaporozhye',
                     'europe/vilnius',
                     'europe/kaliningrad',
                     'europe/kiev',
                     'europe/chisinau',
                     'europe/uzhgorod',
                     'europe/riga',
                     'europe/tallinn' ],
  'mst'         => [ 'america/denver',
                     'america/phoenix',
                     'america/creston',
                     'america/edmonton',
                     'america/cambridge_bay',
                     'america/chihuahua',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/ojinaga',
                     'america/boise',
                     'america/yellowknife',
                     'america/dawson_creek',
                     'america/inuvik',
                     'america/bahia_banderas',
                     'america/north_dakota/new_salem',
                     'america/north_dakota/center',
                     'america/swift_current',
                     'america/regina',
                     'america/mexico_city',
                     'america/santa_isabel',
                     'america/tijuana',
                     'europe/moscow',
                     'america/north_dakota/beulah' ],
  'must'        => [ 'indian/mauritius' ],
  'mut'         => [ 'indian/mauritius' ],
  'mvt'         => [ 'indian/maldives' ],
  'mwt'         => [ 'america/denver',
                     'america/boise',
                     'america/cambridge_bay',
                     'america/edmonton',
                     'america/north_dakota/center',
                     'america/north_dakota/new_salem',
                     'america/phoenix',
                     'america/regina',
                     'america/swift_current',
                     'america/yellowknife',
                     'america/north_dakota/beulah' ],
  'myt'         => [ 'asia/kuala_lumpur',
                     'asia/kuching' ],
  'mest'        => [ 'america/metlakatla' ],
  'n'           => [ 'n' ],
  'ncst'        => [ 'pacific/noumea' ],
  'nct'         => [ 'pacific/noumea' ],
  'nddt'        => [ 'america/st_johns' ],
  'ndt'         => [ 'america/st_johns',
                     'america/goose_bay',
                     'pacific/midway' ],
  'negt'        => [ 'america/paramaribo' ],
  'nest'        => [ 'europe/amsterdam' ],
  'net'         => [ 'europe/amsterdam' ],
  'nft'         => [ 'pacific/norfolk' ],
  'nmt'         => [ 'pacific/norfolk',
                     'asia/novokuznetsk' ],
  'novst'       => [ 'asia/novosibirsk',
                     'asia/novokuznetsk' ],
  'novt'        => [ 'asia/novosibirsk',
                     'asia/novokuznetsk' ],
  'npt'         => [ 'asia/kathmandu',
                     'america/adak',
                     'america/goose_bay',
                     'america/nome',
                     'america/st_johns' ],
  'nrt'         => [ 'pacific/nauru' ],
  'nst'         => [ 'america/st_johns',
                     'america/adak',
                     'america/nome',
                     'pacific/midway',
                     'pacific/pago_pago',
                     'america/goose_bay',
                     'europe/amsterdam' ],
  'nut'         => [ 'pacific/niue' ],
  'nwt'         => [ 'america/st_johns',
                     'america/adak',
                     'america/goose_bay',
                     'america/nome' ],
  'nzdt'        => [ 'pacific/auckland',
                     'antarctica/mcmurdo' ],
  'nzmt'        => [ 'pacific/auckland' ],
  'nzst'        => [ 'pacific/auckland',
                     'antarctica/mcmurdo' ],
  'o'           => [ 'o' ],
  'omsst'       => [ 'asia/omsk' ],
  'omst'        => [ 'asia/omsk' ],
  'orast'       => [ 'asia/oral' ],
  'orat'        => [ 'asia/oral' ],
  'p'           => [ 'p' ],
  'pddt'        => [ 'america/inuvik' ],
  'pdt'         => [ 'america/los_angeles',
                     'america/vancouver',
                     'america/santa_isabel',
                     'america/tijuana',
                     'america/dawson',
                     'america/whitehorse',
                     'america/juneau',
                     'america/dawson_creek',
                     'america/boise',
                     'america/metlakatla',
                     'america/sitka' ],
  'pest'        => [ 'america/lima' ],
  'pet'         => [ 'america/lima' ],
  'petst'       => [ 'asia/kamchatka' ],
  'pett'        => [ 'asia/kamchatka' ],
  'pgt'         => [ 'pacific/port_moresby' ],
  'phot'        => [ 'pacific/enderbury' ],
  'phst'        => [ 'asia/manila' ],
  'pht'         => [ 'asia/manila' ],
  'pkst'        => [ 'asia/karachi' ],
  'pkt'         => [ 'asia/karachi' ],
  'pmdt'        => [ 'america/miquelon' ],
  'pmmt'        => [ 'pacific/port_moresby' ],
  'pmst'        => [ 'america/miquelon' ],
  'pmt'         => [ 'antarctica/dumontdurville',
                     'america/paramaribo',
                     'asia/pontianak',
                     'europe/paris',
                     'europe/monaco',
                     'africa/tunis',
                     'africa/algiers',
                     'europe/prague' ],
  'pnt'         => [ 'pacific/pitcairn' ],
  'pont'        => [ 'pacific/pohnpei' ],
  'ppmt'        => [ 'america/port-au-prince' ],
  'ppt'         => [ 'america/los_angeles',
                     'america/dawson_creek',
                     'america/juneau',
                     'america/santa_isabel',
                     'america/tijuana',
                     'america/vancouver',
                     'america/metlakatla',
                     'america/sitka' ],
  'pst'         => [ 'america/los_angeles',
                     'america/vancouver',
                     'america/santa_isabel',
                     'america/tijuana',
                     'america/whitehorse',
                     'america/dawson',
                     'pacific/pitcairn',
                     'america/juneau',
                     'america/inuvik',
                     'america/dawson_creek',
                     'america/bahia_banderas',
                     'america/hermosillo',
                     'america/mazatlan',
                     'america/boise',
                     'america/metlakatla',
                     'america/sitka',
                     'america/creston' ],
  'pwt'         => [ 'pacific/palau',
                     'america/los_angeles',
                     'america/dawson_creek',
                     'america/juneau',
                     'america/santa_isabel',
                     'america/tijuana',
                     'america/vancouver',
                     'america/metlakatla',
                     'america/sitka' ],
  'pyst'        => [ 'america/asuncion' ],
  'pyt'         => [ 'america/asuncion' ],
  'q'           => [ 'q' ],
  'qmt'         => [ 'america/guayaquil' ],
  'qyzst'       => [ 'asia/qyzylorda' ],
  'qyzt'        => [ 'asia/qyzylorda' ],
  'r'           => [ 'r' ],
  'ret'         => [ 'indian/reunion' ],
  'rmt'         => [ 'europe/riga',
                     'asia/rangoon',
                     'atlantic/reykjavik',
                     'europe/rome' ],
  'rott'        => [ 'antarctica/rothera' ],
  's'           => [ 's' ],
  'sakst'       => [ 'asia/sakhalin' ],
  'sakt'        => [ 'asia/sakhalin' ],
  'samst'       => [ 'europe/samara',
                     'asia/samarkand' ],
  'samt'        => [ 'europe/samara',
                     'asia/samarkand',
                     'pacific/apia',
                     'pacific/pago_pago' ],
  'sast'        => [ 'africa/johannesburg',
                     'africa/maseru',
                     'africa/mbabane',
                     'africa/windhoek',
                     'africa/gaborone' ],
  'sbt'         => [ 'pacific/guadalcanal' ],
  'sct'         => [ 'indian/mahe' ],
  'sdmt'        => [ 'america/santo_domingo' ],
  'set'         => [ 'europe/stockholm' ],
  'sgt'         => [ 'asia/singapore' ],
  'shest'       => [ 'asia/aqtau' ],
  'shet'        => [ 'asia/aqtau' ],
  'sjmt'        => [ 'america/costa_rica' ],
  'slst'        => [ 'africa/freetown' ],
  'smt'         => [ 'america/santiago',
                     'europe/simferopol',
                     'atlantic/stanley',
                     'asia/vientiane',
                     'asia/phnom_penh',
                     'asia/ho_chi_minh',
                     'asia/singapore',
                     'asia/kuala_lumpur' ],
  'srt'         => [ 'america/paramaribo' ],
  'sst'         => [ 'pacific/pago_pago',
                     'pacific/midway' ],
  'stat'        => [ 'europe/volgograd' ],
  'svest'       => [ 'asia/yekaterinburg' ],
  'svet'        => [ 'asia/yekaterinburg' ],
  'swat'        => [ 'africa/windhoek' ],
  'syot'        => [ 'antarctica/syowa' ],
  't'           => [ 't' ],
  'taht'        => [ 'pacific/tahiti' ],
  'tasst'       => [ 'asia/tashkent' ],
  'tast'        => [ 'asia/tashkent',
                     'asia/samarkand' ],
  'tbist'       => [ 'asia/tbilisi' ],
  'tbit'        => [ 'asia/tbilisi' ],
  'tbmt'        => [ 'asia/tbilisi' ],
  'tft'         => [ 'indian/kerguelen' ],
  'tjt'         => [ 'asia/dushanbe' ],
  'tkt'         => [ 'pacific/fakaofo' ],
  'tlt'         => [ 'asia/dili' ],
  'tmt'         => [ 'asia/ashgabat',
                     'asia/tehran',
                     'europe/tallinn' ],
  'tost'        => [ 'pacific/tongatapu' ],
  'tot'         => [ 'pacific/tongatapu' ],
  'trst'        => [ 'europe/istanbul' ],
  'trt'         => [ 'europe/istanbul' ],
  'tsat'        => [ 'europe/volgograd' ],
  'tvt'         => [ 'pacific/funafuti' ],
  'u'           => [ 'u' ],
  'ulast'       => [ 'asia/ulaanbaatar' ],
  'ulat'        => [ 'asia/ulaanbaatar',
                     'asia/choibalsan' ],
  'urast'       => [ 'asia/oral' ],
  'urat'        => [ 'asia/oral' ],
  'urut'        => [ 'asia/urumqi' ],
  'ut'          => [ 'ut' ],
  'utc'         => [ 'utc' ],
  'uyhst'       => [ 'america/montevideo' ],
  'uyst'        => [ 'america/montevideo' ],
  'uyt'         => [ 'america/montevideo' ],
  'uzst'        => [ 'asia/samarkand',
                     'asia/tashkent' ],
  'uzt'         => [ 'asia/samarkand',
                     'asia/tashkent' ],
  'v'           => [ 'v' ],
  'vet'         => [ 'america/caracas' ],
  'vlasst'      => [ 'asia/vladivostok' ],
  'vlast'       => [ 'asia/vladivostok',
                     'asia/khandyga' ],
  'vlat'        => [ 'asia/vladivostok',
                     'asia/ust-nera',
                     'asia/khandyga' ],
  'volst'       => [ 'europe/volgograd' ],
  'volt'        => [ 'europe/volgograd' ],
  'vost'        => [ 'antarctica/vostok' ],
  'vust'        => [ 'pacific/efate' ],
  'vut'         => [ 'pacific/efate' ],
  'w'           => [ 'w' ],
  'wakt'        => [ 'pacific/wake' ],
  'warst'       => [ 'america/argentina/san_luis',
                     'america/argentina/mendoza',
                     'america/argentina/jujuy' ],
  'wart'        => [ 'america/argentina/san_luis',
                     'america/argentina/mendoza',
                     'america/argentina/catamarca',
                     'america/argentina/la_rioja',
                     'america/argentina/san_juan',
                     'america/argentina/tucuman',
                     'america/argentina/rio_gallegos',
                     'america/argentina/ushuaia',
                     'america/argentina/jujuy',
                     'america/argentina/cordoba',
                     'america/argentina/salta' ],
  'wast'        => [ 'africa/windhoek',
                     'africa/ndjamena' ],
  'wat'         => [ 'africa/kinshasa',
                     'africa/bangui',
                     'africa/brazzaville',
                     'africa/douala',
                     'africa/libreville',
                     'africa/luanda',
                     'africa/ndjamena',
                     'africa/niamey',
                     'africa/lagos',
                     'africa/porto-novo',
                     'africa/malabo',
                     'africa/windhoek',
                     'africa/el_aaiun',
                     'africa/bissau',
                     'africa/banjul',
                     'africa/bamako',
                     'africa/conakry',
                     'africa/nouakchott',
                     'africa/freetown',
                     'africa/dakar' ],
  'wemt'        => [ 'europe/madrid',
                     'europe/lisbon',
                     'europe/monaco',
                     'europe/paris' ],
  'west'        => [ 'wet',
                     'europe/lisbon',
                     'atlantic/madeira',
                     'atlantic/canary',
                     'atlantic/faroe',
                     'africa/casablanca',
                     'africa/algiers',
                     'africa/ceuta',
                     'europe/madrid',
                     'europe/monaco',
                     'europe/paris',
                     'europe/luxembourg',
                     'europe/brussels' ],
  'wet'         => [ 'wet',
                     'atlantic/faroe',
                     'europe/lisbon',
                     'africa/casablanca',
                     'atlantic/canary',
                     'atlantic/madeira',
                     'africa/el_aaiun',
                     'atlantic/azores',
                     'africa/ceuta',
                     'africa/algiers',
                     'europe/andorra',
                     'europe/luxembourg',
                     'europe/brussels',
                     'europe/madrid',
                     'europe/monaco',
                     'europe/paris' ],
  'wft'         => [ 'pacific/wallis' ],
  'wgst'        => [ 'america/godthab',
                     'america/danmarkshavn' ],
  'wgt'         => [ 'america/godthab',
                     'america/danmarkshavn' ],
  'wit'         => [ 'asia/jakarta',
                     'asia/pontianak' ],
  'wmt'         => [ 'europe/vilnius',
                     'europe/warsaw' ],
  'wsdt'        => [ 'pacific/apia' ],
  'wst'         => [ 'australia/perth',
                     'pacific/apia',
                     'antarctica/casey' ],
  'x'           => [ 'x' ],
  'y'           => [ 'y' ],
  'yakst'       => [ 'asia/yakutsk',
                     'asia/khandyga' ],
  'yakt'        => [ 'asia/yakutsk',
                     'asia/khandyga',
                     'asia/ust-nera' ],
  'yddt'        => [ 'america/whitehorse',
                     'america/dawson' ],
  'ydt'         => [ 'america/yakutat',
                     'america/dawson',
                     'america/whitehorse',
                     'america/juneau' ],
  'yekst'       => [ 'asia/yekaterinburg' ],
  'yekt'        => [ 'asia/yekaterinburg' ],
  'yerst'       => [ 'asia/yerevan' ],
  'yert'        => [ 'asia/yerevan' ],
  'ypt'         => [ 'america/whitehorse',
                     'america/dawson',
                     'america/yakutat' ],
  'yst'         => [ 'america/anchorage',
                     'america/yakutat',
                     'america/juneau',
                     'america/nome',
                     'america/dawson',
                     'america/whitehorse',
                     'america/sitka' ],
  'ywt'         => [ 'america/whitehorse',
                     'america/dawson',
                     'america/yakutat' ],
  'z'           => [ 'z' ],

);

%Offmod = (
  '+00:00:00'  => 'off000',
  '+00:04:52'  => 'off001',
  '+00:06:04'  => 'off002',
  '+00:08:28'  => 'off003',
  '+00:09:21'  => 'off004',
  '+00:10:28'  => 'off005',
  '+00:12:12'  => 'off006',
  '+00:13:36'  => 'off007',
  '+00:17:30'  => 'off008',
  '+00:19:32'  => 'off009',
  '+00:20:00'  => 'off010',
  '+00:24:36'  => 'off011',
  '+00:26:56'  => 'off012',
  '+00:29:32'  => 'off013',
  '+00:29:44'  => 'off014',
  '+00:34:08'  => 'off015',
  '+00:34:39'  => 'off016',
  '+00:35:08'  => 'off017',
  '+00:37:48'  => 'off018',
  '+00:38:04'  => 'off019',
  '+00:38:48'  => 'off020',
  '+00:40:44'  => 'off021',
  '+00:43:00'  => 'off022',
  '+00:49:56'  => 'off023',
  '+00:50:20'  => 'off024',
  '+00:52:04'  => 'off025',
  '+00:52:44'  => 'off026',
  '+00:52:56'  => 'off027',
  '+00:53:28'  => 'off028',
  '+00:57:44'  => 'off029',
  '+00:58:04'  => 'off030',
  '+01:00:00'  => 'off031',
  '+01:00:12'  => 'off032',
  '+01:00:14'  => 'off033',
  '+01:01:08'  => 'off034',
  '+01:01:12'  => 'off035',
  '+01:05:21'  => 'off036',
  '+01:08:24'  => 'off037',
  '+01:12:12'  => 'off038',
  '+01:14:20'  => 'off039',
  '+01:16:20'  => 'off040',
  '+01:19:20'  => 'off041',
  '+01:19:32'  => 'off042',
  '+01:20:00'  => 'off043',
  '+01:22:00'  => 'off044',
  '+01:24:00'  => 'off045',
  '+01:29:12'  => 'off046',
  '+01:30:00'  => 'off047',
  '+01:33:16'  => 'off048',
  '+01:34:52'  => 'off049',
  '+01:35:36'  => 'off050',
  '+01:36:24'  => 'off051',
  '+01:39:00'  => 'off052',
  '+01:39:52'  => 'off053',
  '+01:41:16'  => 'off054',
  '+01:43:40'  => 'off055',
  '+01:44:24'  => 'off056',
  '+01:49:52'  => 'off057',
  '+01:50:00'  => 'off058',
  '+01:50:16'  => 'off059',
  '+01:52:00'  => 'off060',
  '+01:53:08'  => 'off061',
  '+01:55:00'  => 'off062',
  '+01:55:20'  => 'off063',
  '+01:55:52'  => 'off064',
  '+01:56:56'  => 'off065',
  '+01:57:28'  => 'off066',
  '+02:00:00'  => 'off067',
  '+02:00:16'  => 'off068',
  '+02:02:04'  => 'off069',
  '+02:04:12'  => 'off070',
  '+02:04:24'  => 'off071',
  '+02:05:09'  => 'off072',
  '+02:06:24'  => 'off073',
  '+02:09:40'  => 'off074',
  '+02:10:08'  => 'off075',
  '+02:10:20'  => 'off076',
  '+02:13:28'  => 'off077',
  '+02:16:00'  => 'off078',
  '+02:16:24'  => 'off079',
  '+02:17:52'  => 'off080',
  '+02:20:00'  => 'off081',
  '+02:20:23'  => 'off082',
  '+02:20:40'  => 'off083',
  '+02:20:56'  => 'off084',
  '+02:22:00'  => 'off085',
  '+02:23:44'  => 'off086',
  '+02:25:12'  => 'off087',
  '+02:27:16'  => 'off088',
  '+02:30:00'  => 'off089',
  '+02:30:20'  => 'off090',
  '+02:30:48'  => 'off091',
  '+02:34:48'  => 'off092',
  '+02:35:20'  => 'off093',
  '+02:35:32'  => 'off094',
  '+02:36:24'  => 'off095',
  '+02:37:08'  => 'off096',
  '+02:45:00'  => 'off097',
  '+02:52:36'  => 'off098',
  '+02:53:04'  => 'off099',
  '+02:57:36'  => 'off100',
  '+02:57:40'  => 'off101',
  '+02:58:00'  => 'off102',
  '+02:59:16'  => 'off103',
  '+02:59:54'  => 'off104',
  '+03:00:00'  => 'off105',
  '+03:00:56'  => 'off106',
  '+03:01:28'  => 'off107',
  '+03:06:52'  => 'off108',
  '+03:10:04'  => 'off109',
  '+03:11:56'  => 'off110',
  '+03:19:24'  => 'off111',
  '+03:20:36'  => 'off112',
  '+03:21:04'  => 'off113',
  '+03:22:20'  => 'off114',
  '+03:25:24'  => 'off115',
  '+03:25:44'  => 'off116',
  '+03:26:08'  => 'off117',
  '+03:30:00'  => 'off118',
  '+03:30:48'  => 'off119',
  '+03:41:12'  => 'off120',
  '+03:41:48'  => 'off121',
  '+03:41:52'  => 'off122',
  '+03:48:40'  => 'off123',
  '+03:50:00'  => 'off124',
  '+03:53:32'  => 'off125',
  '+03:54:24'  => 'off126',
  '+04:00:00'  => 'off127',
  '+04:02:24'  => 'off128',
  '+04:21:52'  => 'off129',
  '+04:27:12'  => 'off130',
  '+04:28:12'  => 'off131',
  '+04:30:00'  => 'off132',
  '+04:30:48'  => 'off133',
  '+04:35:12'  => 'off134',
  '+04:36:48'  => 'off135',
  '+04:37:12'  => 'off136',
  '+04:49:40'  => 'off137',
  '+04:53:36'  => 'off138',
  '+04:54:00'  => 'off139',
  '+04:58:24'  => 'off140',
  '+05:00:00'  => 'off141',
  '+05:03:56'  => 'off142',
  '+05:07:48'  => 'off143',
  '+05:19:24'  => 'off144',
  '+05:19:32'  => 'off145',
  '+05:30:00'  => 'off146',
  '+05:31:40'  => 'off147',
  '+05:41:16'  => 'off148',
  '+05:45:00'  => 'off149',
  '+05:48:48'  => 'off150',
  '+05:50:20'  => 'off151',
  '+05:53:20'  => 'off152',
  '+05:53:28'  => 'off153',
  '+05:58:36'  => 'off154',
  '+06:00:00'  => 'off155',
  '+06:01:40'  => 'off156',
  '+06:06:36'  => 'off157',
  '+06:11:20'  => 'off158',
  '+06:24:40'  => 'off159',
  '+06:27:40'  => 'off160',
  '+06:30:00'  => 'off161',
  '+06:42:04'  => 'off162',
  '+06:46:46'  => 'off163',
  '+06:50:24'  => 'off164',
  '+06:55:25'  => 'off165',
  '+06:57:20'  => 'off166',
  '+06:59:40'  => 'off167',
  '+07:00:00'  => 'off168',
  '+07:02:52'  => 'off169',
  '+07:06:20'  => 'off170',
  '+07:06:40'  => 'off171',
  '+07:07:12'  => 'off172',
  '+07:07:32'  => 'off173',
  '+07:17:20'  => 'off174',
  '+07:20:00'  => 'off175',
  '+07:21:20'  => 'off176',
  '+07:30:00'  => 'off177',
  '+07:34:20'  => 'off178',
  '+07:36:42'  => 'off179',
  '+07:38:00'  => 'off180',
  '+07:39:40'  => 'off181',
  '+07:43:24'  => 'off182',
  '+07:57:36'  => 'off183',
  '+08:00:00'  => 'off184',
  '+08:04:00'  => 'off185',
  '+08:05:57'  => 'off186',
  '+08:06:00'  => 'off187',
  '+08:20:00'  => 'off188',
  '+08:22:20'  => 'off189',
  '+08:23:00'  => 'off190',
  '+08:26:44'  => 'off191',
  '+08:27:52'  => 'off192',
  '+08:30:00'  => 'off193',
  '+08:35:28'  => 'off194',
  '+08:38:40'  => 'off195',
  '+08:43:20'  => 'off196',
  '+08:45:00'  => 'off197',
  '+08:47:44'  => 'off198',
  '+08:57:56'  => 'off199',
  '+09:00:00'  => 'off200',
  '+09:02:13'  => 'off201',
  '+09:14:20'  => 'off202',
  '+09:18:59'  => 'off203',
  '+09:22:48'  => 'off204',
  '+09:25:48'  => 'off205',
  '+09:30:00'  => 'off206',
  '+09:30:48'  => 'off207',
  '+09:32:54'  => 'off208',
  '+09:35:28'  => 'off209',
  '+09:39:00'  => 'off210',
  '+09:39:52'  => 'off211',
  '+09:43:00'  => 'off212',
  '+09:45:00'  => 'off213',
  '+09:48:32'  => 'off214',
  '+09:48:40'  => 'off215',
  '+09:49:16'  => 'off216',
  '+09:55:56'  => 'off217',
  '+10:00:00'  => 'off218',
  '+10:03:12'  => 'off219',
  '+10:04:52'  => 'off220',
  '+10:07:08'  => 'off221',
  '+10:12:08'  => 'off222',
  '+10:30:00'  => 'off223',
  '+10:32:52'  => 'off224',
  '+10:34:36'  => 'off225',
  '+10:36:20'  => 'off226',
  '+10:39:48'  => 'off227',
  '+10:51:56'  => 'off228',
  '+11:00:00'  => 'off229',
  '+11:05:48'  => 'off230',
  '+11:06:28'  => 'off231',
  '+11:07:40'  => 'off232',
  '+11:09:20'  => 'off233',
  '+11:11:52'  => 'off234',
  '+11:12:00'  => 'off235',
  '+11:13:16'  => 'off236',
  '+11:24:48'  => 'off237',
  '+11:30:00'  => 'off238',
  '+11:32:04'  => 'off239',
  '+11:39:04'  => 'off240',
  '+11:49:56'  => 'off241',
  '+11:55:44'  => 'off242',
  '+11:56:52'  => 'off243',
  '+12:00:00'  => 'off244',
  '+12:13:21'  => 'off245',
  '+12:13:48'  => 'off246',
  '+12:15:20'  => 'off247',
  '+12:19:20'  => 'off248',
  '+12:20:00'  => 'off249',
  '+12:30:00'  => 'off250',
  '+12:33:04'  => 'off251',
  '+12:37:12'  => 'off252',
  '+12:45:00'  => 'off253',
  '+12:58:21'  => 'off254',
  '+13:00:00'  => 'off255',
  '+13:45:00'  => 'off256',
  '+14:00:00'  => 'off257',
  '+14:00:24'  => 'off258',
  '+14:41:05'  => 'off259',
  '+14:58:47'  => 'off260',
  '+15:02:19'  => 'off261',
  '+15:13:42'  => 'off262',
  '-00:00:52'  => 'off263',
  '-00:01:15'  => 'off264',
  '-00:06:04'  => 'off265',
  '-00:14:44'  => 'off266',
  '-00:16:08'  => 'off267',
  '-00:20:00'  => 'off268',
  '-00:21:16'  => 'off269',
  '-00:21:24'  => 'off270',
  '-00:22:48'  => 'off271',
  '-00:25:00'  => 'off272',
  '-00:25:21'  => 'off273',
  '-00:27:04'  => 'off274',
  '-00:30:20'  => 'off275',
  '-00:32:00'  => 'off276',
  '-00:36:32'  => 'off277',
  '-00:43:08'  => 'off278',
  '-00:44:30'  => 'off279',
  '-00:52:48'  => 'off280',
  '-00:53:00'  => 'off281',
  '-00:54:52'  => 'off282',
  '-01:00:00'  => 'off283',
  '-01:01:36'  => 'off284',
  '-01:02:20'  => 'off285',
  '-01:03:48'  => 'off286',
  '-01:06:36'  => 'off287',
  '-01:07:36'  => 'off288',
  '-01:09:44'  => 'off289',
  '-01:14:40'  => 'off290',
  '-01:27:24'  => 'off291',
  '-01:27:48'  => 'off292',
  '-01:27:52'  => 'off293',
  '-01:30:00'  => 'off294',
  '-01:34:04'  => 'off295',
  '-01:42:40'  => 'off296',
  '-01:54:32'  => 'off297',
  '-02:00:00'  => 'off298',
  '-02:09:40'  => 'off299',
  '-02:19:36'  => 'off300',
  '-02:22:52'  => 'off301',
  '-02:26:08'  => 'off302',
  '-02:30:00'  => 'off303',
  '-02:30:52'  => 'off304',
  '-02:34:00'  => 'off305',
  '-02:34:04'  => 'off306',
  '-03:00:00'  => 'off307',
  '-03:06:28'  => 'off308',
  '-03:12:48'  => 'off309',
  '-03:13:56'  => 'off310',
  '-03:26:56'  => 'off311',
  '-03:29:20'  => 'off312',
  '-03:30:00'  => 'off313',
  '-03:30:52'  => 'off314',
  '-03:32:36'  => 'off315',
  '-03:38:28'  => 'off316',
  '-03:38:48'  => 'off317',
  '-03:40:36'  => 'off318',
  '-03:40:40'  => 'off319',
  '-03:40:52'  => 'off320',
  '-03:44:20'  => 'off321',
  '-03:44:40'  => 'off322',
  '-03:44:44'  => 'off323',
  '-03:45:00'  => 'off324',
  '-03:48:28'  => 'off325',
  '-03:50:40'  => 'off326',
  '-03:51:24'  => 'off327',
  '-03:52:40'  => 'off328',
  '-03:53:48'  => 'off329',
  '-03:58:29'  => 'off330',
  '-03:59:48'  => 'off331',
  '-04:00:00'  => 'off332',
  '-04:00:04'  => 'off333',
  '-04:01:40'  => 'off334',
  '-04:02:40'  => 'off335',
  '-04:04:00'  => 'off336',
  '-04:04:20'  => 'off337',
  '-04:04:56'  => 'off338',
  '-04:05:36'  => 'off339',
  '-04:06:04'  => 'off340',
  '-04:06:08'  => 'off341',
  '-04:07:00'  => 'off342',
  '-04:07:12'  => 'off343',
  '-04:08:52'  => 'off344',
  '-04:10:52'  => 'off345',
  '-04:12:16'  => 'off346',
  '-04:14:24'  => 'off347',
  '-04:15:36'  => 'off348',
  '-04:16:48'  => 'off349',
  '-04:18:28'  => 'off350',
  '-04:19:08'  => 'off351',
  '-04:19:18'  => 'off352',
  '-04:19:44'  => 'off353',
  '-04:20:52'  => 'off354',
  '-04:21:12'  => 'off355',
  '-04:21:40'  => 'off356',
  '-04:23:08'  => 'off357',
  '-04:24:25'  => 'off358',
  '-04:25:24'  => 'off359',
  '-04:27:24'  => 'off360',
  '-04:27:40'  => 'off361',
  '-04:27:44'  => 'off362',
  '-04:30:00'  => 'off363',
  '-04:31:12'  => 'off364',
  '-04:32:36'  => 'off365',
  '-04:33:12'  => 'off366',
  '-04:34:04'  => 'off367',
  '-04:35:08'  => 'off368',
  '-04:35:16'  => 'off369',
  '-04:35:47'  => 'off370',
  '-04:36:52'  => 'off371',
  '-04:39:28'  => 'off372',
  '-04:39:36'  => 'off373',
  '-04:40:00'  => 'off374',
  '-04:40:24'  => 'off375',
  '-04:42:46'  => 'off376',
  '-04:44:32'  => 'off377',
  '-04:49:00'  => 'off378',
  '-04:49:20'  => 'off379',
  '-04:54:16'  => 'off380',
  '-04:56:02'  => 'off381',
  '-04:56:16'  => 'off382',
  '-05:00:00'  => 'off383',
  '-05:07:12'  => 'off384',
  '-05:08:12'  => 'off385',
  '-05:08:36'  => 'off386',
  '-05:09:30'  => 'off387',
  '-05:14:00'  => 'off388',
  '-05:17:32'  => 'off389',
  '-05:18:08'  => 'off390',
  '-05:19:20'  => 'off391',
  '-05:19:36'  => 'off392',
  '-05:25:32'  => 'off393',
  '-05:29:28'  => 'off394',
  '-05:29:36'  => 'off395',
  '-05:30:00'  => 'off396',
  '-05:32:11'  => 'off397',
  '-05:36:13'  => 'off398',
  '-05:39:24'  => 'off399',
  '-05:40:16'  => 'off400',
  '-05:43:02'  => 'off401',
  '-05:44:38'  => 'off402',
  '-05:45:08'  => 'off403',
  '-05:45:12'  => 'off404',
  '-05:45:23'  => 'off405',
  '-05:46:25'  => 'off406',
  '-05:46:30'  => 'off407',
  '-05:47:03'  => 'off408',
  '-05:47:04'  => 'off409',
  '-05:48:52'  => 'off410',
  '-05:49:07'  => 'off411',
  '-05:50:07'  => 'off412',
  '-05:50:27'  => 'off413',
  '-05:50:36'  => 'off414',
  '-05:52:48'  => 'off415',
  '-05:53:04'  => 'off416',
  '-05:56:48'  => 'off417',
  '-05:57:00'  => 'off418',
  '-05:58:24'  => 'off419',
  '-05:58:28'  => 'off420',
  '-06:00:00'  => 'off421',
  '-06:02:04'  => 'off422',
  '-06:06:28'  => 'off423',
  '-06:18:16'  => 'off424',
  '-06:28:36'  => 'off425',
  '-06:36:36'  => 'off426',
  '-06:40:00'  => 'off427',
  '-06:41:16'  => 'off428',
  '-06:45:12'  => 'off429',
  '-06:45:39'  => 'off430',
  '-06:47:07'  => 'off431',
  '-06:57:40'  => 'off432',
  '-06:58:36'  => 'off433',
  '-06:59:56'  => 'off434',
  '-07:00:00'  => 'off435',
  '-07:01:00'  => 'off436',
  '-07:04:20'  => 'off437',
  '-07:05:40'  => 'off438',
  '-07:11:20'  => 'off439',
  '-07:17:28'  => 'off440',
  '-07:17:44'  => 'off441',
  '-07:23:52'  => 'off442',
  '-07:28:18'  => 'off443',
  '-07:33:52'  => 'off444',
  '-07:39:28'  => 'off445',
  '-07:44:49'  => 'off446',
  '-07:46:04'  => 'off447',
  '-07:48:04'  => 'off448',
  '-07:52:58'  => 'off449',
  '-08:00:00'  => 'off450',
  '-08:00:56'  => 'off451',
  '-08:12:28'  => 'off452',
  '-08:30:00'  => 'off453',
  '-08:40:20'  => 'off454',
  '-08:46:18'  => 'off455',
  '-08:57:41'  => 'off456',
  '-08:59:48'  => 'off457',
  '-09:00:00'  => 'off458',
  '-09:00:12'  => 'off459',
  '-09:01:13'  => 'off460',
  '-09:17:40'  => 'off461',
  '-09:18:00'  => 'off462',
  '-09:18:55'  => 'off463',
  '-09:30:00'  => 'off464',
  '-09:58:16'  => 'off465',
  '-09:59:36'  => 'off466',
  '-10:00:00'  => 'off467',
  '-10:29:20'  => 'off468',
  '-10:30:00'  => 'off469',
  '-10:31:26'  => 'off470',
  '-10:39:04'  => 'off471',
  '-10:40:00'  => 'off472',
  '-11:00:00'  => 'off473',
  '-11:01:38'  => 'off474',
  '-11:19:40'  => 'off475',
  '-11:20:00'  => 'off476',
  '-11:22:48'  => 'off477',
  '-11:24:20'  => 'off478',
  '-11:24:56'  => 'off479',
  '-11:26:56'  => 'off480',
  '-11:30:00'  => 'off481',
  '-11:46:38'  => 'off482',
  '-11:49:28'  => 'off483',
  '-12:00:00'  => 'off484',
  '-13:00:00'  => 'off485',
  '-14:00:00'  => 'off486',
  '-14:17:00'  => 'off487',
  '-14:21:00'  => 'off488',
  '-15:56:00'  => 'off489',

);

1;
