package Perl::Staff;

use warnings;
use strict;

=head1 NAME

Perl::Staff - People working for Perl

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

Actually this is just a list of people working as "Perl::Staff" on events
showing Perl to the outside world.

The Perl community is quite active but some kind of closed as few new people
join. "Outside world" are all people either using or not using Perl, but
not using the powerful Perl community resources like CPAN, Perlmonks and
others.

We created t-shirts with "Perl::Staff" printed on them first for CeBit 2010
in Germany and this is how Perl::Staff was born.

=head1 EXPORT

Anybody here may be exportable to other events, just talk to them if you
need help planning an event or need Perl::Staff for helping on the event.

=head1 IMPORT

If you want to become Perl::Staff and get listed here, just pick an event
where you'd like to give a Perl talk or export Perl to non-community
people in any way. Join the events mailing list for more information on events
and how you could help, come to the event and we'll try to get you a
Perl::Staff t-shirt and add you to the list.

=head1 EVENTS 2010

=head2 FOSDEM

Event planning page: L<http://www.perlfoundation.org/perl5/index.cgi?events_2010_fosdem>

=head3 Gabor Szabo

(main coordinator)
Event report: L<http://szabgab.com/blog/2010/02/1266052953.html>

=head3 Claudio Ramirez

Event report: L<http://nxadm.wordpress.com/2010/02/19/fosdem-2010-impressions/>

=head3 Dirk DeNijs

=head3 Dave Cross

=head3 Erik Colson

=head2 CeBit

Event planning page: L<http://www.perlfoundation.org/perl5/index.cgi?events_2010_cebit>

=head3 Gabor Szabo

(main coordinator)

=head3 Renee B\x{00e4}cker

(main coordinator)
Did a talk on Perl on CeBit.

=head3 Sebastian Willing

Event report: L<http://padre-ide.de/blog/?p=101>

=head3 Thorsten Raudssus

use Moose;

=head3 Thomas Fahle

=head3 Bernhard Schmalhofer

=head3 Oliver Kr\x{00fc}ger

=head3 Michael Daum

=cut

=head1 AUTHOR

Perl event staff

=head1 SUPPORT

Look at the Perl foundation events list at http://www.perlfoundation.org/perl5/index.cgi?events

=back

=head1 COPYRIGHT & LICENSE

Copyright 2010 Perl event staff, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of Perl::Staff
