package Spp::Tools;

use Exporter;
our @ISA    = qw(Exporter);
our @EXPORT = qw(all is_perl_str is_perl_array
   read_file write_file str to_json from_json
   count start_with end_with 
   first tail rest trim len subarray);

use 5.012;
no warnings "experimental";
use JSON::XS qw(encode_json decode_json);
use List::MoreUtils qw(all);

sub is_perl_str {
   my $x = shift;
   return (ref($x) eq ref(''));
}

sub is_perl_array {
   my $x = shift;
   return (ref($x) eq ref([]));
}

sub read_file {
   my $file = shift;
   die("file: $file not exists") if not -e $file;
   local $/;
   open my ($fh), '<:utf8', $file or die $!;
   return <$fh>;
}

sub write_file {
   my ($file, $str) = @_;
   open my ($fh), '>:utf8', $file or die $!;
   print {$fh} $str;
   return $file;
}

sub str {
   my @strs = @_;
   return join('', @strs);
}

sub to_json { 
  my $data = shift;
  if (is_perl_str($data)) {
    my $json_str = encode_json([$data]);
    return substr($json_str, 1, -1);
  } 
  return encode_json($data);
}

sub from_json { return decode_json(shift) }

sub first {
  my $data = shift;
  if (is_perl_str($data)) { return substr($data, 0, 1) }
  if (is_perl_array($data)) { return $data->[0] }
  die "could not first($data)";
}

sub tail {
  my $data = shift;
  if (is_perl_str($data)) { return substr($data, -1) }
  if (is_perl_array($data)) { return $data->[-1] }
  die "Could not tail($data)";
}

sub rest {
   my $data = shift;
   return substr($data, 1) if is_perl_str($data);
   if (is_perl_array($data)) {
     # copy $data, splice would change array
     my @array = @{$data};
     return [ splice(@array, 1) ];
   }
   die("rest only could do str or array");
}

sub count {
   my ($str, $char) = @_;
   my @array = ($str =~ /$char/g);
   return scalar(@array);
}

sub start_with {
   my ($str, $start) = @_;
   return 1 if index($str, $start) == 0;
   return 0;
}

sub end_with {
   my ($str, $end) = @_;
   my $len = length($end);
   return substr($str, -$len) eq $end;
}

sub len {
   my $data = shift;
   return scalar(@{$data}) if is_perl_array($data);
   return length($data) if is_perl_str($data);
}

sub trim {
   my $str = shift;
   if (is_perl_str($str)) {
      $str =~ s/^\s+|\s+$//g;
      return $str;
   }
   die("trim only make string");
}

sub subarray {
  my ($array, $from, $to) = @_;
  # make copy of $array, splice would change it
  my @array = @{$array};
  if (is_perl_array($array)) {
    if ($to > 0) {
      my $len = $to - $from + 1;
      my $sub_array = [ splice @array, $from, $len ];
      return $sub_array;
    }
    if (defined $to) {
       return [ splice @array, $from, $to ];
    }
    return [ splice @array, $from ];
  }
  die "subarray only could process array";
}

1;
