use Module::Build;

use strict;

my $build = Module::Build->new(
    module_name => 'Class::MOP',
    license => 'perl',
    requires => {
        'Scalar::Util' => '1.18',
        'Sub::Name'    => '0.02',
        'Carp'         => '0.01',
        'B'            => '0',
        'Clone'        => '0.18',
    },
    optional => {
    },
    build_requires => {
        'Test::More'      => '0.47',
        'Test::Exception' => '0.21',
        'File::Spec'      => '0',
    },
    create_makefile_pl => 'traditional',
    recursive_test_files => 1,
    add_to_cleanup => [
        'META.yml', '*.bak', '*.gz', 'Makefile.PL',
    ],
);

$build->create_build_script;

