use strict;
use warnings;

use GPSD::Parse;
use Test::More;

my $mod = 'GPSD::Parse';

my $fname = 't/data/gps.json';

my $gps;

my $sock = eval {
    $gps = $mod->new;
    1;
};

$gps = GPSD::Parse->new(file => $fname) if ! $sock;

$gps->on if $sock;

{ # default return

    $gps->poll;

    my $t = $gps->time;

    is ref \$t, 'SCALAR', "time is returned as a string";
    like $t, qr/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/, "...and is ok"; 
}

$gps->off if $sock;

done_testing;
