use strict;
use warnings;

use GPSD::Parse;
use Test::More;

my $mod = 'GPSD::Parse';

my $fname = 't/data/gps.json';

my $gps;

my $sock = eval {
    $gps = $mod->new;
    1;
};

$gps = GPSD::Parse->new(file => $fname) if ! $sock;

$gps->on if $sock;

{ # default return

    $gps->poll;

    my $t = $gps->device;

    is ref \$t, 'SCALAR', "device is returned as a string";
    like $t, qr|^/dev/ttyS0$|, "...and is ok"; 
}

$gps->off if $sock;

done_testing;
