#!/usr/bin/perl -w

# $Id: petris-layouts.pl,v 1.2 1999/08/08 15:46:59 root Exp root $

# Copyright (c) Mark Summerfield 1998/9. All Rights Reserved.
# May be used/distributed under the GPL.

use strict ;

package main ;


# Layouts basically just pre fill-in squares on the board. Any which are out
# of range for the board size chosen are ignored. The standard ones are
# designed for the default board size (12 x 25), but will work with all larger
# boards, although offset to the centre left. 

# If you want to test out a new layout then add it at the END of the ones given
# but name it $Const{LAYOUT_0}, i.e. make it overwrite the standard layout zero;
# then set the $Const{LAYOUT_MAX} to zero so the only layout that will
# appear will be the new one. Once satisfied that its shape is OK, change its
# number to the next in line and set the layout max to that number.

# 0  -----
#     | |
#     | |
#
$Const{LAYOUT_0} = [
    [3,24],[3,23],[3,22],[3,21],[3,20],[3,19],[3,18],
    [3,17],[3,16],[3,15],[3,14],[3,13],
    [8,24],[8,23],[8,22],[8,21],[8,20],[8,19],[8,18],
    [8,17],[8,16], [8,15],[8,14],[8,13],
    [2,13],[4,13],[5,13],[6,13],[7,13],[9,13],
    ] ;


# 1   ----
#      ----
#     ----
#      ----
#
$Const{LAYOUT_1} = [
    [2,24],[3,24],[4,24],[5,24],[6,24],[7,24],[8,24],[9,24],[10,24],[11,24],
    [0,21],[1,21],[2,21],[3,21],[4,21],[5,21],[6,21],[7,21],[8,21],[9,21],
    [2,18],[3,18],[4,18],[5,18],[6,18],[7,18],[8,18],[9,18],[10,18],[11,18],
    [0,15],[1,15],[2,15],[3,15],[4,15],[5,15],[6,15],[7,15],[8,15],[9,15],
    [2,12],[3,12],[4,12],[5,12],[6,12],[7,12],[8,12],[9,12],[10,12],[11,12],
    ] ;


# 2    -
#     / \
#
#      -
#     / \
#
$Const{LAYOUT_2} = [
    [0,24],[1,23],[2,22],[3,21],[4,20],[5,19],
    [6,19],[7,20],[8,21],[9,22],[10,23],[11,24],
    [0,18],[1,17],[2,16],[3,15],[4,14],[5,13],
    [6,13],[7,14],[8,15],[9,16],[10,17],[11,18],
    ] ;


# 3    |
#    | | |
#  | | | | |
#  | | | | |
#
$Const{LAYOUT_3} = [
    [10,24],[10,23],[10,22],[10,21],[10,20],[10,19],[10,18],
    [8,24],[8,23],[8,22],[8,21],[8,20],[8,19],[8,18],[8,17],[8,17],
    [6,24],[6,23],[6,22],[6,21],[6,20],[6,19],[6,18],[6,17],[6,16],[6,15],
    [5,24],[5,23],[5,22],[5,21],[5,20],[5,19],[5,18],[5,17],[5,16],[5,15],
    [3,24],[3,23],[3,22],[3,21],[3,20],[3,19],[3,18],[3,17],[3,17],
    [1,24],[1,23],[1,22],[1,21],[1,20],[1,19],[1,18],
    ] ;


# 4  --- ---
#    --   --
#    -     -
#    --   --
#
$Const{LAYOUT_4} = [
    [0,21],[1,21],
    [10,21],[11,21],
    [0,18],[1,18],[2,18],
    [9,18],[10,18],[11,18],
    [0,15],[1,15],[2,15],[3,15],
    [8,15],[9,15],[10,15],[11,15],
    [0,12],[1,12],[2,12],[3,12],[4,12],
    [7,12],[8,12],[9,12],[10,12],[11,12],
    [0,24],[1,24],[2,24],[3,24],
    [8,24],[9,24],[10,24],[11,24],
    ] ;


# 5  \ /
#     -
#
#    \ /
#     -
#
$Const{LAYOUT_5} = [
    [0,19],[1,20],[2,21],[3,22],[4,23],[5,24],
    [6,24],[7,23],[8,22],[9,21],[10,20],[11,19],
    [0,13],[1,14],[2,15],[3,16],[4,17],[5,18],
    [6,18],[7,17],[8,16],[9,15],[10,14],[11,13],
    ] ;


# 6 "X"
#
$Const{LAYOUT_6} = [
    [0,24],[1,23],[2,22],[3,21],[4,20],[5,19],
    [11,24],[10,23],[9,22],[8,21],[7,20],[6,19],
    [0,13],[1,14],[2,15],[3,16],[4,17],[5,18],
    [11,13],[10,14],[9,15],[8,16],[7,17],[6,18],
    ] ;


# 7 "I"
#
$Const{LAYOUT_7} = [
    [5,23],[5,22],[5,21],[5,20],[5,19],[5,18],
    [5,17],[5,16],[5,15],[5,14],[5,13],[5,12],
    [6,23],[6,22],[6,21],[6,20],[6,19],[6,18],
    [6,17],[6,16],[6,15],[6,14],[6,13],[6,12],
    [2,12],[3,12],[4,12],[7,12],[8,12],[9,12],
    [2,24],[3,24],[4,24],[7,24],[8,24],[9,24],
    [5,24],[6,24],[5,23],[6,23],
    ] ;



# 8 "TET"
#   "RIS"
#
$Const{LAYOUT_8} = [
    [0,13],[1,13],[2,13],
    [2,14],[2,15],[1,15],
    [0,14],[0,15],[0,16],[0,17],

    [4,13],[5,13],[6,13],[7,13],
    [4,14],
    [4,15],[5,15],[6,15],
    [4,16],
    [4,17],[5,17],[6,17],[7,17],

    [9,13],[10,13],[11,13],
    [10,14],[10,15],[10,16],[10,17],

    [0,19],[0,20],[0,21],[0,22],[0,23],
    [1,19],[2,19],[3,19],
    [3,20],
    [1,21],[2,21],[3,21],
    [2,22],[3,23],

    [6,19],[6,20],[6,21],[6,22],[6,23],
    [5,19],[7,19],[5,23],[7,23],

    [9,19],[10,19],[11,19],
    [9,20],
    [9,21],[10,21],[11,21],
    [11,22],
    [9,23],[10,23],[11,23],

    ] ;


$Const{LAYOUT_MAX} = 8 ; # The index of the last layout.


1 ;


