use strict;
use XS::Install;
use Alien::cmake3;
use Env qw/@PATH/;

unless (-f 'libuv/Makefile') {
    unshift @PATH, Alien::cmake3->bin_dir;
    my $result = system(qq{cd libuv && cmake CMakeLists.txt -G "Unix Makefiles" -DCMAKE_C_FLAGS="-fPIC -O2"});
    die "FATAL: could not make libuv's Makefile\n" if $result != 0;
}

my $libs = '-lpthread';
$libs .= ' -liphlpapi -lpsapi -luserenv' if $^O eq 'MSWin32'; 

my %params = (
    NAME      => 'Alien::uv',
    CPLUS     => 11,
    LIBS      => $libs,
    BIN_SHARE => {INCLUDE => {'libuv/include' => '/'}},
    CLIB      => {
        DIR    => 'libuv',
        FILE   => 'libuv_a.a',
        TARGET => 'uv_a',
    },
    CONFIGURE_REQUIRES => {'Alien::cmake3' => 0},
);

write_makefile(%params);
