use 5.012;
use warnings;
use lib 't/lib'; use MyTest;
use UniEvent;

catch_run('[misc]');

subtest 'constants' => sub {
    cmp_ok(AF_INET + AF_INET6 + INET_ADDRSTRLEN + INET6_ADDRSTRLEN + PF_INET + PF_INET6, '>', 0);
};

subtest 'hostname' => sub {
    my $hostname = UniEvent::hostname();
    ok($hostname, "hostname: $hostname");
    
    delete local $ENV{LD_PRELOAD};
    my $sys_hostname = `hostname`;
    return if $!;
    $sys_hostname =~ s/\s+//g;
    is $hostname, $sys_hostname, "value same as 'hostname' command";
};

subtest 'get_rss' => sub {
    my $rss = UniEvent::get_rss();
    cmp_ok $rss, '>', 0, "resident set memory: $rss";
    my %aaa = map {$_ => $_} 1..100000;
    my $new_rss = UniEvent::get_rss();
    cmp_ok $new_rss, '>', $rss, "grow: $new_rss > $rss";
};

subtest 'get_free_memory' => sub {
    my $val = UniEvent::get_free_memory();
    cmp_ok $val, '>', 0, "free memory: $val";
};

subtest 'get_total_memory' => sub {
    my $val = UniEvent::get_total_memory();
    cmp_ok $val, '>', UniEvent::get_free_memory(), "total memory: $val";
};

subtest 'cpu info' => sub {
    my $cnt = UniEvent::cpu_info();
    cmp_ok $cnt, '>', 0, "we have $cnt processors";
    my @list = UniEvent::cpu_info();
    is $cnt, scalar @list, "detailed info for all $cnt processors exists";
    my $i = 0;
    foreach my $row (@list) { subtest 'CPU '.($i++) => sub {
        ok defined $row->{model}, "model $row->{model}";
        ok defined $row->{speed}, "speed $row->{speed}";
        ok defined $row->{cpu_times}{user}, "user $row->{cpu_times}{user}";
        ok defined $row->{cpu_times}{nice}, "nice $row->{cpu_times}{nice}";
        ok defined $row->{cpu_times}{sys},  "sys $row->{cpu_times}{sys}";
        ok defined $row->{cpu_times}{idle}, "idle $row->{cpu_times}{idle}";
        ok defined $row->{cpu_times}{irq},  "irq $row->{cpu_times}{irq}";
    }}
};

subtest 'interface info' => sub {
    my $cnt = UniEvent::interface_info();
    ok defined $cnt, "we have $cnt interfaces";
    return unless $cnt;
    
    my @list = UniEvent::interface_info();
    is scalar(@list), $cnt, "count ok";
    
    foreach my $if (@list) {
        subtest 'interface '.$if->{name} => sub {
            ok $if->{name}, "has name";
            ok $if->{phys_addr}, "phys_addr: ".( join ':', map { sprintf("%02X", ord($_)) } split '', $if->{phys_addr});
            ok defined $if->{is_internal}, "is_internal: $if->{is_internal}";
            isa_ok $if->{address}, "Net::SockAddr", "address: ".$if->{address}->ip;
            isa_ok $if->{netmask}, "Net::SockAddr", "netmask: ".$if->{netmask}->ip;
        };
    }
    
    my @addresses = map { $_->{address}->ip } @list;
    my $has_localhost = grep { $_ eq  '::1' || $_ eq '127.0.0.1'} @addresses;
    ok $has_localhost, "has local interface";
};

subtest 'get_rusage' => sub {
    my $rusage = UniEvent::get_rusage();
    foreach my $col (qw/utime stime maxrss ixrss idrss isrss minflt majflt nswap inblock oublock msgsnd msgrcv nsignals nvcsw nivcsw/) {
        next if $col eq 'maxrss' and netbsd();
        my $val = $rusage->{$col};
        my $name = "$col: $val";
        if ($name =~ /maxrss/) {
            cmp_ok $val, '>', 0, $name;
        } else {
            ok defined $val, $name;
        }
    }
};

subtest 'guess_type' => sub {
    # 0 is stdin ant it may be Tty for terminal and Pipe for redirected input (happens on jenkins)
    # UPDATE: and .... Fs on freebsd-vmware ???!!!!   Test disabled
    #cmp_deeply UniEvent::guess_type(0), any(UniEvent::Tty::TYPE, UniEvent::Pipe::TYPE);
    # TODO
    #is UniEvent::guess_type(*STDIN{IO}), UniEvent::TTY::TYPE;
    # for PIPE ?
    # for TCP ?
    # for UDP ?
    # for FILE ?
    ok(1);
};

done_testing();
