/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.RasterFactory;

public class SampleModelProxy
implements Serializable {
    private static final int TYPE_BANDED = 1;
    private static final int TYPE_PIXEL_INTERLEAVED = 2;
    private static final int TYPE_SINGLE_PIXEL_PACKED = 3;
    private static final int TYPE_MULTI_PIXEL_PACKED = 4;
    private static final int TYPE_COMPONENT_JAI = 5;
    private static final int TYPE_COMPONENT = 6;
    private transient SampleModel sampleModel;

    public SampleModelProxy(SampleModel sampleModel) {
        this.sampleModel = sampleModel;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int n = 6;
            int n2 = componentSampleModel.getTransferType();
            if (this.sampleModel instanceof PixelInterleavedSampleModel) {
                n = 2;
            } else if (this.sampleModel instanceof BandedSampleModel) {
                n = 1;
            } else if (this.sampleModel instanceof ComponentSampleModelJAI || n2 == 4 || n2 == 5) {
                n = 5;
            }
            objectOutputStream.writeInt(n);
            objectOutputStream.writeInt(n2);
            objectOutputStream.writeInt(componentSampleModel.getWidth());
            objectOutputStream.writeInt(componentSampleModel.getHeight());
            if (n != 1) {
                objectOutputStream.writeInt(componentSampleModel.getPixelStride());
            }
            objectOutputStream.writeInt(componentSampleModel.getScanlineStride());
            if (n != 2) {
                objectOutputStream.writeObject(componentSampleModel.getBankIndices());
            }
            objectOutputStream.writeObject(componentSampleModel.getBandOffsets());
        } else if (this.sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.sampleModel;
            objectOutputStream.writeInt(3);
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getTransferType());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getWidth());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getHeight());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getScanlineStride());
            objectOutputStream.writeObject(singlePixelPackedSampleModel.getBitMasks());
        } else if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
            objectOutputStream.writeInt(4);
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getTransferType());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getWidth());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getHeight());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getPixelBitStride());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getScanlineStride());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getDataBitOffset());
        } else {
            throw new RuntimeException(JaiI18N.getString("SampleModelProxy0"));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 2: {
                this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject());
                break;
            }
            case 1: {
                this.sampleModel = RasterFactory.createBandedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 5: {
                this.sampleModel = new ComponentSampleModelJAI(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 6: {
                this.sampleModel = new ComponentSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 3: {
                this.sampleModel = new SinglePixelPackedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject());
                break;
            }
            case 4: {
                this.sampleModel = new MultiPixelPackedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SampleModelProxy0"));
            }
        }
    }
}

