/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.csv;

import org.apache.sis.internal.storage.Capabilities;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.csv.Store;
import org.apache.sis.internal.storage.wkt.FirstKeywordPeek;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;

@Capabilities(value={Capability.READ})
public final class StoreProvider
extends URIDataStore.Provider {
    static final String NAME = "CSV";
    static final String MOVING = "CSV-MF";

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return new Peek().probeContent(storageConnector);
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new Store(this, storageConnector, false);
    }

    private static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        private static final String KEYWORD = "@stboundedby";

        private Peek() {
            super(KEYWORD.length());
        }

        @Override
        protected int isKeywordChar(int n) {
            return n == 64 ? 1 : super.isKeywordChar(n);
        }

        @Override
        protected boolean isPostKeyword(int n) {
            return n == 44;
        }

        @Override
        protected ProbeResult forKeyword(char[] cArray, int n) {
            if (n == this.maxLength && KEYWORD.equalsIgnoreCase(new String(cArray))) {
                return ProbeResult.SUPPORTED;
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

