/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.datarep;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import opennlp.common.xml.XmlUtils;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MorphItem
implements Serializable {
    private String word;
    private String stem;
    private String POS;
    private List macros;

    public MorphItem() {
    }

    public MorphItem(Element e) {
        String word = e.getAttributeValue("word");
        this.setWord(word);
        String stem = e.getAttributeValue("stem");
        if (stem == null) {
            this.setStem(word);
        } else {
            this.setStem(stem);
        }
        this.setPOS(e.getAttributeValue("pos"));
        List refs = e.getChildren("macro");
        this.macros = new ArrayList();
        int j = 0;
        while (j < refs.size()) {
            this.macros.add(((Element)refs.get(j)).getAttributeValue("ref"));
            ++j;
        }
    }

    public void setWord(String s) {
        this.word = s;
    }

    public void setStem(String s) {
        this.stem = s;
    }

    public void setPOS(String s) {
        this.POS = s;
    }

    public void setMacros(List al) {
        this.macros = al;
    }

    public String getWord() {
        return this.word;
    }

    public String getStem() {
        return this.stem;
    }

    public String getPOS() {
        return this.POS;
    }

    public List getMacros() {
        return this.macros;
    }

    public void addMacro(String s) {
        this.macros.add(s);
    }

    public void removeMacro(String s) {
        this.macros.remove(this.macros.indexOf(s));
    }

    public MorphItem copy() {
        MorphItem mi = new MorphItem();
        mi.setWord(this.word);
        mi.setStem(this.stem);
        mi.setPOS(this.POS);
        mi.setMacros(this.macros);
        return mi;
    }

    public Element createXmlElement() {
        try {
            return new SAXBuilder().build((Reader)new StringReader(this.toXml())).getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer(128);
        xml.append("  <morph word=\"").append(XmlUtils.filt2XML((String)this.word)).append("\"");
        if (!this.stem.equals(this.word)) {
            xml.append(" stem=\"").append(XmlUtils.filt2XML((String)this.stem)).append("\"");
        }
        xml.append(" pos=\"").append(XmlUtils.filt2XML((String)this.POS)).append("\"");
        if (this.macros.size() == 0) {
            xml.append("/>\n");
        } else {
            int j = 0;
            while (j < this.macros.size()) {
                xml.append("     <macro ref=\"").append(XmlUtils.filt2XML((String)((String)this.macros.get(j)))).append("\" />\n");
                ++j;
            }
            xml.append("  </morph>");
        }
        return xml.toString();
    }

    public String toString() {
        return "{" + this.word + "=>" + this.stem + " " + this.POS + " " + this.macros + "}";
    }
}

