package eBay::API::Simple;

our $VERSION = '0.15';

=head1 NAME 

eBay::API::Simple - Flexible SDK supporting all eBay web services

=head1 DESCRIPTION

This is the base class for the eBay::API::Simple::* libraries that provide
support for all of eBay's web services. This base class does nothing by itself
and must be subclassed to provide the complete web service support. 

See base class for complete docs, L<eBay::API::SimpleBase>

=item L<eBay::API::SimpleBase>

=item L<eBay::API::Simple::Merchandising>

=item L<eBay::API::Simple::Finding>

=item L<eBay::API::Simple::Shopping>

=item L<eBay::API::Simple::Trading>

=item L<eBay::API::Simple::HTML>

=item L<eBay::API::Simple::RSS>

=head1 GET THE SOURCE

http://code.google.com/p/ebay-api-simple

=head1 PUBLIC METHODS

=head2 eBay::API::Simple::{subclass}->new()

see subclass for more docs.

=item L<eBay::API::SimpleBase>

=item L<eBay::API::Simple::Merchandising>

=item L<eBay::API::Simple::Finding>

=item L<eBay::API::Simple::Shopping>

=item L<eBay::API::Simple::Trading>

=item L<eBay::API::Simple::HTML>

=item L<eBay::API::Simple::RSS>

=head1 AUTHOR

Tim Keefer <tim@timkeefer.com>

=cut
1;
