# This file was autogenerated.
use 5.008008;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Topic::Number;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.007';

=head1 NAME

Hydrogen::Topic::Number - functions from Hydrogen::Number applied to C<< $_ >>

=head1 VERSION

This documentation is for Hydrogen::Topic::Number 0.007.

=cut

=head1 FUNCTIONS

Each function implicitly operates on C<< $_ >>, expecting it to be a numeric scalar.

=cut

use Exporter::Shiny qw(
    abs
    add
    cmp
    div
    eq
    ge
    get
    gt
    le
    lt
    mod
    mul
    ne
    set
    sub
);

=head2 C<< abs() >>

Operates on C<< $_ >>, which must be a numeric scalar.

Finds the absolute value of the current number, updating the original value.

=cut

sub abs {

    package Hydrogen::Number::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for abs; usage: "
          . "Hydrogen::Topic::Number::abs()" );
    1;
    ( $_ = abs($_) );
}

=head2 C<< add( $addend ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Adds a number to the existing number, updating the original value.

=cut

sub add {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "add", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for add: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ + $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for add: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< cmp( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ <=> $num >>.

=cut

sub cmp {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "cmp", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for cmp: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ <=> $_[0];
}

=head2 C<< div( $divisor ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Divides the existing number by a number, updating the original value.

=cut

sub div {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "div", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for div: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ / $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for div: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< eq( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ == $num >>.

=cut

sub eq {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "eq", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for eq: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ == $_[0];
}

=head2 C<< ge( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ >= $num >>.

=cut

sub ge {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ge", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for ge: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ >= $_[0];
}

=head2 C<< get() >>

Operates on C<< $_ >>, which must be a numeric scalar.

Returns the current value of the number.

=cut

sub get {

    package Hydrogen::Number::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for get; usage: "
          . "Hydrogen::Topic::Number::get()" );
    $_;
}

=head2 C<< gt( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ > $num >>.

=cut

sub gt {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gt", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for gt: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ > $_[0];
}

=head2 C<< le( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ <= $num >>.

=cut

sub le {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "le", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for le: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ <= $_[0];
}

=head2 C<< lt( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ < $num >>.

=cut

sub lt {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lt", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for lt: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ < $_[0];
}

=head2 C<< mod( $divisor ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Finds the current number modulo a divisor, updating the original value.

=cut

sub mod {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "mod", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for mod: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ % $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for mod: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< mul( $factor ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Multiplies the existing number by a number, updating the original value.

=cut

sub mul {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "mul", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for mul: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ * $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for mul: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< ne( $num ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Returns C<< $_ != $num >>.

=cut

sub ne {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ne", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for ne: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    $_ != $_[0];
}

=head2 C<< set( $value ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Sets the number to a new value.

=cut

sub set {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for set: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< sub( $subtrahend ) >>

Operates on C<< $_ >>, which must be a numeric scalar.

Arguments: B<< Num >>.

Subtracts a number from the existing number, updating the original value.

=cut

sub sub {

    package Hydrogen::Number::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "sub", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Num)
        (
            do {

                package Hydrogen::Number::__SANDBOX__;
                use Scalar::Util ();
                defined( $_[0] )
                  && !ref( $_[0] )
                  && Scalar::Util::looks_like_number( $_[0] );
            }
          )
          or Hydrogen::croak(
            "Type check failed in signature for sub: %s should be %s",
            "\$_[0]", "Num" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ - $_[0];
            do {
                (
                    do {

                        package Hydrogen::Number::__SANDBOX__;
                        use Scalar::Util ();
                        defined($shv_final_unchecked)
                          && !ref($shv_final_unchecked)
                          && Scalar::Util::looks_like_number(
                            $shv_final_unchecked);
                    }
                  )
                  or Hydrogen::croak(
                    "Type check failed for sub: expected %s, got value %s",
                    "Num", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all
(this is usually a bad idea), use:

    use Hydrogen::Topic::Number -all;

To import a particular function, use:

    use Hydrogen::Topic::Number 'cmp';

To rename functions:

    use Hydrogen::Topic::Number 'cmp' => { -as => 'myfunc' };

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Number>,
L<Sub::HandlesVia::HandlerLibrary::Number>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.


