package Backup::Email::Send;
use Moose::Role;
use Carp qw/confess/;
use MIME::Lite;
use List::AllUtils qw/all/;
use Net::SMTP::TLS;
=pod

=head1 NAME

Backup::Email::Send - A role for sending e-mails.

=head1 DESCRIPTION

This role will provide sending e-mails capabilities to the class that consumes it.
It's requirements are either the class that consumes the role is Backup::Email::Config or it provides methods:

=over

=item * to()

=item * from()

=item * smtp()

=item * username()

=item * password()

=back

=head1 TODO

It should also allow for attributes instead of the methods.

=head1 BUGS

If this module has any bugs please report them to rt.cpan.org or my email.

Also if you have any suggestions on the code you are welcome to drop me an e-mail.

=head1 AUTHOR

Stefan Petrea, C<< <stefan.petrea at gmail.com> >>

=cut

#
# we are using functions generated by AUTOLOAD, it would be nice
# if we could do a require on ->to,->from,->smtp,->username,->password it would be
# very good , so that we can make at least a check for being able to compose this
# role with a particular class
#


sub BUILD {
    my $self = shift;
    confess qq/
    [ERROR]
    The class that consumes Backup::Email::Send needs to inherit
    from Backup::Email::Config as well or at least provide all of the following methods
    ->to , ->from , ->username , ->password , ->smtp
    / unless (
        $self->isa('Backup::Email::Config')
        ||
        all { $self->does($_) }
            qw/to from username password smtp/
    );
};


sub sendEmail {
	my ($self,$href) = @_;
	my $msg = MIME::Lite->new(
		From	=> "".$self->to,
		To	=> "".$self->from,
		Subject	=> $href->{subject},
		Type	=> 'application/octet-stream',
		Path	=> $href->{file},
	);
        $msg->attach(
            Type    => 'TEXT',
            Data    => $href->{body},
        );
	my $smtp_tls =  MIME::Lite::SMTP::TLS->new(
		"".$self->smtp,
		User		=> "".$self->username,
		Password	=> "".$self->password,
		Port		=> 587,
	);

	$smtp_tls->mail("".$self->from);
	$smtp_tls->to("".$self->to);

	$smtp_tls->data();
	$msg->print_for_smtp($smtp_tls);
	$smtp_tls->dataend();
}


# monkeypatching a.k.a make new 'fake' package to inject a new method in it ( ::print is needed by $msg->print_for_smtp )
@MIME::Lite::SMTP::TLS::ISA = qw( Net::SMTP::TLS );
sub MIME::Lite::SMTP::TLS::print { shift->datasend(@_) }

1;
