@seqs =qw(ADDDY
AIIASHISLPLVFHYVLMVRFLVYTKTHVGGGGGGG
ANFLLNGGGGGGG
AQAVLSMILSKQMVHL
AVTMSLTSMR
CCLLIPMFAMPQVVMSLM
CHKSTM
CHLVHLLMFVLLVAYALLH
CIRHALMQLLMPYVKRHMFVLLVAYALLH
CLFLWLKPP
CLIEIFMTNCNLQV
CLLRRIKSMI
CMLLIQLCMQLLAIYC
CPSSL
CQLLCLLAHT
CRILIMFHSNLLRVLHDAI
CTYAV
CVLR
CYPHVILIAS
DCLRRLLIHHRVLNMTMSYSHKLLKQHTLVMSTASMWLSQGQKLAFCA
DFLQVLT
DSLILQTCVLLERFLMLLNSLLSMHGREKKFLIVLLITLCSTTQHFFQPLSAMAFLPLS
ELFTLVLALIKELHQVQLCSDNGCQLAHYLSIQILMTSSPTQILL
ELLACTQHSTSQMSFLAMLQIIKRSACKSTLHSKDHLVLVRVILPSDLLSITHLLA
ELSMSTLLMSATFLLELAFVLVTIQFLYYVVLAKNLLWLILCL
ENFLHAILLGEKLFLSHLIIHRTL
ERFYLFIDGTLWFKHAHLMLLSTVKIQLVVRL
FFLMMPLCAITVTMRLKV
FILFWKKVGLSLEKTTELWFQVIFLLTTKRTCLFSYYFLLSLVVVTLTGAPLLMMFKLLITLNILHL
FLLDLAYGFTNNLILITCGIHLPGYRV
FMTIS
FQKWSRLQLTMLKFHSCFGVRMDMLKPSTQNYKQVKRGNQVLRCLTCTRCKECFLKSVTFRIMVKMLLYQKE
GELPIWKSPNV
GGFTILMKFLDQTLFI
GLILLAEKYNTWL
GLPVHLQFTAAICYHLFTSFACRCRYGGAIFVPLCLDIFSTMHQRM
GTTLGVILIALLGFVL
HLQRDQHKLASMESH
HQAAEFLLWIHITHC
HSLMLAS
IHLL
IIRILMGTGTISVISYK
ILSMPLVQRIELAP
ILVTKQHK
INALHAFQ
INEQIKMSDNGPQSNQRSAPRITFGGPTDSTDNNQNGGRNGARPKQRRPQGLPNNTASWFTALTQHGKEELRFPRGQGVPINTNSGPDDQIGYYRRATRRVRGGDGKMKELSPRWYFYYLGTGPEASLPYGANKEGIVWVATEGALNTPKDHIGTRNPNNNAATVLQLPQGTTLPKGFYAEGSRGGSQASSRSSSRSRGNSRNSTPGSSRGNSPARMASGGGETALALLLLDRLNQLESKVSGKGQQQQGQTVTKKSAAEASKKPRQKRTATKQYNVTQAFGRRGPEQTQGNFGDQDLIRQGTDYKHWPQIAQFAPSASAFFGMSRIGMEVTPSGTWLTYHGAIKLDDKDPQFKDNVILLNKHIDAYKTFPPTEPKKDKKKKTDEAQPLPQRQKKQPTVTLLPAADMDDFSRQLQNSMSGASADSTQA
INVVESYLRVRA
ISMHSTLQLSIKVHLLI
ITKSMVTLICLSPAKKLFVTFVRGLALM
IVHSQVLLLNRIATHVKCSLKSNKCTKPQL
IVICTSAEILLNVLICFSNMVAFAHN
KCYILHL
KDCQTESCSSFGRMALSLHQ
KHSLTTLRK
KHTRISQLNASKCSTKVLLHMMFHLQSTDLK
KKYSSHTIAVMMIISIRRIGMTS
KLHTLWVGIIQNVTEPCLTCLG
KLIAVASRRRMRKAIY
KMWLIMLLIKDTLMDTPAKHLFPSLIMLFTQR
KNLAHQEHTRAIHHFTLLLTINLH
KYHVAMWLHYKQKM
LALAHTLLLLVLTVLDIPISCVQDQFHQNFSSDKRRFNKSSTRHFFSLLLL
LALRTLRQFFIIKIMCSCLRQNVGLRLTLLKDLTNFAHSIQC
LDFLRTVVRSLLVFILHRHLHTSALI
LEQASFTVAGIIC
LETVQQYIRLINGTLLLAICMTLGPNM
LGHWLLSPIWMLISQNHLLSGIC
LGLTILASRRNKLMAIPCMLTTFSGGTQILSSCLPIHSLT
LGVGTFMKVTKLLHLETYLLF
LHLEQMLHLKLLFYIKMLTALMFLQQFMQINSHQLGAYILLETMYSRLKQAVL
LIFYLMTLSR
LKGSCHWLLMLTHLQNILIRSMLMSFTCIYNTLESYMMSLLATCWTCIP
LKIVKYRLESTPLKKVTMVMLLCTEVLRHTS
LKLLINTLIVTMVAVLMPTK
LLFVLFSLSAIPCFNNAYYILVFTRNPGSRRTLYQSLNEHETSHCFDLYFSMQLHMHCSTALCI
LLGFYLPRKSQPTSISCRSVL
LLLQRDFNHFNNLAVMFLISLIPFEILKHLKY
LLLTILLMLLYEHVTLNCVTTLSLLFLNPWVHRHIL
LLQTIHLSQEIVMSLLASLTTQFMILCNLSSTHSKKSWTSTSKIIHHQMLILATFQALTLLSSTFKKKLTASMRSLKI
LMFSSGALRVTFRVTMTNIARYMEMHMWLVVMLS
LMITPHGTGNLSFMRLCTHHIQSCRL
LNKEMITCTCLTQIHQEY
LNTQWLI
LPGYNSRDIDYHYEDFQDCYLES
LPSSWLQSCFVA
LQADFKAFKPM
LRGILCLTTNMKRLFITWLKIVQRLLSMTFSSLE
LRIYFFHFILMLQGFILLIIRLATLSYLLRMVFILLPQRNQMLSVVGFLVLP
LTLISHSNL
LTLPRNLLRVLVLHLLSCLMVEWKDR
LTSMSAIYNTGSMSVSIEIGMLIMNSWMSFTLTCVNISP
LTSVRKY
LVSLSVVL
LVVAVASRVHALVVLAASLMRMTLSQFSRVSNYITHKRTYGFVYEIFYSWINYCTASKN
LVVLPLLDGHLVLALLFKYLLLCKWHIGSMALELPKMFSMRTKNKSPTNLTRRLVKFKNHLQQHQLHWASCKTLLTRMLKH
LYLHLASYITIRSVLEVRLYY
LYRLVMLTLKITQNSPELMQNLHQVTSLNILYHSCIKACPGM
MFVLLVAYALLHMHCQKQLLTL
MFVLLVAYALLHMHFFQLMVIR
MFVLLVAYALLHMHHHRKHF
MHRPRFVDQNYPLTLLRTSVSILILMDSLVLVC
MIFASPMSMQILL
MIMVFTPLLALATNLTEL
MISFRDLIKSRRRYKLTG
MNHSLTFKNWENMSNILNGLGMFGSASLLD
MSQSILNCVNT
MVFLLLFQLDTIFVS
MVLMWRSLKIRQHFLLMLHLSFGLSVTLNQCQRLRYSIIWVLISLLIL
MVTWYHIYHVSV
NGSSTMLSHVVTKLTK
NILVVLIFHKYYLTL
NLFLSCLLVLTLQILEPFLQPFHLLKTFGARQLQPILLAI
NMILRKRDFVSSTVILNIGTRHTIPIVLTVWMIGVSFIVQTLMCYFLLCFHLQVLDH
NQNILIQCADL
NSMFSAL
NTSSLLRMATLLSVIMTIIVIICQQCVISDNSYS
NYYEMLALLEVQIQEPITL
PPLEELLW
QCFSCKYCSCYSNDTATSLTPFRMACYWRCISCCFSERYQNNCAQ
QHVIGLMLAITYLPTLVLRDSSFSQQKRSKPLRKHLSCHMVLLLYAKYSLTENCIFHGRLENLDHH
QMRKQVHQNVCVL
QSILGMLTFTSLWAISHGGQLLLQM
QSMSALLSALIGLLNTLL
QTMLLFKLSNPVILIKTFMTLLCLKVSLRKEVLLN
RAVMQLEMLWVLTYLSS
REFSKTNGLRLLAC
RHFNTKTQRRLPNWWLF
RILSLWTAQ
RILSPDHKWKLTFSSSLWMNSYSDISSRAMPSNTSFMEISVMDNLAVFI
RILTSYAYMLT
RLCRCTWLFHRSLLPA
RLYNSAMLCVMQAL
RPTECANTHNRRLFRSC
RQDKLVLLLIIIINCQMISWVVSLLGILGTLMLLQLVIIIINIGILDMASLGPLRETYLMCLSPLMANLAPHLLLIVIGH
RSSSILMLHITINSLMVFVCFGIVTLIVTQPMQLCVGLTQEPCQT
RTSFSCFRGILASHTSHPYCASIVCVLLQYC
RTYGVRLSIKRT
RYNKFNSETII
SGLLKSGLLLILLLLKCLSVFLDNQKELTFVERATTLCPSHKQPRMVLSSYMSRMCHPRRGTSPQRQQFVMKAKHTSLVKVFLCLMALLGLLHRGTSFLHK
SGTTKEKPQHMYLQ
SLHCLLISFQFFMTLEIQRLSSVCLRLK
SLMKSLWLLIMT
SLTIWINQLVSHLINGVRLDFIMTQ
SMCNIREDLKEPPHFHRGHAEYDRGYSE
SMLYVILMRVIVIH
SNCLSFTILIVLVSLMANK
SQLHLCSSMMKMVQSQMLLIVLKIHLLNSNALLRALRLTKEFTRPLISGLFPQEML
SQLRGLLLRTCSLIR
SSGLNELTIIIILFGTLTLLIMADNGTITVEELKQLLEQWNLVIGFLFLAWIMLLQFAYSNRNRFLYIIKLVFLWLLWPVTLACFVLAAVYRINWVTGGIAIAMACIVGLMWLSYFVASFRLFARTRSMWSFNPETNILLNVPLRGTIVTRPLMESELVIGAVIIRGHLRMAGHPLGRCDIKDLPKEITVATSRTLSYYKLGASQRVGTDSGFAAYNRYRIGNYKLNTDHAGSNDNIALLVQ
SSRLKDYVLTYQAYQRT
STLSRLDLKERVVCVTNVQLAFLLHQILMPAGIILWVLTMSITHL
TALFNSCLKPTLLRAET
TETMSLLVTV
TFHLALLGV
TFLETPVMVF
TFSQFRLRYIVYSCAE
THLLNNLALILVQFQVC
TIINFTVVDKKRVTRPSSADCLRFRPCCSRSSAYLGFVRV
TLMMTTQGRWAM
VLIVQLLTLITPLLYLLTFQLALLQK
VLSMLDFVQNTTSILAILLNYQPPAHC
VLVYCAIHRLHFVAVPVLGDHSYVASAAMTMSFQHHTN
VMRIKMHFSRILSVMSSLL
VQPVLHRAAQALVLMSSTGLLIFTTKKLLVLQSS
VQTCSLELVAVVLLKLLTL
VRTYVLIRFGRNRYVNS
VRWSCVAAHYMLNQVEHHPVMLQLLMLIVSLTFVKLLQPM
VVLFADTMQMSTDSTWMHII
VYTNYYRHWY
WPLLFLLANITLAVTYHTVSTG
YFASPLRERQNE
YFLLNF
	  YKCSVIH);

use Test;
BEGIN { plan tests => 11 };

$len = 50000;
$num = 5;
$wd = './wd';
sub echo { printf("%-45s ... ", $_[0]) }


# ----------------------------------------------------------------------

use Bio::Tools::Prepeat qw(random_sequence);
use Data::Dumper;

print "\n--- Protein sequence test ---\n";
echo "Initiating object";
my $p = Bio::Tools::Prepeat->new( wd => $wd );
ok(1);


echo "Feeding sequences";
$p->feed(@seqs);
#$p->feed(random_sequence($len)) for 1..$num;
ok(1);

echo "Building index";
$p->buildidx();
ok(1);

echo "Resetting object";
$p->reset();
ok(1);

echo "Loading index";
$p->loadidx();
ok(1);



echo "Querying";
my $r = $p->query(7);
ok($r->{'GGGGGGG'}->[0]->[0], 1);

echo "Querying";
my $r = $p->query(14);
ok($r->{'MFVLLVAYALLHMH'}->[0]->[0], 97);

echo "Checking sequence file";
ok(-s "$wd/seqs");

echo "Checking repeats file";
ok(-s "$wd/result");

echo "Cleaning index";
$p->cleanidx();
ok(!-e $wd);

echo "Generating random protein sequence";
ok(length($p->random_sequence(1000000).random_sequence(100000)), 1100000);


# ----------------------------------------------------------------------

