#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	breakchar

#ifdef PDCDEBUG
char *rcsid_breakcha = "$Header: c:/curses/nonport/RCS/breakcha.c%v 2.0 1992/11/15 03:18:25 MH Rel $";
#endif




/*man-start*********************************************************************

  breakchar()	- Return's user's current break character.

  PDCurses Description:

 	This routine will return the current BREAK char.  This is a
 	routine and not a macro in anticipation of providing
 	user-specified BREAK chars.

  PDCurses Return Value:
 	The character value that is the user's current break
 	character.  This is currently hardcoded, but provided in
 	anticipation of providing support for a user defined break char.

  PDCurses Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	char	breakchar(void);
 	BSD Curses
 	SYS V Curses
**man-end**********************************************************************/

char	breakchar(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("breakchar() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	ioctl(_CUR_TERM.fd, TCGETA, &_CUR_TERM.prog_mode);
	return(_CUR_TERM.prog_mode.c_cc[VINTR]);
#else
#ifdef TIOCGETC
	ioctl(_CUR_TERM.fd, TIOCGETC, &_CUR_TERM.prog_mode.v7);
	return(_CUR_TERM.prog_mode.v7.t_intrc);
#else
	return(0);
#endif
#endif
#else
	return(_BCHAR ); /* Control C */
#endif
}
