#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	waddeawstr

#ifdef PDCDEBUG
char *rcsid_waddraws = "$Header: c:/curses/nonport/RCS/waddraws.c%v 2.0 1992/11/15 03:18:29 MH Rel $";
#endif




/*man-start*********************************************************************

  waddrawstr()	- add raw string to window

  PDCurses Description:
 	The *raw*() routines output 8 bit values.  These contrast to their
 	normal counterparts which output 7 bit values and convert control
 	character to the ^X notation.

 	str is a standard 8 bit character string WITHOUT embedded attributes.

  PDCurses Return Value:
 	The waddrawstr() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int waddrawstr( WINDOW* win, char* str );

**man-end**********************************************************************/

int	waddrawstr(WINDOW *win, char *str)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("waddrawstr() - called: string %s\n",str);
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	while (*str)
	{
		if (waddrawch(win, *str++) == ERR)
		{
			return( ERR );
		}
	}
	return( OK );
}
