#ifndef NO_MEMORY_H
#define	CURSES_LIBRARY	1
#endif
#include <curses.h>
#undef	winPDC_print

#ifdef PDCDEBUG
char *rcsid_winprint = "$Header: c:/curses/nonport/RCS/winprint.c%v 2.0 1992/11/15 03:18:31 MH Rel $";
#endif




#define PRINT	0
#define INIT	1
#define READ	2

/*man-start*********************************************************************

  win_print()	- print contents of window to LPT1

  PDCurses Description:
 	Prints the contents of the passed window or pad to LPT1:.  All
 	attributes are ignored.	 Newlines will be appended to the end
 	of all win->_y[]s.  The caller must supply the compiler-
 	dependent port number.

  PDCurses Return Value:
 	Return Status:	bit 0	0x01	Device Time Out
 			bit 1	0x02	Bad WINDOW* passed
 			bit 2	0x04	Unable to malloc memory
 			bit 3	0x08	I/O Error
 			bit 4	0x10	Selected
 			bit 5	0x20	Out of paper
 			bit 6	0x40	Acknowledge
 			bit 7	0x80	Not Busy

 	A return value of 0 indicates success.

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.

  Portability:
 	PDCurses	int win_print( WINDOW* win, int port );

**man-end**********************************************************************/

int	win_print(WINDOW *win, int port)
{
#if	defined( DOS )
extern	void*	(*mallc)();		/* ptr to some malloc(size)	*/
extern	void*	(*callc)();		/* ptr to some ecalloc(num,size)*/
extern	void	(*fre)();		/* ptr to some free(ptr)	*/
	char   *text;
	int	i;
	int	j;
	int	status;
	int	retry = 0;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("win_print() - called\n");
#endif

#if	defined( DOS )
	if (win == (WINDOW *)NULL)
		return( 0x02 );

	status = PDC_print(READ, 0, port);

	if (((status & 0x20) != 0) || ((status & 0x08) != 0))
		return( status );
	/*
	 * Print the window title First
	 */
	text = win->_title;
	while (text != (char *)NULL)
	{
		status = PDC_print(PRINT, (int) *text, port);
		while ((status & 0x80) == 0x00)
		{
			if ((status & 0x01) == 0x01)
			{
				retry++;
				if (retry > 10)
					return( status );
			}
			if (((status & 0x20) == 0x20) ||
			    ((status & 0x10) == 0x00) ||
			    ((status & 0x08) == 0x08))
			{
				return( status );
			}
			status = PDC_print(READ, 0, port);
		}
	}
	PDC_print(PRINT, '\r', port);
	PDC_print(PRINT, '\n', port);
	PDC_print(PRINT, '\n', port);
	text = (*mallc)(win->_maxx);
	if (text != (char *)NULL)
	{
		for (i = 0; i < win->_maxy; i++)
		{
			for (j = 0; j < win->_maxx; j++)
			{
				status = PDC_print(PRINT, (int) win->_y[i][j], port);
				while ((status & 0x80) == 0x00)
				{
					if ((status & 0x01) == 0x01)
					{
						retry++;
						if (retry > 10)
						{
							(*fre)(text);
							return( status );
						}
					}
					if (((status & 0x20) == 0x20) ||
					    ((status & 0x10) == 0x00) ||
					    ((status & 0x08) == 0x08))
					{
						(*fre)(text);
						return( status );
					}

					status = PDC_print(READ, 0, port);
				}
				retry = 0;

			}
			PDC_print(PRINT, '\r', port);
			PDC_print(PRINT, '\n', port);
		}
		PDC_print(PRINT, '\f', port);
		(*fre)(text);
		return( 0x00 );
	}
	return( 0x04 );
#endif

#if	defined( HC ) && defined( FLEXOS )
	return( 0x03 );
#endif

#ifdef OS2
	return( 0x03 );
#endif
}
