#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	wordchar

#ifdef PDCDEBUG
char *rcsid_wordchar = "$Header: c:/curses/nonport/RCS/wordchar.c%v 2.0 1992/11/15 03:18:31 MH Rel $";
#endif




/*man-start*********************************************************************

  wordchar()	- returns the users word delete char

  PDCurses Description:
 	This routine returns the user's current word delete char.

 	At the present time, this is still a constant, but positions
 	the library to more fully support this in the future.

  PDCurses Errors:
 	The wordchar returns the user's current delete word character.
 	If none is specified, then Ctrl-U is returned.

  Portability:
 	PDCurses	char wordchar( void );
 	SysV Curses	
 	BSD Curses	

**man-end**********************************************************************/

char	wordchar(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wordchar() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	ioctl(_CUR_TERM.fd, TCGETA, &_CUR_TERM.prog_mode);
	return(_CUR_TERM.prog_mode.c_cc[VWERASE]);
#else
#ifdef TIOCGLTC
	ioctl(_CUR_TERM.fd, TIOCGLTC, &_CUR_TERM.prog_mode.bsd_new);
	return(_CUR_TERM.prog_mode.bsd_new.t_werase);
#else
	return(0);
#endif
#endif
#else
	return (_DWCHAR);			/* word delete char */
#endif
}
