#define	CURSES_LIBRARY	1
#include <curses.h>
#ifdef UNIX
#include <defs.h>
#include <term.h>
#endif
#undef curs_set

#ifdef PDCDEBUG
char *rcsid_curs_set = "$Header: c:/curses/portable/RCS/curs_set.c%v 2.0 1992/11/15 03:29:14 MH Rel $";
#endif


/*man-start*********************************************************************

  curs_set()	- set visibility of cursor.

  X/Open Description:
 	This routine is used to set the visibility of the cursor. The cursor
 	can be made invisible, normal or highly visible by setting the
 	parameter to 0, 1 or 2 respectively. If an invalid value is passed
 	the function will set the cursor to "normal".

  X/Open Return Value:
 	curs_set returns the previous visibility value.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int curs_set( int visibility );
 	SYS V Curses	int curs_set( int visibility );

**man-end**********************************************************************/

int	curs_set(int visibility)
{
#ifdef OS2
 VIOCURSORINFO pvioCursorInfo;
#endif
 int start,end,hidden=0;
 static int old_vis=1;
 int ret_vis;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("curs_set() - called: visibility=%d\n",visibility);
#endif

	ret_vis = old_vis;
	old_vis = visibility;
#ifdef UNIX
	switch(visibility)
	{
		case 0:  /* invisible */
			if (cursor_invisible != NULL)
				putp(cursor_invisible);
			break;
		case 2:  /* highly visible */
			if (cursor_visible != NULL)
				putp(cursor_visible);
			break;
		default:  /* normal visibility */
			if (cursor_visible != NULL)
				putp(cursor_visible);
			break;
	}
	return(OK);
#else

	switch(visibility)
	{
		case 0:  /* invisible */
#ifdef OS2
			start = _cursvar.font / 4;
			end = _cursvar.font;
#else
			start = 32;
			end = 33;
#endif
			hidden = (-1);
			break;
		case 2:  /* highly visible */
			start = 2;   /* almost full-height block */
			end = _cursvar.font-1;
			break;
		default:  /* normal visibility */
			start = _cursvar.font - 4;
			end = _cursvar.font-1;
			break;
	}

#ifdef OS2
	pvioCursorInfo.yStart = (USHORT)start;
	pvioCursorInfo.cEnd = (USHORT)end;
	pvioCursorInfo.cx = (USHORT)1;
	pvioCursorInfo.attr = hidden;
	VioSetCurType((PVIOCURSORINFO)&pvioCursorInfo,0);
#endif

#ifdef DOS
	regs.h.ah = 0x01;
	regs.h.al = (unsigned char)_cursvar.scrnmode;  /* if not set, some BIOSes hang */
	regs.h.ch = (unsigned char)start;
	regs.h.cl = (unsigned char)end;
	int86(0x10, &regs, &regs);
#endif
	return( ret_vis );
#endif
}
