#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	mvcur

#ifdef PDCDEBUG
char *rcsid_mvcur = "$Header: c:/curses/portable/RCS/mvcur.c%v 2.0 1992/11/15 03:29:00 MH Rel $";
#endif




/*man-start*********************************************************************

  mvcur()	- low-level cursor movement

  Ultrix 4.1 Description:
 	This function controls low-level cursor motion with optimization.

  PDCurses Description:
 	There is no optimization here since the PC has memory mapped
 	video and we support, under certain compilation options, direct
 	video writes.

  PDCurses Return Value:
 	The mvcur() function returns OK on success and ERR on error.

  PDCurses Errors:
 	If the new cursor position is outside the physical screen size,
 	an error occurs.

  Portability:
 	PDCurses	int mvcur(int oldrow,int oldcol,int newrow,int newcol);
 	BSD Curses	int mvcur(int oldrow,int oldcol,int newrow,int newcol);
 	SYS V Curses	int mvcur(int oldrow,int oldcol,int newrow,int newcol);

**man-end**********************************************************************/

int	mvcur(int oldrow, int oldcol, int newrow, int newcol)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("mvcur() - called: oldrow %d oldcol %d newrow %d newcol %d\n",oldrow,oldcol,newrow,newcol);
#endif

#ifdef	TC
#  pragma argsused
#endif
	if ((newrow >= LINES)	||
	    (newcol >= COLS)	||
	    (newrow < 0)	||
	    (newcol < 0))
	{
		return( ERR );
	}
	PDC_gotoxy( newrow, newcol );
	_cursvar.cursrow = newrow;
	_cursvar.curscol = newcol;
	return( OK );
}
