#include <stdarg.h>
#include <string.h>
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	mvwprintw

#ifdef PDCDEBUG
char *rcsid_mvwprint = "$Header: c:/curses/portable/RCS/mvwprint.c%v 2.0 1992/11/15 03:29:32 MH Rel $";
#endif





/*man-start*********************************************************************

  mvwprintw()	- formatted write to a window

  X/Open Description:
 	The printw routine adds a string to the default window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by addstr.

 	The routine wprintw adds a string to the specified window
 	starting at the current cursor position.  This routine causes
 	the string that would normally be output by printf to be
 	output by waddstr.

 	The routine mvprintw adds a string to the default window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by addstr.

 	The routine mvwprintw adds a string to the specified window
 	starting at the specified cursor position.  This routine
 	causes the string that would normally be output by printf to
 	be output by waddstr.

 	All these routines are analogous to printf.  It is advisable
 	to use the field width options of printf to avoid leaving
 	unwanted characters on the screen from earlier calls.

  PDCurses Description:
 	The old Bjorn Larssen code for the 68K platform has been removed
 	from this module.

  X/Open Return Value:
 	The mvprintw() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int mvwprintw(WINDOW* win, int y, int x, char *fmt, ...)
 	X/Open Dec '88	int mvwprintw(WINDOW* win, int y, int x, char *fmt, ...)
 	BSD Curses	int mvwprintw(WINDOW* win, int y, int x, char *fmt, ...)
 	SYS V Curses	int mvwprintw(WINDOW* win, int y, int x, char *fmt, ...)

**man-end**********************************************************************/

int	mvwprintw(WINDOW * win, int y, int x, char *fmt, ...)
{
	int	retval = ERR;
	va_list args;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("mvwprintw() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return (retval);

	if (wmove(win, y, x) == ERR)
		return (retval);

	va_start(args, fmt);
	vsprintf(c_printscanbuf, fmt, args);
	va_end(args);

	if (waddstr(win, c_printscanbuf) == ERR)
		return (retval);
	retval = (strlen(c_printscanbuf));
	return (retval);
}
