#include <stdlib.h>
#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	newterm

#ifdef PDCDEBUG
char *rcsid_newterm = "$Header: c:/curses/portable/RCS/newterm.c%v 2.0 1992/11/15 03:29:03 MH Rel $";
#endif

#if	EMALLOC
void*	emalloc( size_t );
void*	ecalloc( size_t, size_t );
void	efree( void* );
#endif




#if 0
/*man-start*********************************************************************

  newterm()	- open new terminal

  X/Open Description:
 	A program which outputs to more than one terminal should use
 	for each terminal instead of initscr().  The newterm() function
 	should be called once for each terminal.  It returns a value of
 	type SCREEN* which should be saved as a reference to that terminal.
 	The arguments are the type of of terminal to be used in place of
 	TERM (environment variable), a file pointer for output to the
 	terminal and another file pointer for input from the terminal.  The
 	program must also call endwin() for each terminal no longer being
 	used.

  PDCurses Description:
 	This routine is a quick hack.  It is basically a copy of initscr()
 	with the appropriate arguments being passed.  There is no formal
 	support yet for dual monitor systems.  This is almost, but not
 	quiet, a NOP.

 	outfd and infd are ignored, but required for portability.

  X/Open Return Value:
 	The newterm() function returns stdscr on success otherwise ERR is
 	returned.

  X/Open Errors:
 	No errors are defined for this function.

  PDCurses Errors:
 	It is an error to open the same SCREEN more than once.

  Portability:
 	PDCurses	SCREEN* newtern( char* type, FILE outfd, FILE infd );
 	X/Open Dec '88	SCREEN* newtern( char* type, FILE outfd, FILE infd );
 	BSD Curses	
 	SYS V Curses	SCREEN* newtern( char* type, FILE outfd, FILE infd );

**man-end**********************************************************************/

SCREEN*	newterm( char *type, FILE *outfd, FILE *infd )
{
#ifdef	TC
#  pragma argsused
#endif
extern	void*	mallc();	/* malloc(size)		*/
extern	void*	callc();	/* calloc(num,size)	*/
extern	void	fre();		/* free(ptr)		*/

extern	void*	malloc();
extern	void*	calloc();
extern	void	free();

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("newterm() - called\n");
#endif

	if  (_cursvar.alive)
		return( ERR );

	if  (_cursvar.emalloc == EMALLOC_MAGIC)
	{
#if	EMALLOC
		memset(&_cursvar, 0, sizeof(SCREEN));
		_cursvar.emalloc = TRUE;
		mallc = emalloc;
		callc = ecalloc;
		fre   = efree;
#endif
	}
	else
	{
		memset(&_cursvar, 0, sizeof(SCREEN));
		mallc = malloc;
		callc = calloc;
		fre   = free;
	}
	PDC_scr_open(&_cursvar, 0);
	_cursvar.orig_cursor = _cursvar.cursor;
	_cursvar.orig_font = PDC_get_font();
	_cursvar.orgcbr = PDC_get_ctrl_break();
	_cursvar.blank = ' ';
#ifdef	FLEXOS
	_flexos_16bitmode();
#endif
	savetty();
	LINES = PDC_get_rows();
	COLS = PDC_get_columns();

	if ((curscr = newwin(LINES, COLS, 0, 0)) == (WINDOW *) ERR)
	{
		return( ERR );
	}
	if ((stdscr = newwin(LINES, COLS, 0, 0)) == (WINDOW *) ERR)
	{
		return( ERR );
	}
	curscr->_clear = FALSE;
#ifdef	REGISTERWINDOWS
	_cursvar.refreshall = FALSE;
	_inswin(stdscr, (WINDOW *)NULL);
#endif
	_cursvar.alive = TRUE;
	return( &_cursvar );
}
#endif
