#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef	noecho

#ifdef PDCDEBUG
char *rcsid_noecho = "$Header: c:/curses/portable/RCS/noecho.c%v 2.0 1992/11/15 03:29:05 MH Rel $";
#endif




/*man-start*********************************************************************

  noecho()	- enable/disable terminal echo

  X/Open Description:
 	These functions control whether characters typed by the user
 	are echoed by the input routine.  Initially, input characters
 	are echoed.  Subsequent calls to echo() and noecho() do not
 	flush type-ahead.

  PDCurses Description:
 	No additional PDCurses functionality.

  X/Open Return Value:
 	The noraw() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int noecho( void );
 	X/Open Dec '88	int noecho( void );
 	BSD Curses	int noecho( void );
 	SYS V Curses	int noecho( void );

**man-end**********************************************************************/

int	noecho(void)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("noecho() - called\n");
#endif

#ifdef UNIX
#ifdef USE_TERMIO
	_CUR_TERM.prog_mode.c_lflag &= ~(ECHO|ECHOPRT);
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#else
	_CUR_TERM.prog_mode.sg_flags &= ~ECHO;
	ioctl(_CUR_TERM.fd, TIOCSETP, &_CUR_TERM.prog_mode);
#endif
#endif

	_cursvar.echo = FALSE;
	return( OK );
}
