#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	pnoutrefresh

#ifdef PDCDEBUG
char *rcsid_pnoutref = "$Header: c:/curses/portable/RCS/pnoutref.c%v 2.0 1992/11/15 03:29:14 MH Rel $";
#endif




/*man-start*********************************************************************

  pnoutrefresh()	- refresh pad without updating physical screen

  X/Open Description:
 	The prefresh routine copies the specified pad to the physical
 	terminal screen.  It takes account of what is already
 	displayed on the screen to optimize cursor movement.

 	The pnoutrefresh routine copies the named pad to the virtual
 	screen. It then compares the virtual screen with the physical
 	screen and performs the actual update.

 	These routines are analogous to the routines wrefresh and
 	wnoutrefresh except that pads, instead of windows, are
 	involved.  Additional parameters are also needed to indicate
 	what part of the pad and screen are involved. The upper left
 	corner of the part of the pad to be displayed is specified by
 	py and px.  The coordinates sy1, sx1, sy2, and sx2 specify the
 	edges of the screen rectangle that will contain the selected
 	part of the pad.

 	The lower right corner of the pad rectangle to be displayed is
 	calculated from the screen co-ordinates.  This ensures that
 	the screen rectangle and the pad rectangle are the same size.

 	Both rectangles must be entirely contained within their
 	respective structures.

  PDCurses Description:
 	Contrary to the statements above, the pnoutrefresh() routine
 	will not perform an update to the physical screen.  This task
 	is performed by doupdate().

  X/Open Return Value:
 	The prefresh() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a null WINDOW* pointer.

  Portability:
 	PDCurses	int pnoutrefresh( WINDOW* w, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	X/Open Dec '88	int pnoutrefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	SYS V Curses	int pnoutrefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );

**man-end**********************************************************************/

int	pnoutrefresh(WINDOW* w,int py,int px,int sy1,int sx1,int sy2,int sx2)
{
	WINDOW*		s = curscr;
	int		sline = sy1;
	int		pline = py;
	int		num_cols = min((sx2-sx1+1),(w->_maxx-px));

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("pnoutrefresh() - called\n");
#endif


	if (w == (WINDOW *)NULL)
		return( ERR );

	while (sline <= sy2)
	{
		if (pline < w->_maxy)
		{
			memcpy(&(s->_y[sline][sx1]),
			       &(w->_y[pline][px]),
			       (num_cols) * sizeof(chtype));

			if ((s->_firstch[sline] == _NO_CHANGE) ||
			    (s->_firstch[sline] > sx1))
			{
				s->_firstch[sline] = sx1;
			}

			if (sx2 > s->_lastch[sline])
				s->_lastch[sline] = sx2;

			w->_firstch[pline] = _NO_CHANGE;  /* updated now */
			w->_lastch[pline] = _NO_CHANGE;  /* updated now */
		}
		sline++;
		pline++;
	}

	if (w->_clear)
	{
		w->_clear = FALSE;
		s->_clear = TRUE;
	}

/* position the cursor to the pad's current position if possible */
	if (!w->_leave)
	{
/* is the pad current position going to end up displayed ? if not */
/* then don't move the cursor, if so move it to the correct place */
		if (w->_cury >= py
		&&  w->_curx >= px
		&&  w->_cury <= py + (sy2 - sy1+1)
		&&  w->_curx <= px + (sx2 - sx1+1))
			{
				s->_cury = (w->_cury - py) + sy1;
				s->_curx = (w->_curx - px) + sx1;
			}
	}
	return( OK );
}
