#define CURSES_LIBRARY	1
#include <curses.h>

#ifdef UNIX
#define NOTLIB
#include <defs.h>
#include <term.h>
#endif
#undef  raw

#ifdef PDCDEBUG
char *rcsid_raw = "$Header: c:/curses/portable/RCS/raw.c%v 2.0 1992/11/15 03:29:25 MH Rel $";
#endif




/*man-start*********************************************************************

  raw()	- enable raw mode

  X/Open Description:
        The terminal in placed into or out of raw mode.  Raw mode is
        similar to cbreak mode, in that characters typed are immediately
        passed through to the user program.  The differences are that in
        raw mode, the INTR, QUIT, SUSP, and STOP characters are passed
        through without being interpreted, and without generating a
        signal.  The behaviour of the BREAK key depends on other
        parameters of the terminal drive that are not set by curses.

  PDCurses Description:
        Raw mode in the traditional sense refers to input handling.
        Contrast raw_output() which enables 8bit characters.

        FYI:	PDCurses does NOT provide signal(3) support,
 		this must be done by the application.

  X/Open Return Value:
        This function returns OK on success and ERR on error.

  X/Open Errors:
        No errors are defined for this function.

  Portability:
        PDCurses        int raw( void );
        X/Open Dec '88  int raw( void );
        BSD Curses      int raw( void );
        SYS V Curses    int raw( void );

**man-end**********************************************************************/

int     raw(void)
{
#ifdef OS2
	KBDINFO KbdInfo;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("raw() - called\n");
#endif

#ifdef OS2
	KbdGetStatus(&KbdInfo,0);
	KbdInfo.fsMask |= KEYBOARD_BINARY_MODE;
	KbdInfo.fsMask &= ~KEYBOARD_ASCII_MODE;
	KbdSetStatus(&KbdInfo,0);
#endif

#ifdef UNIX
#ifdef USE_TERMIO
#if 0
	_CUR_TERM.prog_mode.c_lflag &= ~(ICANON|ISIG);
	_CUR_TERM.prog_mode.c_iflag &= ~(INPCK|ISTRIP|IXON);
	_CUR_TERM.prog_mode.c_oflag &= ~(OPOST);
	_CUR_TERM.prog_mode.c_cc[VMIN] = 1;
	_CUR_TERM.prog_mode.c_cc[VTIME] = 0;
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#endif
	_CUR_TERM.prog_mode.c_lflag &= ~(ICANON|ISIG);
	_CUR_TERM.prog_mode.c_iflag &= ~(IXON);
	_CUR_TERM.prog_mode.c_iflag |= ICRNL;
	ioctl(_CUR_TERM.fd, TCSETAW, &_CUR_TERM.prog_mode);
#else
	_CUR_TERM.prog_mode.sg_flags |= RAW;
	ioctl(_CUR_TERM.fd, TIOCSETP, &_CUR_TERM.prog_mode);
#endif
#endif

	_cursvar.raw_inp = TRUE;
	PDC_set_ctrl_break(FALSE);      /* disallow ^BREAK on disk I/O */
/*	flushinp(); */
	return( OK );
}
