#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wdeleteln

#ifdef PDCDEBUG
char *rcsid_wdeletel = "$Header: c:/curses/portable/RCS/wdeletel.c%v 2.0 1992/11/15 03:29:06 MH Rel $";
#endif




/*man-start*********************************************************************

  wdeleteln()	- remove line from window

  X/Open Description:
 	The line under the cursor in the window is deleted.  All
 	lines below the current line are moved up one line.  The
 	bottom line of the window is cleared.  The cursor position
 	does not change.

 	NOTE: deleteln() is a macro.

  PDCurses Description:
 	No additional functionality.

  X/Open Return Value:
 	The wdeleteln() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a NULL window pointer to this routine.

  Portability:
 	PDCurses	int wdeleteln( WINDOW* win );
 	X/Open Dec '88	int wdeleteln( WINDOW* win );
 	BSD Curses	int wdeleteln( WINDOW* win );
 	SYS V Curses	int wdeleteln( WINDOW* win );

**man-end**********************************************************************/

int	wdeleteln(WINDOW *win)
{
	chtype	blank;
	chtype*	end;
	chtype*	temp;
	int	y;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wdeleteln() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	blank	= win->_blank | win->_attrs;
	temp	= win->_y[win->_cury];

	for (y = win->_cury; y < win->_bmarg; y++)
	{
		win->_y[y]	 = win->_y[y + 1];
		win->_firstch[y] = 0;
		win->_lastch[y] = win->_maxx - 1;
	}

	win->_firstch[y]		= 0;
	win->_lastch[y]		= win->_maxx - 1;
	win->_y[win->_bmarg]	= temp;

	for (end = &(temp[win->_maxx - 1]); temp <= end;)
	{
		*temp++ = blank;
	}
	return( OK );
}
