#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	winsert

#ifdef PDCDEBUG
char *rcsid_winsertl = "$Header: c:/curses/portable/RCS/winsertl.c%v 2.0 1992/11/15 03:29:09 MH Rel $";
#endif




/*man-start*********************************************************************

  winsert()	- Insert line

  X/Open Description:
 	A blank line is inserted above the current line and the bottom
 	line is lost.

 	NOTE: insertln() is a macro.

  PDCurses Description:
 	The mv[w]insertln() routines have been added to the X/Open
 	interface specification as a convienience.

  X/Open Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int winsertln( WINDOW* win );
 	X/Open Dec '88	int winsertln( WINDOW* win );
 	BSD Curses	int winsertln( WINDOW* win );
 	SYS V Curses	int winsertln( WINDOW* win );


**man-end**********************************************************************/

int	winsertln(WINDOW *win)
{
	chtype	blank;
	chtype*	temp;
	chtype*	end;
	short	y;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("winsertln() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	blank	= win->_blank | win->_attrs;
	temp	= win->_y[win->_bmarg];

	for (y = win->_bmarg; y > win->_cury; y--)
	{
		win->_y[y]	 = win->_y[y - 1];
		win->_firstch[y] = 0;
		win->_lastch[y] = win->_maxx - 1;
	}

	win->_y[win->_cury] = temp;

	for (end = &temp[win->_maxx - 1]; temp <= end; temp++)
	{
		*temp = blank;
	}

	win->_firstch[win->_cury] = 0;
	win->_lastch[win->_cury] = win->_maxx - 1;

	return( OK );
}
