#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef	REGISTERWINDOWS
#ifdef PDCDEBUG
char *rcsid__addwin = "$Header: c:/curses/private/RCS/_addwin.c%v 2.0 1992/11/15 03:24:18 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_addwin()	- adds window

  PDCurses Description:
 	This routine adds the passed window pointer after the specified
 	window.	 If the specified window is NULL, then the passed
 	window pointer is inserted first in the list.

 	If the 'after' window is not on the visible list, then 'win'
 	will be added to the end of the list.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	An error will occur if we are unable to allocate a new WINDS
 	structure.

  Portability:
 	PDCurses	int	PDC_addwin( WINDOW* win, WINDOW* after );

**man-end**********************************************************************/

int	_addwin(WINDOW *win, WINDOW *after)
{
extern	void*	(*mallc)( size_t );
extern	void*	(*callc)( size_t, size_t );
extern	void	(*fre)( void* );

	WINDS  *root = _cursvar.visible;
	WINDS  *wlst = PDC_findwin(after);
	WINDS  *new  = (*mallc)(sizeof(WINDS));

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_addwin() - called\n");
#endif

	if (new == (WINDOW *)NULL)
		return( ERR );

	PDC_rmwin(win);
	memset(new, 0, sizeof(WINDS));
	new->w = win;
	if (wlst == (WINDS *)NULL)
	{
		if (root == (WINDS *)NULL)
			_cursvar.visible = new;
		else
		{
			root->tail->next = new;
			new->prev = root->tail;
			root->tail = new;
		}
	}
	else
	{
		if (root->next == NULL)
		{
			root->next = new;
			new->prev = root;
		}
		else
		if (wlst == root->tail)
		{
			root->tail->next = new;
			new->prev = root->tail;
			root->tail = new;
		}
		else
		{
			new->prev = wlst;
			new->next = wlst->next;
			if (wlst->next == NULL)
			{
				wlst->next = new;
				root->tail = new;
			}
			else
			{
				wlst->next->prev = new;
				wlst->next = new;
			}
		}
	}
	return( OK );
}
#endif
