#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__backchr = "$Header: c:/curses/private/RCS/_backchr.c%v 2.0 1992/11/15 03:24:15 MH Rel $";
#endif




/*man-start*********************************************************************

  PDC_backchar()	- Visually erase character in window

  PDCurses Description:
 	This is a private PDCurses function

 	This routine will visually erase a character.  It is called by
 	the PDCurses character I/O routines.

  PDCurses Return Value:
 	This routine will return OK upon success and otherwise ERR will be
 	returned.

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.

  Portability:
 	PDCurses	int	PDC_backchar( WINDOW* w, char* ch, int* len );

**man-end**********************************************************************/

int	PDC_backchar(WINDOW *w, char *ch, int *len)
{
	int	nbs = 0;
	int	x = w->_curx;
	int	ts = w->_tabsize;
	chtype*	s = &w->_y[w->_cury][x - 1];
	char*	p = c_strbeg;
	bool	save_raw_out = _cursvar.raw_out;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_backchar() - called\n");
#endif

	if (w == (WINDOW *)NULL)
		return( ERR );

	(*len)--;		/* Now we are zero relative */
	(*len)--;		/* Now we are looking at the previous
				 * character */
	nbs++;
	/*
	 * Determine number of characters to erase...
	 */
	if ((ch[*len] < ' ') || (*s == 0x7f))	/* ctrl-char has size 2	 */
	{
		nbs++;
		(*len)--;
	}

	if (ch[*len] == '\t')	/* tabs are very special */
	{
		for (; p < ch; p++)
		{
			if (*p == '\t')
				x = ((x / ts) + 1) * ts;
			else
			{
				if ((*p < ' ') || (*p == 0x7f))
					x += 2;
				else
					x++;
			}
			if (x >= w->_maxx)	/* go to next line? */
				x = 0;
		}
		if (!(w->_curx))
			nbs = w->_maxx - x;
		else
			nbs = w->_curx - x;
	}
	/*
	 * Erase the characters and update...
	 */
	_cursvar.raw_out = FALSE;  /* ensure backspace handled in xlat mode */
	while (nbs--)
	{
		if (w->_curx > 0)
		{
			waddstr(w, "\b \b");
		}
		else
		if (w->_cury)
		{
			mvwaddch(w, w->_cury - 1, w->_maxx - 1, ' ');
			wmove(w, w->_cury - 1, w->_maxx - 1);
		}
	}
	ch[*len] = '\0';
	_cursvar.raw_out = save_raw_out;
	wrefresh(w);
	return( OK );
}
